#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: set_sqwin.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 set_sqwin (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 len, 
                  ReaL_4 px1, ReaL_4 py1, ReaL_4 pz1, ReaL_4 px2, 
                  ReaL_4 py2, ReaL_4 pz2)
{
   extern struct config parm;
   struct window *wn;
   register ReaL_4 *f1, *f2;
   ReaL_4 conv[4];
   ReaL_4 adj;
   ByTe_4 proj;
   ByTe_1 error = 0;

   window (w,"SET_SQWIN");

   if (parm.univ > 7)
   {
       proj = parm.univ - 8;
       map_limits (proj, px1, py1, px2, py2, conv);
       px1 = conv[0];
       py1 = conv[1];
       px2 = conv[2];
       py2 = conv[3];
   }

   wn = parm.win;
   wn->open = 1;

/*** compute offset which will put the window in the center of  ***/
/*** the output device.                                         ***/

   if (wn->pos_fmt == 1)
   {
      len /= 2.0;
      x -= len;
      y -= len;
   }

   wn->type = 2;
   wn->dimen = (pz1 != pz2) ? 3:2;

   if (x >= 1.0 || y >= 1.0 || z >= 1.0)
   {
      g_error ("SET_SQWIN","WINDOW OFF SCREEN ; NOT OPENED",0);
      return (0);
   }

   f1    = wn->real;
   *f1++ = x;
   *f1++ = y;
   *f1   = z;

   for (f1 = wn->real; f1 < wn->real + wn->dimen; ++f1)
   {
       if (*f1 < 0.0)
       {
	  error = 1;
	  *f1 = 0.0;
       }
   }

   if (error)
      g_error ("SET_SQWIN","LOWER CORNER OUT OF PARENT WINDOW -- ADJUSTED",0); 

   error = 0;
   f2 = parm.drv->dev->mk_sq + 1;
   for (f1 = wn->real; f1 < wn->real + wn->dimen; ++f1)
   {
       adj = (f2 < parm.drv->dev->mk_sq) ? 1.0 : *f2--;
       if ((*f1 + len) / adj > 1.000001)
       {
	  error = 1;
	  len = 1.0 - *f1;
       }
   }

   if (error)
      g_error ("SET_SQWIN","UPPER CORNER OUT OF PARENT WINDOW -- ADJUSTED",0); 

   f1 = &wn->real[3];
   f2 = wn->real;
   *f1++ = *f2++ + len;
   *f1++ = *f2++ + len;
   *f1   = *f2 + len;
   
   wn->plot[0] = px1;
   wn->plot[1] = py1;
   wn->plot[2] = pz1;
   wn->plot[3] = px2;
   wn->plot[4] = py2;
   wn->plot[5] = pz2;

   scale_win (3);
   return (1);
}
