#include "gph_str.h" 
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: set_rsqwin.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 set_rsqwin(ByTe_1 w, ByTe_1 rw, ReaL_4 x, ReaL_4 y, ReaL_4 z, 
                  ReaL_4 len, ReaL_4 uxl, ReaL_4 uyl, ReaL_4 uzl, 
                  ReaL_4 uxh, ReaL_4 uyh, ReaL_4 uzh)
{
   extern struct config parm;
   struct window *wa,*wb;
   register ReaL_4 *f1, *f2, *fE;
   register ByTe_2 *s1, *s2, *sE;
   ByTe_1 Ec;

   Ec = (rw != parm.wn_num) ? window (rw,"SET_RSQWIN") : parm.win->open;
   if (Ec <= 0)
   {
      g_error ("SET_RSQWIN","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }
   wa = parm.win;

   window (w,"SET_RSQWIN");
   wb = parm.win;

/*** If the position of the window is given in terms of the scaling of ***/
/*** the base window then convert these values to absolute coordinates ***/
/*** in terms of the base window -- note that window scaling must be   ***/
/*** checked for all axis and included                                 ***/

   if (wb->cor_fmt == 1)
   {
      if (wa->axis[0] == 1)
      {
	 x   = log (x / wa->plot[0]) / (log (wa->plot[3] / wa->plot[0]));
	 len = log (len) / (log (wa->plot[3] / wa->plot[0]));
      }
      else
      {
	 x   = (x - wa->plot[0]) / (wa->plot[3] - wa->plot[0]);
	 len = len / (wa->plot[3] - wa->plot[0]);
      }
   
      if (wa->axis[1] == 1)
	 y = log (y / wa->plot[1]) / (log (wa->plot[4] / wa->plot[1]));
      else
	 y = (y - wa->plot[1]) / (wa->plot[4] - wa->plot[1]);

      if (wa->dimen == 3)
      {
         if (wa->axis[2] == 1)
	    z = log (z / wa->plot[2]) / (log (wa->plot[5] / wa->plot[2]));
         else
	    z = (z - wa->plot[2]) / (wa->plot[5] - wa->plot[2]);
      }
   }

/*** Now compute the location of the new window in terms of the absolute ***/
/*** coordinates of the plotting screen                                  ***/

   x = x * (wa->real[3] - wa->real[0]) + wa->real[0];
   y = y * (wa->real[4] - wa->real[1]) + wa->real[1];
   z = z * (wa->real[5] - wa->real[2]) + wa->real[2];
   len  = len * (wa->real[3] - wa->real[0]);

   s1 = wb->ang;
   s2 = wa->ang;
   sE = s1 + 3;
   for ( ; s1 < sE;)
      *s1++ = *s2++;

   f1 = wb->trig;
   f2 = wa->trig;
   fE = f1 + 6;
   for ( ; f1 < fE;)
      *f1++ = *f2++;
   
   set_sqwin(w,x,y,z,len,uxl,uyl,uzl,uxh,uyh,uzh); 

   wb->type = (wa->type == 2 || wa->type > 4) ? 6 : 4;
   return (1);
}
