#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: set_relwin.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 set_relwin (ByTe_1 w, ByTe_1 rw, ReaL_4 xl, ReaL_4 yl, ReaL_4 zl, 
                   ReaL_4 xh, ReaL_4 yh, ReaL_4 zh, ReaL_4 uxl, ReaL_4 uyl, 
                   ReaL_4 uzl, ReaL_4 uxh, ReaL_4 uyh, ReaL_4 uzh)
{
   extern struct config parm;

   register struct window *wa,*wb;
   register ReaL_4 *f1, *f2, *fE;
   register ByTe_2 *s1, *s2, *sE;

   ReaL_4 dxr,dyr,dzr;
   ReaL_4 xL, xU;
   ByTe_1 Ec;

/*** see if traget window has been defined ***/

   Ec = (rw != parm.wn_num) ? window (rw,"SET_RELWIN") : parm.win->open;
   if (Ec <= 0)
   {
      g_error ("SET_RELWIN","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }
   wa = parm.win;

   window (w,"SET_RELWIN");
   wb = parm.win;

   if (wb->cor_fmt == 1)
   {
      xL = wa->plot[0];
      xU = wa->plot[3];

      if (wa->axis[0] == 1)
      {
	 xl   = log10(xl / xL) / (log10(xU / xL));
         if (wb->dis_fmt)
	    xh   = log10(xh) / (log10(xU / xL));
	 else
	    xh   = log10(xh / xL) / (log10(xU / xL));
      }
      else
      {
	 xl   = (xl - xL) / (xU - xL);
         if (wb->dis_fmt)
	    xh   = xh / (xU - xL);
	 else
	    xh   = (xh - xL) / (xU - xL);
      }
   
      if (wa->axis[1] == 1)
      {
	 yl = log10(yl / wa->plot[1]) / (log10(wa->plot[4] / wa->plot[1]));
         if (wb->dis_fmt)
	    yh = log10(yh) / (log10(wa->plot[4] / wa->plot[1]));
	 else
	    yh = log10(yh / wa->plot[1]) / (log10(wa->plot[4] / wa->plot[1]));
      }
      else
      {
	 yl = (yl - wa->plot[1]) / (wa->plot[4] - wa->plot[1]);
         if (wb->dis_fmt)
	    yh = yh / (wa->plot[4] - wa->plot[1]);
	 else
	    yh = (yh - wa->plot[1]) / (wa->plot[4] - wa->plot[1]);
      }

      if (wa->dimen == 3)
      {
         if (wa->axis[2] == 1)
	 {
	    zl = log10(zl / wa->plot[2]) / (log10(wa->plot[5] / wa->plot[2]));
            if (wb->dis_fmt)
	       zh = log10(zh) / (log10(wa->plot[5] / wa->plot[2]));
	    else
	       zh = log10(zh / wa->plot[2]) / (log10(wa->plot[5] / wa->plot[2]));
         }
         else
         {
	    zl = (zl - wa->plot[2]) / (wa->plot[5] - wa->plot[2]);
            if (wb->dis_fmt)
	       zh = zh / (wa->plot[5] - wa->plot[2]);
	    else
	       zh = (zh - wa->plot[2]) / (wa->plot[5] - wa->plot[2]);
         }
      }
   }

   dxr = wa->real[3] - wa->real[0];
   dyr = wa->real[4] - wa->real[1];
   dzr = wa->real[5] - wa->real[2];

   xl = xl*dxr + wa->real[0];
   yl = yl*dyr + wa->real[1];
   zl = zl*dzr + wa->real[2];

   if (wb->dis_fmt)
   {
      xh = xh*dxr;
      yh = yh*dyr;
      zh = zh*dzr;
   }
   else
   {
      xh = xh*dxr + wa->real[0];
      yh = yh*dyr + wa->real[1];
      zh = zh*dzr + wa->real[2];
   }

   s1 = wb->ang;
   s2 = wa->ang;
   sE = s1 + 3;
   for ( ; s1 < sE;)
      *s1++ = *s2++;

   f1 = wb->trig;
   f2 = wa->trig;
   fE = f1 + 6;
   for ( ; f1 < fE;)
      *f1++ = *f2++;
   
   if (parm.ostyle == 0)
      set_win (w,xl,yl,zl,xh,yh,zh,uxl,uyl,uzl,uxh,uyh,uzh);
   else
      set_win (w,1.0 - xl,yl,zl,1.0 - xh,yh,zh,uxl,uyl,uzl,uxh,uyh,uzh);

   wb->type = (wa->type == 2 || wa->type > 4) ? 5 : 3;
   return (1);
}
