#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: scale_win.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void scale_win (ByTe_1 todo)
{
   extern struct config parm;
   register struct window *wn;

   register ReaL_4 *f1,*f2, *f3;
   register ByTe_1 *c1;
   ReaL_4 TmP;

   wn = parm.win;

   if (parm.ostyle > 0)
   {
      if ((todo & 1) == 1)
      {
         TmP = wn->real[0];
         wn->real[0] = 1.0 - wn->real[3];
         wn->real[3] = 1.0 - TmP;
      }

      if ((todo & 2) == 2)
      {
         TmP = wn->plot[0];
         wn->plot[0] = wn->plot[3];
         wn->plot[3] = TmP;
      }
   }
   f2 = &wn->plot[3];
   f3 = wn->slope;
   c1 = wn->axis;
   for (f1 = wn->plot; f1 < wn->plot + wn->dimen; ++f1,++f2) 
   {
      if (*c1++ == 1)  
      {
         if (*f1 <= 0 || *f2 <= 0)  
            g_error ("SCALE_WIN","NEGATIVE SCALING ON LOG AXIS",1);

         TmP = log10 (*f2 / *f1);
      }
      else
         TmP = *f2 - *f1;                                                   

      if (TmP == 0.0)  
         g_error ("SCALE_WIN","AXIS LENGHT IS 0",1);

      *f3++ = 32767.0/TmP;  
   }
}
