#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: rot_win.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void rot_win (ByTe_1 w, ByTe_1 axis, ReaL_4 rotang, ByTe_1 flg)
{

   extern struct config   parm;
   register struct window *wn;
   register ByTe_2 *angle;
   register ReaL_4 *tval;

   if (w != parm.wn_num) 
      window (w,"ROT_WIN");

   wn = parm.win;

   angle = &wn->ang[axis - 'x'];
   tval = &wn->trig[2*(axis - 'x')];
     
   *angle = (flg) ? *angle + rotang * 10.0 : rotang * 10.0; 

   while (*angle > 3600)
      *angle -= 3600;
        
   while (*angle < 0)
      *angle += 3600;
          
   *tval++ = cosin(rotang);
   *tval = sine(rotang);
}
