#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: poly.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  DESCRIPTION                                                            */
/*    Poly draws a polygon with the vertices passed by the user in a given */
/*    graphics window                                                      */
/*                                                                         */
/*  INPUT VARIABLES                                                        */
/*    char   w        window number in which to draw polygon               */
/*    float  x        x co-ordinates of vertices                           */
/*    float  y        y co-ordinates of vertices                           */
/*    float  z        z co-ordinates of vertices                           */
/*    short  n        number of vertices                                   */
/*                                                                         */
/*  USAGE                                                                  */
/*    poly (w,x,y,z,n)                                                     */
/*                                                                         */
/*  NECESSARY SUBPROGRAMS                                                  */
/*    dg._line()     output line(s) to graphics device                     */
/*    dg._poly()     output polygon to graphics device                     */
/*    to_univcor()   takes a three dimensional set of data points which    */
/*                   is placed within the array rr[] and returns a two     */
/*                   dimensional set of data points in 32767 space which   */
/*                   have been tranlated according to the window in        */
/*                   which the data is to be plotted                       */
/*    window ()      check to see if requested window has been allocated   */
/*                                                                         */
/*  EXTERNAL VARIABLES                                                     */
/*    float rr[]           array of (x,y,x) cordinates to be translated    */
/*                         into polt coordinates (0 to 32767) by the       */
/*                         trans subprogram.                               */
/*    char  minst[]        array of move or draw commands  (0 move pen     */
/*                         and 1 draw)                                     */
/*    struct dev_graph dg  structure holding the pointers to the graphics  */
/*                         device drivers                                  */
/*    struct config parm   structure containing the current status of the  */
/*                         graphics variables                              */
/*                                                                         */
/*  INTERNAL VARIABLES                                                     */
/*    float *f1      pointer to the input x co-ordinate array              */
/*    float *f2      pointer to the input y co-ordinate array              */
/*    float *f3      pointer to the input z co-ordinate array              */
/*    float *f4      pointer into the rr[] array                           */
/*    char  *p       pointer into the minst[] array                        */
/*    char  close    indicates whether the polygon has been input closed   */
/*                   (0) or open (1)                                       */
/*                                                                         */
/***************************************************************************/

ByTe_4 poly (ByTe_1 w, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_2 n)
{ 
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct dev_graph *dg, *dg_end;
   register ReaL_4 *f1,*f2,*f3,*f4, *fend;
   register ByTe_1 *p;
   ByTe_1 *p_end;
   ByTe_4 proj;
   ByTe_2 nr[2], start,npt,npts,loops = 0;
   ByTe_1 err_code;
   ByTe_2 max_pts;
   ByTe_1 close;
   ByTe_1 make_line;

   if (n <= 0)
   {
      g_error ("POLY","NO POINTS PASSED INTO POLY",0);
      return (0);
   }

/***************************************************************************/
/*  check to see if the requested window in which the polygon is to be     */
/*  drawn has been opened and defined                                      */
/***************************************************************************/

   err_code = (w != parm.wn_num) ? window (w,"POLY") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("POLY","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   if (parm.univ > 7 && parm.fill >= 0)
   {
      proj = parm.univ - 8;
      map_poly (x,y,z,n,nr);
      if (nr[0] > 0)
      {
         f1 = (ReaL_4 *)minfo.mxyz; 
         fend = f1 + 2 * nr[0];
         for ( ; f1 < fend; f1 += 2)
         {
             if (mapxy (f1, f1+1, proj) == 0)
             {
                nr[0] = 0;
                break;
             }
         }
       
         if (nr[0] > 0)
         {
            p = (ByTe_1 *)minfo.cmd;
            p_end = p + nr[0];
            *p++ = 0;
            for ( ; p < p_end;)
                *p++ = 1;

            npts = to_univcor (nr[0],f1,1);
            dg = parm.drv;
            dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
            while (parm.drv < dg_end)
            {
               parm.drv->_poly (nr[0]);
               ++parm.drv;
            }
            parm.drv = dg;
         }
      }
      if (nr[1] > 0)
      {
         start = (ival.points - 2) / 2;
         f1 = (ReaL_4 *)minfo.mxyz + start; 
         f2 = (ReaL_4 *)minfo.mxyz;
         fend = f1 + 2 * nr[1];
         for ( ; f1 < fend; )
         {
             if (mapxy (f1, f1+1, proj) == 0)
             {
                nr[1] = 0;
                break;
             }
             else
             {
                *f2++ = *f1++;
                *f2++ = *f1++;
             }
         }
       
         if (nr[1] > 0)
         {
            p = (ByTe_1 *)minfo.cmd;
            p_end = p + nr[1];
            *p++ = 0;
            for ( ; p < p_end;)
                *p++ = 1;

            npts = to_univcor (nr[1],f1,1);
            dg = parm.drv;
            dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
            while (parm.drv < dg_end)
            {
               parm.drv->_poly (npts);
               ++parm.drv;
            }
            parm.drv = dg;
         }
      }
   }
   else
   {
      close = (x[0] != x[n-1] || y[0] != y[n-1]) ? 1 : 0;
      if (parm.win->dimen == 3)
         if (z[0] != z[n-1])
            close = 1;

      make_line = (n == 1) ? 1 : (n < 3 || (n == 3 && close == 0)) ? 2 : 0; 

/***************************************************************************/
/* fill the minst array - the first point is always a move and the         */
/* remaining are always draws for a polygon                                */
/***************************************************************************/

      max_pts = ival.points - 2;
      do
      {
          if (n > max_pts)
          {
             npts = max_pts;
             npt  = max_pts;
             n   -= (parm.fill >= 0) ? max_pts -1 : max_pts;
          }
          else
          {
             npts = (n == max_pts) ? max_pts : n;
             npt  = n;
             n   -= max_pts;
          }

/***************************************************************************/
/*  fill the rr[] array with the vertices of the polygon -  note that the  */
/*  first data point is placed at both the beginning and the end of the    */
/*  array to close the polygon                                             */
/***************************************************************************/
        
           start = loops*max_pts;
           f4 = (ReaL_4 *)minfo.mxyz;

	   if (loops > 0 && parm.fill >= 0)
	   {
	      *f4++ = x[0];
	      *f4++ = y[0];
	      if (parm.win->dimen == 3)
	      *f4++ = z[0];
	      ++npts;
	      start -= loops;
           }

           f1 = x+start;
           f2 = y+start;
           f3 = z+start;

           if (parm.win->dimen == 3)
	   {
              while (f1 < x+start+npt)
              {
                 *f4++ = *f1++;
                 *f4++ = *f2++;
                 *f4++ = *f3++;
              }
           }
	   else
	   {
              while (f1 < x+start+npt)
              {
                 *f4++ = *f1++;
                 *f4++ = *f2++;
              }
	   }

/***************************************************************************/
/*  Go through all the end checks -  is this a viable polygon and if so    */
/*  do we need to close it.  If not is it a point and do we need to        */
/*  complete it so line will know what to do.                              */
/***************************************************************************/

         if (n < 0)
         {
            if (make_line != 0)
            {
               if (make_line == 1);
               {
                  *f4++ = *x; 
                  *f4++ = *y; 
	          if (parm.win->dimen == 3)
                     *f4 = *z; 
	          ++npts;
               }
            }
            else
            {
	       if (close)
	       {
                  *f4++ = *x; 
                  *f4++ = *y; 
	          if (parm.win->dimen == 3)
                     *f4 = *z; 
	          ++npts;
               }
            }
         }
	 else
         {
            if (parm.fill >= 0)
	    {
	       *f4++ = *x;
	       *f4++ = *y;
	       if (parm.win->dimen == 3)
	          *f4   = *z;
	       ++npts;
            }
         }

         p = (ByTe_1 *)minfo.cmd;
         p_end = p + npts;
         *p++ = (loops == 0 || parm.fill >= 0) ? 0 : 1;
         for ( ; p < p_end;)
             *p++ = 1;

/***************************************************************************/
/*  translate the data points according to the window paramaters of the    */
/*  window the polygon is to be drawn in.  The translated data is placed   */
/*  in the array mr[] (external) and is in the range 0 to 32767            */
/***************************************************************************/

        npts = to_univcor (npts,f4,1);

/***************************************************************************/
/*  Plot the polygon on the output device.  If the polygon is to be filled */
/*  then call the device independent polygon fill routine otherwise just   */
/*  use the device independent line command to draw the polygon            */
/***************************************************************************/

        if (parm.fill < 0 || make_line != 0)
        {
           dg = parm.drv;
           dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
           while (parm.drv < dg_end)
           {
              parm.drv->_line (npts,1);
              ++parm.drv;
           }
           parm.drv = dg;
        }
        else
        {
           dg = parm.drv;
           dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
           while (parm.drv < dg_end)
           {
              parm.drv->_poly (npts);
              ++parm.drv;
           }
           parm.drv = dg;
        }

        ++loops;
 
     } while (n >= 0);
  }
  return (1);
}
