#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: polar_box.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 polar_box (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 xx, ReaL_4 yy)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct dev_graph *dg, *dg_end;

   register ReaL_4 *f1;
   register ByTe_1  *c1, *c_end;

   ReaL_4 ang, sep, delta = 0.5;

   ByTe_4 size, pnts;

   ByTe_2 npts = 0;

   ByTe_1 err_code;
   ByTe_1 save;

   err_code = (w != parm.wn_num) ? window (w,"POLAR_BOX") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("POLAR_BOX","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   save = parm.univ; 
   plt_corsys (4);

   size = ival.points * 3;

/************************************************************************************/
/*  Make the tacit assumption that the box is going from y to yy so that if yy is   */
/*  less than y then we have crossed the 360 degree line and we must do something   */
/*  about it.                                                                       */
/************************************************************************************/

   if (yy < y)
      yy += 360.0;

   sep = yy - y;

   pnts =  2 * (sep / delta) + 8;
   while (pnts > size)
   {
      delta += .5;
      pnts =  2 * (sep / delta) + 8;
   }

   f1 = (ReaL_4 *)minfo.mxyz;

   ang = y;
   while (ang <= yy)
   {
      *f1++ = x;
      *f1++ = ang;
      ang += delta; 
      ++npts;
   }

   if (ang != yy)
   {
      *f1++ = x;
      *f1++ = yy;
      ++npts;
   }

   ang = yy;
   while (ang >= y)
   {
      *f1++ = xx;
      *f1++ = ang;
      ang -= delta; 
      ++npts;
   }

   if (ang != y)
   {
      *f1++ = xx;
      *f1++ = y;
      ++npts;
   }

   *f1++ = x; 
   *f1 = y;
   ++npts;

   c1 = (ByTe_1 *)minfo.cmd;
   c_end = (ByTe_1 *)minfo.cmd + npts;
   *c1++ = 0;
   for ( ; c1 < c_end;)
       *c1++ = 1;

/***************************************************************************/
/*  translate the data points according to the window paramaters of the    */
/*  window the polygon is to be drawn in.  The translated data is placed   */
/*  in the array mr[] (external) and is in the range 0 to 32767            */
/***************************************************************************/

   f1 = (ReaL_4 *)minfo.mxyz;
   npts = to_univcor (npts,f1,1);

/***************************************************************************/
/*  Plot the polygon on the output device.  If the polygon is to be filled */
/*  then call the device independent polygon fill routine otherwise just   */
/*  use the device independent line command to draw the polygon            */
/***************************************************************************/

   if (parm.fill < 0 )
   {
      dg = parm.drv;
      dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
      while (parm.drv < dg_end)
      {
         parm.drv->_line (npts,1);
         ++parm.drv;
      }
      parm.drv = dg;
   }
   else
   {
      dg = parm.drv;
      dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
      while (parm.drv < dg_end)
      {
         parm.drv->_poly (npts);
         ++parm.drv;
      }
      parm.drv = dg;
   }

  plt_corsys (save);
  return (1);
}
