#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: point.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  DESCRIPTION                                                            */
/*    Point draws a point at the coordinates and in the window specified   */
/*                                                                         */
/*  INPUT VARIABLES                                                        */
/*    char   w        window number in which to draw point                 */
/*    float  x        x co-ordinate of point                               */
/*    float  y        y co-ordinate of point                               */
/*    float  z        z co-ordinate of point                               */
/*                                                                         */
/*  USAGE                                                                  */
/*    point (w,x,y,z)                                                      */
/*                                                                         */
/*  NECESSARY SUBPROGRAMS                                                  */
/*    window ()      check to see if requested window has been allocated   */
/*                                                                         */
/*  EXTERNAL VARIABLES                                                     */
/*    parm           structure containing the current graphics parameters  */
/*    err_code       error flag indicating if window is available or not   */
/*                                                                         */
/*  INTERNAL VARIABLES                                                     */
/*    none                                                                 */
/*                                                                         */
/***************************************************************************/

ByTe_4 point (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z)
{
   extern struct config parm;
   ByTe_1 err_code;

/***************************************************************************/
/*  check to see if the window in which the point is to be drawn has been  */
/*  defined                                                                */
/***************************************************************************/

   err_code = (w != parm.wn_num) ? window (w,"POINT") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("POINT","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   mv_n_drw (w, x, y, z, 0, 0);
   mv_n_drw (w, x, y, z, 1, 1);
   return (1);
}
