#include "gph_str.h"
#include "gph_ansi.h"
#include <stdlib.h>

static ByTe_1 rcsid[] = "$Id: open_seg.c,v 1.1.1.1 2000/02/01 15:56:59 chrisg Exp chrisg $";

ByTe_4 open_seg (ByTe_1 segn, ByTe_1 segsz, ByTe_1 type, ByTe_1 append)
{

   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   register struct segment *sg, *sg_end;
   register ByTe_2 loop;
   register ByTe_4 bytes;
   ByTe_4 maxlen;
   ByTe_1 pos = 0, free_seg;

   if (parm.sg_num >= 0)
      parm.drv->_clseg ();

   if (minfo.mseg == NOMEM)
   {
      bytes = ival.segments * sizeof ( struct segment );
      if ((minfo.mseg = malloc (bytes)) == NOMEM)
      {
	 g_error ("OPEN_SEG","CANNOT ALLOCATE MEMORY FOR SEGMENT",0);
	 return (0);
      }
      free_seg = 0;
      sg = (struct segment *) minfo.mseg;
      sg->seg_num     = -1;
      sg->mpt         = NOMEM;
      sg->def         = -1;
      sg->mx_len      = -1;
   }
   else
   {
      free_seg = -1;
      sg = (struct segment *) minfo.mseg;
      sg_end = sg + ival.segments;
      for ( ; sg < sg_end; ++sg, ++pos)  
         if (sg->seg_num == segn) 
	 {
	    free_seg = pos;
	    break;
         }
         else
	    if (sg->def == -1)
	        free_seg = pos;
   }

   if (free_seg == -1)
   {
      bytes = ++ival.segments * sizeof (struct segment);
      if ((minfo.mseg = realloc (minfo.mseg, bytes)) == NOMEM)
      {
	 g_error ("OPEN_SEG","CANNOT EXPAND SEGMENT ARRAY",0);
	 return (0);
      }
      free_seg = ival.segments - 1;
      sg = (struct segment *) minfo.mseg;
      sg->seg_num     = -1;
      sg->mpt         = NOMEM;
      sg->def         = -1;
      sg->mx_len      = -1;
   }

/*** determine the number of bytes long the segment should be ***/
/*** initialize to                                            ***/

   sg = (struct segment *) minfo.mseg + free_seg;

   if (segsz > 0)
   {
      bytes = 1;
      for (loop = 0; loop < segsz; ++loop)
          bytes *= 2;
   }
   else
      bytes = parm.drv->dev->seg_inc;


   if ((maxlen = parm.drv->_opseg (segn,bytes,type,append)) < 0)
   {
      if (sg->def < 0)
      {
	 sg->seg_num = segn;
         sg->mx_len = bytes;
         if ((sg->mpt = malloc (sg->mx_len)) == NOMEM) 
         {
            g_error ("OPEN_SEG","CANNOT ALLOCATE MEMORY FOR SEGMENT",0);
            return (0);
         }
         sg->wpt = (ByTe_1 *)sg->mpt;
         sg->def = 1;
         sg->cur_len     = 0;
         sg->lst_out_len = 0;
         sg->type        = 0;
      }
      else
      {
         if (bytes > sg->mx_len)
         {
            if ((sg->mpt = realloc (sg->mpt,bytes)) == NOMEM)
	       g_error ("OPEN_SEG","CANNOT ENLARGE SEGMENT SIZE",0);
            else
	    {
               sg->wpt = (ByTe_1 *)sg->mpt + sg->cur_len;
	       sg->mx_len = bytes;
            }
         }

         if (!append)
         {
            sg->wpt         = (ByTe_1 *)sg->mpt;
            sg->cur_len     = 0;
            sg->lst_out_len = 0;
            sg->type        = 0;
         }
      }
   }

   parm.seg = sg; 
   parm.sg_num = segn;
   return (1);
}
