#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: mv_winorig.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 mv_winorig (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z)
{

   extern struct config parm;
   struct window *wn;
   register ReaL_4 *f1, *f2, Z;
   register ByTe_1  *c1, *c_end;
   ByTe_1 err_code;

   err_code = (w != parm.wn_num) ? window (w,"MV_WINORIG") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("MV_WINORIG","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   wn = parm.win;

   Z = (wn->dimen == 2) ? 0.0 : z;

   f1  = wn->plot;

   *f1++ += x;
   *f1++ += y;
   *f1++ += Z;
   *f1++ += x;
   *f1++ += y;
   *f1   += Z;

   f1 = wn->plot;
   f2 = f1 + 3;
   c_end = wn->axis + wn->dimen;
   for (c1 = wn->axis; c1 < c_end; ++c1, ++f1, ++f2)
   {
       if (*c1 == 1 && (*f1 <= 0.0 || *f2 <= 0.0))
       {
          g_error ("MV_WINORIG","AXIS SCALED <= 0 WITH LOG SCALING",0);
          return (0);
       }
   }
  
   scale_win (0);
   return (1);
}
