#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: mv_n_drw.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  DESCRIPTION                                                            */
/*    Mv_n_drw allows points to be designated in a given graphics window   */
/*    which can either be connected by a line to the previous point or     */
/*    begin a new line                                                     */
/*                                                                         */
/*  INPUT VARIABLES                                                        */
/*    char   w        window number in which action takes place            */
/*    float  x        x co-ordinate of data                                */
/*    float  y        y co-ordinate of data                                */
/*    float  z        z co-ordinate of data                                */
/*    char   pen      flag indicating wheather to connect (1) this         */
/*                    data point to the last or to (0) make this data      */
/*                    point the beginning of a new line                    */
/*    char hold       flag controling the output of the data point array   */
/*                      0  store data point for later display              */
/*                      1  output all data points including the current    */
/*                         data point                                      */
/*                      2  output all data points excluding the current    */
/*                         data point which is not saved (flush option)    */
/*                                                                         */
/*  USAGE                                                                  */
/*    mv_n_drw (w,x,y,z,pen,hold)                                          */
/*                                                                         */
/*  NECESSARY SUBPROGRAMS                                                  */
/*    dg._line()     output data to graphics device                        */
/*    get_scrcor()   takes a three dimensional data points within a        */
/*                   specific window and returns an (x,y) pair within      */
/*                   the limits 0 to 32767 which can be used as input to   */
/*                   any device plotting routine.  Get_scrcor() takes into */
/*                   account all window rotations, inversions and the like */
/*    window ()      check to see if requested window has been allocated   */
/*                                                                         */
/*  EXTERNAL VARIABLES                                                     */
/*    short mr[]           array of (x,y) data points in 32767 space ready */
/*                         to be output to the graphics device. X          */
/*                         coordinates are located in even positions and Y */
/*                         coordinates in the odd positions                */
/*    char  minst[]        array of move or draw commands as indicated by  */
/*                         pen for each of the data (x,y) pairs            */
/*    struct dev_graph dg  structure holding the pointers to the graphics  */
/*                         device drivers                                  */
/*                                                                         */
/*  INTERNAL VARIABLES                                                     */
/*    short *pos     pointer into the mr[] array                           */
/*    char  *pp      pointer into the minst[] array                        */
/*    float in[3]    array used to pass the input coordinates into         */
/*                   get_scrcor() routine                                  */
/*    short out[3]   array containing the output of get_scrcor             */
/*    short pnts     static variable used to keep track of the current     */
/*                   number of data points in mr[]                         */
/*                                                                         */
/***************************************************************************/
  

ByTe_4 mv_n_drw (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ByTe_1 pen, 
                 ByTe_1 hold)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct dev_graph *dg, *dg_end;
   register ReaL_4 *pos;
   register ByTe_1 *pp;
   ReaL_4 xtmp, ytmp;
   ByTe_4 proj;
   static ReaL_4 xx[2], yy[2];
   static ByTe_2 pnts = 0;
   static ByTe_1 ready = 0;
   ByTe_1 err_code;


/***************************************************************************/
/*  check to see if requested window has been allocated and defined        */
/***************************************************************************/

   dg = parm.drv;
   err_code = (w != parm.wn_num) ? window (w,"MV_N_DRW") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("MV_N_DRW","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

/***************************************************************************/
/*  set pointers to minst[] and mr[] to the locations locations to contain */
/*  the information for this data point                                    */
/***************************************************************************/

   pos = (ReaL_4 *)minfo.mxyz + pnts * parm.win->dimen;
   pp  = (ByTe_1 *)minfo.cmd + pnts;

   if (hold < 2)
   {
      if (parm.univ > 7 )
      {
         proj = parm.univ - 8;

         xtmp = x;
         ytmp = y;
         translate_map (&xtmp, &ytmp, 1);

         if (pen == 0 || ready == 0)
         {
            xx[0] = xtmp;
            yy[0] = ytmp;

            ready = mapxy (&xtmp, &ytmp, proj);
            if (ready == 1)
            {
               *pos++ = xtmp;
               *pos++ = ytmp;
               if (parm.win->dimen == 3)
                  *pos   = z;
               *pp++   = 0;
               ++pnts;
            }
         }
         else
         {
            xx[1] = xtmp;
            yy[1] = ytmp;
            ready = chk_map_line (xx,yy,xx,pos,pp,parm.win->dimen,&pnts);
            xx[0] = xx[1];
            yy[0] = yy[1];
         }
      }
      else
      {

/***************************************************************************/
/*  store the (x,y) data pair and the move instructions for this data      */
/*  point.  The data point counter is then incremented                     */
/***************************************************************************/
   
         *pos++ = x;
         *pos++ = y;
         if (parm.win->dimen == 3)
            *pos   = z;
         *pp    = pen;
         ++pnts;
       }
    }

/***************************************************************************/
/*  check to see if there are more than 1000 data points within the data   */
/*  point array -- if there are and the routine is not requesting a flush  */
/*  then force a flush at this point to keep from running over the mr[]    */
/*  minst[] arrays                                                         */
/***************************************************************************/

   if (pnts > ival.points - 2 && hold != 2)
      hold = 1;

/***************************************************************************/
/*  take care of outputing the data.  If the data is to be output then     */
/*  reset the data point counter to 0.  If the current data point is not   */
/*  to be output the decrement the data point counter begofe passing it to */
/*  the output routine                                                     */
/***************************************************************************/

   switch (hold)
   {
      case 0:
         break;
      case 1:
         to_univcor (pnts,pos,1);
         dg = parm.drv;
         dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
         while (parm.drv < dg_end)
         {
            parm.drv->_line (pnts,0);
            ++parm.drv;
         }
         parm.drv = dg;
         pnts = 0;
         ready = 0;
         break;
      case 2:
         if (pnts > 1)
         {
             dg = parm.drv;
             to_univcor (pnts,pos,1);
             dg = parm.drv;
             dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
             while (parm.drv < dg_end)
             {
                parm.drv->_line (pnts,0);
                ++parm.drv;
             }
             parm.drv = dg;
         }
         pnts = 0;
         ready = 0;
         break;
    }
    return (1);
}
