#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: mapxy.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 mapxy (ReaL_4 *x, ReaL_4 *y, ByTe_4 proj)
{
   extern struct mapinfo map;
   ReaL_4 z1, tmp1, tmp2;
   ReaL_4 xtmp, ytmp;
   ByTe_1 val = 1;

   switch (proj)
   {
      case 0:
         break;
      case 1:
         *y = atan2 (*y, sqrt (8100.0 - *y * *y));
         break;
      case 2:
         *x = *x * cosin (*y);
         break;
      case 3:
         *x = *x * sqrt (1 - *y * *y / 8100.0);
         break;
      case 4:
         *x = *x * (cosin (*y) + 1.0) / 2.0;
      case 5:
         *x = *x * ( sqrt (1 - *y * *y / 8100.0) + 1.0 ) / 2.0;
         break;
      case 6:
         tmp1 = *x;
         tmp2 = 90.0 - *y;
         *x = tmp2 * cosin (tmp1);
         *y = tmp2 * sine (tmp1);
         break;
      case 7:
         tmp1 = *x;
         tmp2 = *y;
         xtmp = sine (map.center);
         ytmp = cosin (map.center); 
         *x = cosin (tmp2) * sine(tmp1);
         *y = cosin (tmp2) * cosin (tmp1) * xtmp + sine (tmp2) * ytmp;
         z1 = cosin (tmp2) * cosin (tmp1) * ytmp - sine (tmp2) * xtmp;
         if (z1 < 0.0)
            val = 0;
         break;
      case 8:
         tmp1 = map.center;
         tmp2 = *y - map.center;
         if ((tmp2 < -89.0 || tmp2 > 89.0) || (tmp1 > -1.0 && tmp1 < 1.0))
            val = 0;
         else
         {
            xtmp = sine (tmp2) / cosin (tmp2);
            ytmp = cosin (tmp1) / sine (tmp1); 
            z1 = ytmp - xtmp;
            tmp1 = *x;
            *x = z1 * cosin (tmp1); 
            *y = z1 * sine (tmp1); 
         }
         break;
   }

   return (val);
}
