#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: map_poly.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void map_poly (ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_2 n, ByTe_2 *nr)
{ 
   extern struct memory minfo;
   extern struct init_val ival;
   register ReaL_4 *f1,*f2,*f3,*fend;
   register ByTe_2 *s1;
   ReaL_4 y3;
   ByTe_2 offset[2];
   ByTe_2 C;

   *nr = 0;
   *(nr+1) = 0;

   offset[0] = 0;
   offset[1] = (ival.points - 2) / 2;
   translate_map (x,y,(ByTe_4)n);

   C = wrap_long(x[0], y[0], x[1], y[1], &y3);
   if (C >= 0)
   {
      s1 = nr + C;
      f3 = (ReaL_4 *)minfo.mxyz + offset[C];

      *f3++ = x[0];
      *f3++ = y[0];
      *f3++ = x[1];
      *f3++ = y[1];
      *s1 += 2;
   }
   else
   {
      if (x[0] > 0.0)
      {
         s1 = nr;
         f3 = (ReaL_4 *)minfo.mxyz + offset[0];

         *f3++ = x[0];
         *f3++ = y[0];
         ++(*s1);
         *f3++ = 180.0;
         *f3++ = y3;
         ++(*s1);

         s1 = nr + 1;
         f3 = (ReaL_4 *)minfo.mxyz + offset[1];

         *f3++ = -180.0;
         *f3++ = y3;
         ++(*s1);
         *f3++ = x[1];
         *f3++ = y[1];
         ++(*s1);
      }
      else
      {
         s1 = nr + 1;
         f3 = (ReaL_4 *)minfo.mxyz + offset[1];

         *f3++ = x[0];
         *f3++ = y[0];
         ++(*s1);
         *f3++ = -180.0;
         *f3++ = y3;
         ++(*s1);

         s1 = nr;
         f3 = (ReaL_4 *)minfo.mxyz + offset[0];

         *f3++ = 180.0;
         *f3++ = y3;
         ++(*s1);
         *f3++ = x[1];
         *f3++ = y[1];
         ++(*s1);
      }
   }

   fend = x + n - 1;

   for (f1 = x+1, f2 = y+1; f1 < fend; ++f1, ++f2)
   {
       if ((C = wrap_long(*f1, *f2, *(f1+1), *(f2+1), &y3)) >= 0)
       {
          *f3++ = *(f1 + 1);
          *f3++ = *(f2 + 1);
          ++(*s1);
       }
       else
       {
          C = (*f1 > 0.0) ? 1 : 0;
          *f3++ = (C == 1) ? 180.0 : -180.0;
          *f3++ = y3;
          ++(*s1);

          s1 = nr + C;
          f3 = (ReaL_4 *)minfo.mxyz + offset[C] + 2 * *s1;

          *f3++ = (C == 0) ? 180.0 : -180.0;
          *f3++ = y3;
          ++(*s1);
          *f3++ = *(f1 + 1);
          *f3++ = *(f2 + 1);
          ++(*s1);
       }
   }

   if (x[0] != x[n-1] || y[0] != y[n-1])
   {
      C = wrap_long(x[n-1], y[n-1], x[0], y[0], &y3);
      if (C >= 0)
      {
         s1 = nr + C;
         f3 = (ReaL_4 *)minfo.mxyz + offset[C] + 2 * *s1;

         *f3++ = x[0];
         *f3++ = y[0];
         ++(*s1);
      }
      else
      {
         if (x[0] > 0.0)
         {
            s1 = nr;
            f3 = (ReaL_4 *)minfo.mxyz + 2 * *s1;

            *f3++ = 180.0;
            *f3++ = y3;
            ++(*s1);

            s1 = nr + 1;
            f3 = (ReaL_4 *)minfo.mxyz + offset[1] + 2 * *s1;

            *f3++ = -180.0;
            *f3++ = y3;
            ++(*s1);
         }
         else
         {
            s1 = nr + 1;
            f3 = (ReaL_4 *)minfo.mxyz + offset[1] + 2 * *s1;

            *f3++ = -180.0;
            *f3++ = y3;
            ++(*s1);

            s1 = nr;
            f3 = (ReaL_4 *)minfo.mxyz + 2 * *s1;

            *f3++ = 180.0;
            *f3++ = y3;
            ++(*s1);
         }
      }
   }

   if (nr[0] > 0)
   {
      f1 = (ReaL_4 *)minfo.mxyz;
      f2 = (ReaL_4 *)minfo.mxyz + (nr[0] - 1) * 2;
      if (*f1 != *f2 || *(f1+1) != *(f2+1))
      {
         f3 = (ReaL_4 *)minfo.mxyz + nr[0] * 2;
         *f3++ = *f1++;
         *f3   = *f1;
         ++nr[0];
      }
   }

   if (nr[1] > 0)
   {
      f1 = (ReaL_4 *)minfo.mxyz + offset[1];
      f2 = (ReaL_4 *)minfo.mxyz + offset[1] + (nr[1] - 1) * 2;
      if (*f1 != *f2 || *(f1+1) != *(f2+1))
      {
         f3 = (ReaL_4 *)minfo.mxyz + offset[1] + nr[1] * 2;
         *f3++ = *f1++;
         *f3   = *f1;
         ++nr[1];
      }
   }
}
