#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: map_limits.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void map_limits (ByTe_4 proj, ReaL_4 xl, ReaL_4 yl, ReaL_4 xu, ReaL_4 yu, 
                 ReaL_4 *conv)
{
   extern struct mapinfo map;
   register ReaL_4 *f1, *f2, *fend;
   ReaL_4 x[6], y[6];
   ReaL_4 difx, dify, xcen, ycen;
   ByTe_4  npts = 4;

/****** some preprocessing ********/
   
   if ((proj == 8) && (yu * yl < 0.0))
   {
      if (-yu/yl >= 1.0)
      {
         if (yu > 0)
            yl = 0.0;
         else
         {
            yl = yu;
            yu = 0.0;
         }
      }
      else
      {
         if (yl > 0)
         {
            yu = yl;
            yl = 0.0;
         }
         else
            yu = 0.0;
      }
   }

   xl = (xl > xu) ? xl - 360.0 : xl;
   map.rotlong += -(xl + (xu - xl)/2.0);
   
   xcen = xu - xl;
   if (proj == 7 && xcen > 180.0)
   {
      xl = -90.0;
      xu = 90.0;
   }
   else
   {
      xl = -xcen/2.0;
      xu = xcen/2.0;
   }

   f1 = x;
   f2 = y;

   *f1++ = xl;
   *f1++ = xu;
   *f1++ = xu;
   *f1++ = xl;
   *f2++ = yl;
   *f2++ = yl;
   *f2++ = yu;
   *f2++ = yu;
   if (proj == 7 && yl * yu < 0.0)
   {
      *f1++ = xl;
      *f1   = xu;
      *f2++ = 0.0;
      *f2   = 0.0;
      npts = 6;
   }
   fend = y + npts;

   switch (proj)
   {
      case 2:
      case 3:
      case 4:
      case 5:
         if ((yl <= 0.0 && yu >= 0.0) || (yl >= 0.0 && yu <= 0.0))
         {
            for (f2 = y; f2 < fend; )
                *f2++ = 0.0;
         }
         break;
      case 6:
         x[0] = 0.0;
         x[3] = (xu < 90.0) ? 0.0 : 90.0;
         if (xu >= 90.0)
            y[3] = y[0];
         map.rotlong -= 90.0;
         if (map.rotlong > 180.0)
            map.rotlong -= 360.0;
         else
            if (map.rotlong < -180.0)
               map.rotlong += 360.0;
         break; 
      case 7:
         if (map.center < .01 && map.center > -.01)
             map.center = -(yl + (yu - yl)/2.0); 
         break;
      case 8:
         if (map.center < .01 && map.center > -.01)
             map.center = (yl + (yu - yl)/2.0); 

         x[0] = 0.0;
         x[3] = (xu < 90.0) ? 0.0 : 90.0;
         if (xu >= 90.0)
            y[3] = y[0];
         map.rotlong -= 90.0;
         if (map.rotlong > 180.0)
            map.rotlong -= 360.0;
         else
            if (map.rotlong < -180.0)
               map.rotlong += 360.0;
         break;
   }

  for (f1 = x, f2 = y; f2 < fend; )
      mapxy (f1++, f2++, proj);

   if (proj > 1 && proj < 6)
   {
      f2 = y;
      *f2++ = yl;
      *f2++ = yl;
      *f2++ = yu;
      *f2   = yu;
   }

   xl = x[0];
   xu = x[0];
   fend = x + npts;
   for (f1 = x + 1; f1 < fend; ++f1)
   {
      if (xl > *f1)
         xl = *f1;
      if (xu < *f1)
         xu = *f1;
   }

   yl = y[0];
   yu = y[0];
   fend = y + npts;
   for (f1 = y + 1; f1 < fend; ++f1)
   {
      if (yl > *f1)
         yl = *f1;
      if (yu < *f1)
         yu = *f1;
   }
   
   switch (proj)
   {
      case 6:
      case 8:
         yl = -xu;
         xu = yu;
         yu = -xl;
         xl = -xu;
         break;
      case 7:
         difx = xu - xl;
         dify = yu - yl;
         xcen = (yu + yl) / 2.0;
         ycen = (xu + xl) / 2.0;
   
         if (difx > dify)
         {
            yl = xcen - difx / 2.0;
            yu = xcen + difx / 2.0;
         }
         else
         {
            xl = ycen - dify / 2.0;
            xu = ycen + dify / 2.0;
         }
         break;
   }

   f1 = conv;
   *f1++ = xl;
   *f1++ = yl;
   *f1++ = xu;
   *f1++ = yu;
}
