#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: load_cmap.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void load_cmap (ByTe_1 *file, ByTe_2 size)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   register struct dev_graph *dg, *dg_end;
   register u_ByTe_1 *c1, *c_end;
   register ByTe_2 *s1;
   FILE *fd,*fopen();

   ByTe_2 tmp;

   if (!(fd = fopen (file,"r"))) 
      g_error ("LOAD_CMAP","CANNOT OPEN COLOR LOOK UP TABLE",1);

/***************************************************************************/
/*   Set up color information and define base colors                       */
/***************************************************************************/

   fscanf (fd, "%hd", &tmp);
   color_info (tmp);

   s1 = &parm.white;
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("white",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("red",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("yellow",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("green",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("cyan",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("blue",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("purple",tmp);
   fscanf (fd, "%hd", &tmp);
   if (*s1++ < 0)
      def_color ("black",tmp);

   dg = parm.drv;
   dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
   while (parm.drv < dg_end)
   {
      c1 = (u_ByTe_1 *) parm.drv->ctb->wcp;
      c_end = c1 + parm.drv->dev->ctl;
      for ( ; c1 < c_end; ++c1)
         if (*c1 != 255)
            *c1 = 0;

      parm.drv->_ldcm (fd,size);
      ++parm.drv;
   }
   parm.drv = dg;

   fclose (fd);
}
