/***************************************************************************/
/*                                                                         */
/*  DESCRIPTION                                                            */
/*    Line draws a single line between the coordinates specified and in    */
/*    specified graphics window                                            */
/*                                                                         */
/*  INPUT VARIABLES                                                        */
/*    char   w        window number in which to draw line                  */
/*    float  x1       beginning x co-ordinate of the line                  */
/*    float  y1       beginning y co-ordinate of the line                  */
/*    float  z1       beginning z co-ordinate of the line                  */
/*    float  x2       ending x co-ordinate of the line                     */
/*    float  y2       ending y co-ordinate of the line                     */
/*    float  z2       ending z co-ordinate of the line                     */
/*                                                                         */
/*  USAGE                                                                  */
/*    line (w,x1,y1,z1,x2,y2,z2)                                           */
/*                                                                         */
/*  NECESSARY SUBPROGRAMS                                                  */
/*    mv_n_drw ()    put point in output plotting buffer                   */
/*    window ()      checks that a given window has been defined           */
/*                                                                         */
/*  EXTERNAL VARIABLES                                                     */
/*    none                                                                 */
/*                                                                         */
/*  INTERNAL VARIABLES                                                     */
/*    err_code       holds flag indicating if output window is available   */
/*                                                                         */
/***************************************************************************/
 
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: line.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 line (ByTe_1 w, ReaL_4 x1, ReaL_4 y1, ReaL_4 z1, 
                       ReaL_4 x2, ReaL_4 y2, ReaL_4 z2)
{
   extern struct config parm;
   ByTe_1 err_code;

   err_code = (w != parm.wn_num) ? window (w,"LINE") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("LINE","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

/***************************************************************************/
/*  output line using mv_n_drw                                             */
/***************************************************************************/
   
   mv_n_drw (w,x1,y1,z1,0,0);
   mv_n_drw (w,x2,y2,z2,1,1);
   return (1);
}
