#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: lat_correct.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 lat_correct (ReaL_4 *x, ReaL_4 *y, ReaL_4 *xc, ReaL_4 *yc)
{
   register ReaL_4 *f1, *f2;
   ReaL_4 x3, y3;
   ReaL_4 yy1, yy2, xx1, xx2; 
   ByTe_4 npts;
   ByTe_1 line_type = 0;

   f1 = xc;
   f2 = yc;

   xx1 = *x;
   yy1 = *y;
   xx2 = *(x+1);
   yy2 = *(y+1);

   if (*y > 90.0)
   {
      yy1 = 180.0 - yy1;
      y3 = 90.0;
      ++line_type;
   }
   else
   {
      if (*y < -90.0)
      {
         yy1 = -180.0 - yy1;
         y3 = -90.0;
         ++line_type;
      }
   }

   if (*(y+1) > 90.0)
   {
      yy2 = 180.0 - yy2;
      y3 = 90.0;
      ++line_type;
   }
   else
   {
      if (*(y+1) < -90.0)
      {
         yy2 = -180.0 - yy2;
         y3 = -90.0;
         ++line_type;
      }
   }

   if (line_type == 1)
      x3 = brkmap(*y,*x,*(y+1),*(x+1),y3);

   switch (line_type)
   {
      case 0:
      case 2:
         if (line_type == 2)
         {
            xx1 = (xx1 > 0.0) ? xx1 - 180.0 : 180 + xx1;
            xx2 = (xx2 > 0.0) ? xx2 - 180.0 : 180 + xx2;
         }
         *f1++ = xx1;
         *f2++ = yy1;
         *f1   = xx2;
         *f2   = yy2;
         npts = 2;
         break;
      case 1:
         *f1++ = *x;
         *f2++ = yy1;
         *f1++ = x3;
         *f2++ = y3;

         *f1++ = (x3 > 0.0) ? x3 - 180.0 : 180 + x3;
         *f2++ = y3;
         *f1   = (*(x+1) > 0.0) ? *(x+1) - 180.0 : 180 + *(x+1);
         *f2   = yy2;
         npts = 4;
         break;
   }

   return (npts);
}
