#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: lab_lines.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 lab_lines (ByTe_1 w, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_2 n, 
                  ByTe_1 *sym, ByTe_1 mode, ByTe_2 csize, ByTe_2 hue)
{
   extern struct config parm;
   struct window *wn;
   register ReaL_4 *f1, *f2, *f3, *fend;
   ReaL_4 x1, x2, y1, y2, xt, yt;
   ReaL_4 xl, yl, xh, yh, zl, zh;
   ReaL_4 dx, dy, slope, inter;
   ReaL_4 cs[2];
   ReaL_4 splot[6];
   ByTe_1  saxis[3];
   ByTe_1  *c1, *c2;
   ByTe_1  tsize;
   ByTe_1  Ec;

   Ec = (w != parm.wn_num) ? window (w,"LAB_LINES") : parm.win->open;
   if (Ec <= 0)
   {
      g_error ("LAB_LINES","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   tsize = parm.csize;
   chr_size (csize);

   if (n <= 0) 
   {
      g_error ("LAB_LINES","NUMBER OF POINTS IS <= 0", 0);
      return (0);
   }
   else
   {
      if (n == 1)
      {
         if (*sym != '\0')  
            chr_dspl (w,*x,*y,*z,0.0,0.0,0.0,0,0,sym,-1,hue);
         else
            point (w,*x,*y,*z);
         return (1);
      }
   }

   if (*sym != '\0')  
   {
      fend = x + n;
      for (f1 = x, f2 = y, f3 = z; f1 < fend; ) 
          chr_dspl(w,*f1++,*f2++,*f3++,0.0,0.0,0.0,0,0,sym,-1,hue);
   }
   
   if (mode) 
   {
      if (*sym == '\0' )
         lines (w,x,y,z,n);
      else 
      {
         wn = parm.win;
         f2 = splot;
         c1 = wn->axis;
         c2 = saxis;
         fend = wn->plot + 3;
         for (f1 = wn->plot; f1 < fend; ++f1, ++f2, ++c1)
         {
            *c2++ = *c1;
            *f2 = *f1;
            *(f2 + 3) = *(f1 + 3);
            if (*c1 == 1)
            {
               *c1 = 0;
               *f1 = log(*f1);
               *(f1 + 3) = log(*(f1 + 3));
            }
         }
         scale_win(0);

         get_chsz (cs);
         fend = x + n;
         c1 = saxis;
         xl = (*c1 == 1) ? log(*x) : *x;
         yl = (*(c1+1) == 1) ? log(*y) : *y;
         zl = (*(c1+2) == 1) ? log(*z) : *z;
         for (f1 = x+1, f2 = y+1, f3 = z+1; f1 < fend; ) 
         {
             xh = (*c1 == 1) ? log(*f1++) : *f1++;
             yh = (*(c1+1) == 1) ? log(*f2++) : *f2++;
             zh = (*(c1+2) == 1) ? log(*f3++) : *f3++;

             dx = xh - xl;
             dy = yh - yl;

             if (dx != 0.0)
             {
                x1 = xl - cs[0]/2.0;   
                x2 = xl + cs[0]/2.0;   
                y1 = yl - cs[1]/2.0;   
                y2 = yl + cs[1]/2.0;   

                slope = dy/dx;
                inter = yh - slope * xh;

                yt = slope * x2 + inter; 
                if (yt >= y1 && yt <= y2)
                {
                   if (dx > 0)
                      mv_n_drw (w,x2,yt,zl,0,0);
                   else
                   {
                      yt = slope * x1 + inter; 
                      mv_n_drw (w,x1,yt,zl,0,0);
                   }
                }
                else
                {
                   xt = (y2 - inter) / slope; 
                   if (dy > 0)
                      mv_n_drw (w,xt,y2,zl,0,0);
                   else
                   {
                      xt = (y1 - inter) / slope; 
                      mv_n_drw (w,xt,y1,zl,0,0);
                   }
                }

                x1 = xh - cs[0]/2.0;   
                x2 = xh + cs[0]/2.0;   
                y1 = yh - cs[1]/2.0;   
                y2 = yh + cs[1]/2.0;   

                yt = slope * x2 + inter; 
                if (yt >= y1 && yt <= y2)
                {
                   if (dx < 0)
                      mv_n_drw (w,x2,yt,zh,1,0);
                   else
                   {
                      yt = slope * x1 + inter; 
                      mv_n_drw (w,x1,yt,zh,1,0);
                   }
                }
                else
                {
                   xt = (y2 - inter) / slope; 
                   if (dy < 0)
                      mv_n_drw (w,xt,y2,zh,1,0);
                   else
                   {
                      xt = (y1 - inter) / slope; 
                      mv_n_drw (w,xt,y1,zh,1,0);
                   }
                }
             }
             else
             {
                if (dy > 0)
                {
                   y1 = yh - cs[1]/2.0;   
                   y2 = yl + cs[1]/2.0;   
                   mv_n_drw (w,xl, y2, zl, 0, 0);
                   mv_n_drw (w,xl, y1, zh, 1, 0);
                }
                else
                {
                   y1 = yl - cs[1]/2.0;   
                   y2 = yh + cs[1]/2.0;   
                   mv_n_drw (w,xl, y1, zl, 0,0);
                   mv_n_drw (w,xl, y2, zh, 1,0);
                }
              }

              xl = xh;
              yl = yh;
              zl = zh;
           }
           mv_n_drw (w,0.0,0.0,0.0,0,2);

           f2 = splot;
           c1 = wn->axis;
           c2 = saxis;
           fend = wn->plot + 3;
           for (f1 = wn->plot; f1 < fend; ++f1, ++f2)
           {
              *c1++ = *c2++;
              *f1 = *f2;
              *(f1 + 3) = *(f2 + 3);
           }
           scale_win(0);
       }
    }

    chr_size (tsize);
    return (1);
}

