#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: inv_win.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 inv_win (ByTe_1 w, ByTe_1 axs, ByTe_1 type)
{

  extern struct config parm;
  register struct window *wn;
  ReaL_4 temp;
  register ReaL_4 *pta,*ptb;
  register ByTe_1  *ptc;
  ByTe_2 pos;
  ByTe_1 Ec;
  ByTe_1 Flip;

  Ec = (w != parm.wn_num) ? window (w,"INV_WIN") : parm.win->open;
  if (Ec <= 0)
  {
     g_error ("INV_WIN","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
     return (0);
  }

  wn = parm.win;

  if (type < 0 || type > 1)
  {
     g_error("INV_WIN","ILLEGAL INVERSION FLAG -- NO ACTION TAKEN",0);
     return (0);
  }

  pos = axs - 'x';

  if (pos >= 0 && pos < 3)
  {
     pta = &wn->plot[pos]; 
     ptb = &wn->plot[pos+3]; 
     ptc = &wn->flip[pos]; 

     if (type)
     {
        temp = *pta;
        *pta = *ptb;
        *ptb = temp;
     }
     else
        *ptc = (*ptc == 0) ? 1 : 0;
   }
   else
      g_error ("INV_WIN","UNKNOWN AXIS -- NO ACTION TAKEN",0);

   Flip = (pos == 0 && parm.ostyle == 1) ? 2 : 0;
   scale_win (Flip);
   return (1);
}
