#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: interpret.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void interpret (register ByTe_1 *istr, register ByTe_1 *ostr, ByTe_1 hv)
{
   extern struct config parm;
   ByTe_2 adv,len,slen,offset;
   ByTe_1 sstr[80],*sb;
   ByTe_1 sp_sb[80];
   ByTe_2 w_case,sum;
   ByTe_1 *substr;
   ByTe_1 sp_sb_on;
   ByTe_1 font;
   static ByTe_1 c_info[4],first=1;

   font = (parm.font < 0) ? -parm.font : parm.font;
      
   switch (font)
   {
      case 3:
      case 4:
         c_info[3] = 'I';
         break;
      case 5:
      case 6:
         c_info[3] = 'K';
         break;
      default:
         c_info[3] = 'P';
         break;
   }

   if (first)
   {
      c_info[0] = 'R';
      c_info[1] = 'U';
      c_info[2] = c_info[3]; 
      if (c_info[2] != 'P')
      {
         *ostr++ = 39;
         *ostr++ = c_info[2];
         *ostr++ = 39;
      }
      first = 0;
   }

   if (hv)
   { 
       *ostr++ = 39;
       *ostr++ = 'D';
       *ostr++ = 39;
   }

   substr = sstr;

/************************************************************************/
/*  Begin to process the input string                                   */
/************************************************************************/

   while (*istr != '\0') 
   {

/************************************************************************/
/*  The ' (ascii 39) indicates that the characters up to the next '     */
/*  represent special input (greek symbols, super and subscripts, etc.) */
/*  and require special processing                                      */
/************************************************************************/

      if (*istr == 39)
      {

/************************************************************************/
/* Increment the input string past the ' character, then zero out the   */
/* sum counter which hold the total number of characters processed      */
/************************************************************************/

         ++istr;

/************************************************************************/
/*  Strip the string contained between the apostrophes out of the input */
/*  string and put in the string sstr                                   */
/************************************************************************/

         len = strip_str (istr,substr,39,&w_case);

/************************************************************************/
/* Increment the pointer of the input string past the string contained  */
/* between the apostrophes.  The additional one accounts for the        */
/* closing apostrophe                                                   */
/************************************************************************/

         istr = istr + len + 1;

         sum = 0;
         while (len > sum) 
         {
            sp_sb_on = 0;
            offset = conv_str (substr,ostr,len-sum,c_info,&slen);
            ostr = ostr + slen;
            substr = substr - offset;
            sum = (offset < 0) ? sum - offset : sum + offset;

            while (offset < 0)
            {
               sb = sp_sb;

               while (*substr == ' ')
               {
                  ++substr;
                  ++sum;
               }

               if (*substr == '{')
               {
                  ++substr;
                  ++sum;
                  slen = bra_ket (substr,ostr,c_info,&offset,1);
               }
               else
               {
                  offset = conv_str (substr,ostr,len-sum,c_info,&slen);
                  sp_sb_on = 1;
               }

               ostr = ostr + slen;
               substr = (offset < 0) ? substr - offset : substr + offset;
               sum = (offset < 0) ? sum - offset : sum + offset;
            }

            if (sp_sb_on)
            {
               *ostr++ = 39;
               *ostr++ = 'N';
               *ostr++ = 39;
            }
         }
      }
      else
      {
         adv = ascii_ch (istr,ostr,&len,c_info); 
         istr = istr + adv;
         ostr = ostr + len;
      }
   }
   *ostr = '\0';
}
