#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#include <stdlib.h>
#include <string.h>

static ByTe_1 rcsid[] = "$Id: init_graph.c,v 1.1.1.1 2000/02/01 15:56:16 chrisg Exp chrisg $";

void init_graph (ByTe_1 DV1, ByTe_1 DV2)
{
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;

   struct scr_info  *dv, dev;
   struct dev_graph *dg, *dg_end;
   struct color     *cl;

   register ByTe_2 *s1, *s_end;

   register ByTe_1 *c1;
   register u_ByTe_1 *c2, *c_end;

   int c;

   ByTe_4  fd = -1, NDEV;
   ByTe_4  cnt;
   ByTe_4  bytes, offset;
   ByTe_1  j;
   ByTe_1  reply[10], FNAME[80];
   ByTe_1  CharPath[80];
   ByTe_1  IN[2];
   ByTe_1  *Fs = PathSep;

   ByTe_1 *name =   "INIT_GRAPH";
   ByTe_1 *error1 = "CANNOT OPEN DEVICE INFORMATION FILE";
   ByTe_1 *error2 = "UNABLE TO OPEN REQUESTED DEVICE";
   ByTe_1 *error4 = "CANNOT MALLOC MEMORY FOR COLOR TABLE"; 

   ByTe_1 *banner1 = "              THIS PROGRAM CONTAINS GRAPHICS OUTPUT\n";
   ByTe_1 *banner2 = "                  PLEASE INDICATE THE GRAPHICS\n";
   ByTe_1 *banner3 = "                      TERMINAL YOU ARE USING\n\n";
      
   /**************************************************************************/
   /*  Make a working copy of the requested devices                          */
   /**************************************************************************/

   IN[0] = DV1;                                      /* save lead device     */
   IN[1] = DV2;                                      /* save secondary dev   */

   /**************************************************************************/
   /*  Get system word sizes                                                 */
   /**************************************************************************/

   parm.SSize.Lsize = sizeof (ByTe_4);               /* size of long         */
   parm.SSize.Ssize = sizeof (ByTe_2);               /* size of short        */
   parm.SSize.Csize = sizeof (ByTe_1);               /* size of char         */
   parm.SSize.Fsize = sizeof (ReaL_4);               /* size of float        */
   parm.SSize.Dsize = sizeof (ReaL_8);               /* size of double       */

   /**************************************************************************/
   /*  If there are devices and the like open from a previous call to        */
   /*  init_graph now is the time to close them.                             */
   /**************************************************************************/

   if (minfo.mdrv != NOMEM)                          /* open devices?        */
      end_graph ();                                  /* close them down      */

   /**************************************************************************/
   /*  Open up the graphics error logging file.  If we can't do this, then   */
   /*  announce it to the screen and leave                                   */
   /**************************************************************************/

   if ((parm.error = fopen ("gf_errors","w")) == NULL) 
   {
      fprintf (stderr, "\nCANNOT CREATE GRAPHICS ERROR LOGGING FILE");
      exit (-1);
   }

   /**************************************************************************/
   /*  Open up the file which describes all of the devices that this         */
   /*  system supports.  It is kept in the datafiles directory under the     */
   /*  parent graphics directory.                                            */
   /**************************************************************************/

   sprintf (CharPath,"%s%sdatafiles%sdevice.bin",getenv("GPH_HOME"), Fs, Fs);

   if ((fd = open (CharPath,0)) < 0)                /* device info open?     */
      g_error (name, error1, 2);                    /* no - error and go     */
   else                                             /* file is open          */
   {
#ifdef _CyGnUsC
      setmode (fd, O_BINARY);                       /* binary file           */
#endif
      bytes = sizeof (struct scr_info);             /* dev struct size       */
      lseek (fd, 0L, 0);                            /* to beg of file        */
      read (fd, &NDEV, parm.SSize.Lsize);           /* num of devices known  */
   }

   ival.devices = (DV2 < 0 || DV2 >= NDEV) ? 1 : 2; /* num of devs to open   */  
   gf_allocs();                                     /* malloc all structures */

   s1 = (ByTe_2 *)minfo.mxy;                        /* temporary dev # ptr   */
   if (IN[0] < 0 || IN[0] >= NDEV)                  /* get avail devices?    */
   {                                                /* yes!                  */
      c1 = (ByTe_1 *) minfo.mxyz;                   /* temporary string ptr  */
      lseek (fd, parm.SSize.Lsize, 0);              /* 1st device descrip    */
      for (cnt = 0, j = 0; j < NDEV; ++j)           /* loop over devices     */
      {
         read (fd, &dev, bytes);                    /* read device info      */
         if (IN[0] == -1 ||                         /* get any device        */
             (IN[0] == -2 && dev.type == 0) ||      /* or only terminals     */
             (IN[0] == -3 && dev.type >= 2))        /* or only output devs   */
         {
            strcpy (c1, dev.name);                  /* store device name     */
            *s1++ = j;                              /* store device number   */
            c1 += 40;                               /* next dev name here    */
            ++cnt;                                  /* inc number devices    */
         }
      }
      NDEV = cnt;                                   /* this many devices     */
   }
   else
      *(s1 + IN[0]) = IN[0];                        /* correct device number */

   fprintf (stderr,"\n\n\n\n\n\n\n\n\n");           /* begin banner          */
   while (IN[0] < 0 || IN[0] >= NDEV)               /* loop til valid dev    */
   {
      fprintf (stderr,banner1);                     /* banner - line 1       */
      fprintf (stderr,banner2);                     /* banner - line 2       */
      fprintf (stderr,banner3);                     /* banner - line 3       */

      c1 = (ByTe_1 *) minfo.mxyz;                   /* temporary string ptr  */
      for (j = 0; j < NDEV; ++j, c1 += 40)          /* loop over devices     */
          fprintf (stderr,"                 %2d) %s\n",j,c1);
      fprintf (stderr,"\n                 ");       /* placement for reply   */


      scanf ("%s",reply);                           /* get reply             */
      c = getchar();                                /* get linefeed char     */

      c1 = reply;                                   /* pointer to reply      */
      while (*c1 >= '0' && *c1 <= '9')              /* check for validity    */
        ++c1;                                       /* next char in reply    */

      if (*c1 == 0)                                 /* reply ok?             */
      {                                             /* yes                   */
         sscanf (reply,"%d", &cnt);                 /* convert to int        */
         IN[0] = cnt;                               /* save                  */
      }
      else                                          /* got a problem         */
         IN[0] = -1;                                /* set reply to bad      */

      if (IN[0] < 0 || IN[0] >= NDEV)               /* valid reply?          */
         fprintf (stderr,"\n\nINPUT ERROR\n\n\n");  /* no! give error        */
   }

   s1 = (ByTe_2 *)minfo.mxy;                        /* temporary dev # ptr   */
   IN[0] = *(s1 + IN[0]);                           /* correct device number */

   dg = (struct dev_graph *)minfo.mdrv;             /* beg driver info struc */
   dg_end = dg + ival.devices;                      /* end driver info struc */
   for (c1 = IN; dg < dg_end; ++dg)                 /* loop over drivers     */
   {
      parm.drv = dg;                                /* pntr to cur driver    */
      dv       = dg->dev;                           /* device info struct    */
      offset = *c1 * bytes + parm.SSize.Lsize;      /* offset to device info */
      lseek (fd, offset, 0);                        /* seek to device info   */
      read (fd, dv, bytes);                         /* read in device info   */
      dv->num  = *c1++;                             /* set device number     */

      if (strcmp (dv->dev,"nop") != 0)              /* device output set?    */
      {                                             /* no!                   */
#if defined _MaCiNtOsH && !defined __MWERKS__
         if (dv->type == 2)                         /* metafile?             */
         {                                          /* yes!                  */
            sprintf (FNAME, "%s", dv->dev);         /* get metafile name     */
            if (strlen (FNAME) > 8)                 /* name > 8 characters?  */
               FNAME[8] = 0;                        /* yes - truncate to 8   */ 
	       sprintf (dv->dev,"%s.m001",FNAME);
	    }
#else
         if (strcmp (dv->dev, "get") == 0)          /* terminal?             */
            sprintf (dv->dev, "%s", ttyname(2));    /* yes! get output port  */
         else                                       /* not a terminal        */
         {
            if (dv->type == 2)                      /* metafile?             */
            {                                       /* yes!                  */
               sprintf (FNAME, "%s", dv->dev);      /* get metafile name     */
               if (strlen (FNAME) > 8)              /* name > 8 characters?  */
                  FNAME[8] = 0;                     /* yes - truncate to 8   */ 

	       sprintf (dv->dev,"%s.m%d",FNAME,getpid());
	    }
         }
#endif

         if (access (dv->dev, 00) < 0)              /* output device exist?  */
#ifdef _MaCiNtOsH
            dg->fd = creat(dv->dev);
#else
            dg->fd = creat (dv->dev, 0666);         /* no - create it        */
#endif
         else                                       /* yes!                  */
            dg->fd = open (dv->dev, 2);             /* open it               */

         if (dg->fd < 0)                            /* device opened ok?     */
            g_error (name, error2, 1);              /* no - error and out    */

#ifdef _CyGnUsC
         setmode (dg->fd, O_BINARY);                /* binary file           */
#endif

      }

      dev_asgn();                                   /* assign output drivers */
      dg->_init();                                  /* initialize device     */
      dv->opened = 1;                               /* label it as opened    */
   }
   close (fd);                                      /* close device file     */

   /**************************************************************************/
   /*  Do some initializations in the current configuration structure        */
   /**************************************************************************/

   parm.univ     =  0;                              /* plot in window cor    */
   parm.sg_num   = -1;                              /* no cur segment open   */
   parm.gf_num   = -1;                              /* no cur plots open     */
   parm.page     =  0;                              /* plotting page zero    */
   parm.fill     = -1;                              /* fill is off           */
   parm.alt_out  =  0;                              /* alt output in win cor */
   parm.f_color  = -1;                              /* fill color undefined  */
   parm.a_curs   =  1;                              /* text cursor visible   */
   parm.g_curs   =  0;                              /* graphics cursor !visi */
   parm.au_color = -1;                              /* text cursor col !def  */
   parm.gu_color = -1;                              /* graph cursor col !def */
   parm.font     =  1;                              /* font - stroked duplex */
   parm.cstyle   =  0;                              /* char scaled as window */
   parm.csize    = 16;                              /* current char size     */
   parm.c_color  =  0;                              /* char color is black   */
   parm.lstyle   =  0;                              /* line style - solid    */
   parm.l_color  =  0;                              /* line color is black   */
   parm.b_color  =  0;                              /* bkgnd color is black  */

   s_end = &parm.white + 8;                         /* last predefined color */
   for (s1 = &parm.white; s1 < &parm.white+8;)      /* loop over predef cols */
      *s1++ = -1;                                   /* make them undefined   */

   dg = (struct dev_graph *)minfo.mdrv;             /* beg driver info struc */
   for ( ; dg < dg_end; ++dg)                       /* loop over drivers     */
   {
      parm.drv = dg;                                /* set current driver    */
      dv       = dg->dev;                           /* its device info struc */
      cl       = dg->ctb;                           /* its color info struct */

      cl->c_scale = (dv->ctl - .01) / 32767.0;      /* color scaling for max */
      cl->c_len = 0;                                /* no color entries      */
      s_end = cl->def_pos + 8;                      /* last defined col pos  */
      for (s1=cl->def_pos; s1<cl->def_pos+8;)       /* loop over def col pos */
          *s1++ = -1;                               /* set to undefined      */

      if ((cl->wcp = malloc ((ByTe_4)dv->ctl)) == 0) /* get ctbl stat array  */
         g_error (name, error4, 2);                 /* if error - log and go */

      c2 = (u_ByTe_1 *)cl->wcp;                     /* ptr to ctbl status    */
      c_end = c2 +  dv->ctl;                        /* end of ctbl status    */
      for ( ; c2 < c_end;)                          /* loop over status      */
         *c2++ = 0;                                 /* set to unfilled       */
   }
   
   parm.drv = (struct dev_graph *)minfo.mdrv;       /* reset ptr to cur dev  */
}
