#include "gph_str.h"
#include "gph_ansi.h"
#include <stdlib.h>

static ByTe_1 rcsid[] = "$Id: gf_allocs.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void gf_allocs (void)
{
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   register struct scr_info  *sc, *end;
   register struct dev_graph *dv;
   register struct color     *cl;
   ByTe_4 bytes;

   if (minfo.mdrv == NOMEM)
   {
      bytes = ival.devices * sizeof (struct dev_graph);
      if ((minfo.mdrv = malloc (bytes)) == NOMEM)
         g_error ("GF_ALLOC","NO MEMORY FOR DRIVER STRUCTURE",1);

      bytes = ival.devices * sizeof (struct scr_info);
      if ((minfo.mdev = malloc (bytes)) == NOMEM)
         g_error ("GF_ALLOC","NO MEMORY FOR SCREEN INFORMATION STRUCTURE",1);

      bytes = ival.devices * sizeof (struct color);
      if ((minfo.mcol = malloc (bytes)) == NOMEM)
         g_error ("GF_ALLOC","NO MEMORY FOR COLOR TABLE STRUCTURE",1);

      dv = (struct dev_graph *)minfo.mdrv;
      cl = (struct color *)minfo.mcol;
      sc = (struct scr_info *)minfo.mdev;
      end = sc + ival.devices;
      
      for (; sc < end; ++dv) 
      {
	  dv->open =  1;
          dv->m_cmd = NOMEM;
          dv->w_cmd = NOMEM;
	  sc->num  = -1;
	  dv->ctb  = cl++; 
	  dv->dev  = sc++; 
      }

   }

   parm.drv = (struct dev_graph *)minfo.mdrv;

   if (minfo.mxyz == NOMEM)
   {
       bytes = (ival.points + 2) * 3 * parm.SSize.Fsize;
       if ((minfo.mxyz = malloc (bytes)) == NOMEM)
	  g_error ("GF_ALLOCS","NO MEMORY FOR INPUT DATA BUFFER",1);
   }
   if (minfo.mxy == NOMEM)
   {
       bytes = (ival.points + 2) * 2 * parm.SSize.Fsize;
       if ((minfo.mxy = malloc (bytes)) == NOMEM)
	  g_error ("GF_ALLOCS","NO MEMORY FOR OUTPUT DATA BUFFER",1);
   }
   if (minfo.cmd == NOMEM)
   {
       bytes = ival.points;
       if ((minfo.cmd = malloc (bytes)) == NOMEM)
	  g_error ("GF_ALLOCS","NO MEMORY FOR PEN CMD BUFFER",1);
   }

   parm.cl_ofst = 8 * ival.points + 1;
}
