#include <stdlib.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dspl_seg.c,v 1.1.1.1 2000/02/01 15:58:04 chrisg Exp chrisg $";

ByTe_4 dspl_seg (ByTe_1 segn, ByTe_1 save)
{
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   register struct segment *sg, *sg_end;

   if (parm.sg_num >= 0)
   {
      g_error("DSPL_SEG","CURRENTLY OPEN SEGMENT MUST BE CLOSED FIRST",0);
      return (0);
   }
  
   sg = (struct segment *)minfo.mseg;
   sg_end = sg + ival.segments;
   for ( ; sg < sg_end; ++sg)  
      if (sg->seg_num == segn) 
	 break;

   if (sg < sg_end )
   {
      if (parm.drv->_dpseg (segn,save) == -1 && sg->cur_len > 0)
         write (parm.drv->fd,sg->wpt,sg->cur_len);
   }
   else
   {
      g_error("DSPL_SEG","SEGMENT NUMBER NOT DEFINED",0);
      return (0);
   }
   
   if (save == 0)
   {
      free (sg->mpt);
      sg->seg_num     = -1;
      sg->mpt         = NOMEM;
      sg->def         = -1;
      sg->mx_len      = -1;
   }
   else
      if (save == 1)
      {
          sg->wpt = (ByTe_1 *)sg->mpt;
          sg->cur_len     = 0;
          sg->lst_out_len = 0;
          sg->type        = 0;
      }

   return (1);
}
