#include "sys_dev.h"
#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: dev_asgn.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

void dev_asgn (void)
{
   extern struct config parm;

   register struct dev_graph *dg;
   register struct scr_info  *dv;

   dg = parm.drv;
   dv = dg->dev;

   dg->_arc     = (void *)nop;
   dg->_clseg   = nop;
   dg->_cltx    = (void *)nop;
   dg->_curctrl = nop;
   dg->_dpseg   = (void *)nop;
   dg->_end     = nop;
   dg->_exinpt  = nop;
   dg->_filcol  = nop;
   dg->_filpat  = nop;
   dg->_gtln    = (void *)nop;
   dg->_hdfont  = (void *)nop;
   dg->_init    = nop;
   dg->_kybd    = nop;
   dg->_ldcm    = (void *)nop;
   dg->_ldcol   = (void *)nop;
   dg->_line    = (void *)nop;
   dg->_lstyle  = nop; 
   dg->_mvac    = (void *)nop;
   dg->_nwscr   = nop;
   dg->_opseg   = (void *)nop;
   dg->_pltcol  = nop;
   dg->_poly    = (void *)nop;
   dg->_scrcol  = nop;

   switch (dv->drv_num)
   {
#if RASTER
      case 0:   /* Raster routines */
         dg->_end   = rs_end;
         dg->_init  = rs_init;
         dg->_ldcm  = rs_ldcm;
         dg->_line  = rs_line;
         dg->_nwscr = rs_nwscr;
         dg->_poly  = rs_poly;
         break;
#endif

#if POSTSCRIPT

       case 1:  /* Color PostScript Printer */
          dg->_arc    = pc_arc;
	  dg->_hdfont = pc_hdfont;
          dg->_line   = pc_line;
	  dg->_lstyle = pc_lstyle;
          dg->_nwscr  = pc_nwscr;
	  dg->_poly   = pc_poly;
	  dg->_end    = pc_end;
	  dg->_init   = pc_init;
          dg->_ldcm   = pc_ldcm;
          break;
#endif

#if XWINDOWS
       case 2:
	  dg->_init   = xw_init;
	  dg->_end    = xw_end;
	  dg->_line   = xw_line;
          dg->_poly   = xw_poly;  
	  dg->_ldcm   = xw_ldcm;
	  dg->_ldcol  = xw_ldcol;
          dg->_pltcol = xw_pltcol;
	  dg->_lstyle = xw_lstyle;
	  dg->_hdfont = xw_hdfont; 
	  dg->_gtln   = xw_gtln;
	  dg->_arc    = xw_arc;
	  break;
#endif

#if TK
       case 3:  /* TK CANVAS */
          dg->_line   = TkLine;
          dg->_end    = TkEnd;
          dg->_gtln   = TkGtLn;
          dg->_init   = TkInit;
          dg->_poly   = TkPoly;
          dg->_ldcm   = TkLdCm;
          break;
#endif

#if GIF
       case 4:  /* GIF Non-Interlaced File Generator */
          dg->_line   = rs_line;
          dg->_poly   = rs_poly;
          dg->_end    = gif_end;
          dg->_init   = gif_init;
          dg->_nwscr  = gif_nwscr;
          dg->_ldcm   = rs_ldcm;
          break;
#endif

#if EPS
       case 5:  /* Encapsulated Color PostScript Printer */
          dg->_arc    = pc_arc;
	  dg->_hdfont = pc_hdfont;
          dg->_line   = pc_line;
	  dg->_lstyle = pc_lstyle;
          dg->_nwscr  = epc_nwscr;
	  dg->_poly   = pc_poly;
	  dg->_end    = epc_end;
	  dg->_init   = epc_init;
          dg->_ldcm   = pc_ldcm;
          break;
#endif

      default:
        g_error ("DEV_ASGN", "UNKNOWN DEVICE", 2);
	break;
   }
}
