#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: def_color.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 def_color (ByTe_1 *cst, ByTe_2  pos)
{
   extern struct config parm;
   extern struct init_val ival;
   extern struct memory minfo;

   struct dev_graph *dg, *end;
   struct scr_info *dv;
   struct color *ct;

   register ByTe_2 *s1, *s2, *s3, *s4, *s_end;
   register ByTe_2 j;

   ByTe_2 dp_color[9],index[8];
   ByTe_2 sv_color[9];
   ByTe_2 loc,color = 1;
   ByTe_2 ct1,ct2,sav;

   u_ByTe_1 *c1;

   /* no mistake, no nonsence color assignment */

   if (pos < 0)
   {
      g_error ("DEF_COLOR","COLOR VALUE OUT OF BOUNDS - NO ACTION TAKEN",0);
      return (0);
   }

/*** locate position of device with the smallest number of color lookup ***/
/*** positions excluding the 2 position monochrome devices              ***/

   if (ival.devices == 2)
   {
      dv = (struct scr_info *)minfo.mdev;
      ct1 = dv->ctl;
      ++dv;
      ct2 = dv->ctl;

      if (ct1 == 2)
	 loc = 1;
      else
      {
	 if (ct2 == 2)
	    loc = 0;
         else
	    loc = (ct1 > ct2) ? 1 : 0;
      }
   }
   else
      loc = 0;

   ct = parm.drv->ctb;
   s1 = parm.drv->ctb->def_pos;

   switch (strlen(cst)) 
   {
      case 3:
         if (!(strcmp ("red",cst))) 
            color = 1;
         break;
      case 4:
         if (!(strcmp ("cyan",cst))) 
            color = 4;
         else 
         {
            if (!(strcmp ("blue",cst))) 
               color = 5;
         }
         break;
      case 5:
         if (!(strcmp ("white",cst))) 
            color = 0;
         else  
	 {
            if (!(strcmp ("black",cst))) 
               color = 7;
            else 
            {
               if (!(strcmp ("green",cst))) 
                  color = 3;
            }
         }
         break;
      case 6:
         if (!(strcmp ("yellow",cst))) 
            color = 2;
         else 
         {
            if (!(strcmp ("purple",cst))) 
               color = 6;
         }
         break;
    }

    if (color < 0) 
    {
       g_error ("DEF_COLOR","UNDEFINED COLOR NAME - NO ACTION TAKEN",0);
       return (0);
    }

    ct->def_pos[color] = pos;

    if ((parm.drv+loc)->dev->ctl == 2)
    {
        s1 = &parm.white;
        *(s1 + color) = (pos > 0) ? 1 : 0;
        return (1);
    }

    if (ival.devices == 2)
    {
       s_end = ct->def_pos + 8;
       for (s1 = ct->def_pos, s2 = (ct+1)->def_pos; s1 < s_end;)
	   *s2++ = *s1++;
    }

      
    /* slow color sort */

    s2 = index;
    s3 = ct->def_pos;
    s_end = sv_color + 8;
    for (s1 = sv_color, j = 0;  s1 < s_end; ) 
    { 
        *s1++ = *s3++;
        *s2++ = j++;
    }

    for (s1 =sv_color, s2 = index; s1 < sv_color + 7; ++s1, ++s2)
       for (s3 = s1 + 1, s4 = s2 + 1; s3 < sv_color + 8; ++s3, ++s4)
       {
          if (*s1 < *s3) 
          {
             sav = *s1;
             *s1 = *s3;
             *s3 = sav;
             sav = *s2;
             *s2 = *s4;
             *s4 = sav;
          }
      }

   /* reduce to terminal color look up table */

    dg = parm.drv;
    end = (struct dev_graph *)minfo.mdrv + ival.devices;
    while (dg < end)
    {
       dv = dg->dev;
       if (dv->ctl == 2)
       {
	  ++dg;
	  continue;
       }
       ct = dg->ctb;

       s_end = sv_color + 8;
       for (s1 = sv_color, s2 = dp_color; s1 < s_end; ++s1, ++s2)
           *s2 = (*s1 >= 0) ? *s1 * ct->c_scale : -1;
                  
   /* crude color table reorganization */

       s1 = dp_color;
       s2 = dp_color + 1;
       *(s1 + 8) = 8;
       for (j=0; j < 7; ++j,++s1,++s2) 
       {
          if (*s2 < 0) 
          {
             dp_color[8] = j+1;
             break;
          }
          if (*s2 >= *s1)
          {
             if (*s1 == dv->ctl - 1)
                --*s2;
             else 
	     {
                if ( s1 > dp_color ) 
                {
                   if (*(s1 - 1) > *s1 + 1)
                      ++*s1;
                   else
                   {
                      if (*s2 == 0)
                      {
			 for (s3 = s1; s3 >= s2; --s3)
                         {
                             if (*(s3 - 1) > *s3 + 1)
                             {
				s4 = s3;
                                while (s4++ < s2)
                                   ++*s4;
                                break;
                             }
                          }
                       }
                       else
                          --*s2;
                    }
                }
                else
                   ++*s1;
             }
          }
       }

       s_end = dp_color + dp_color[8];
       c1 = (u_ByTe_1 *)ct->wcp;
       for (s1 = dp_color; s1 < s_end; ++s1)
           *(c1 + *s1) = 255;

       ++dg;	
    }

    /* refill user color table */

    ct = (parm.drv + loc)->ctb;
    s1 = &parm.white;
    s_end = index + dp_color[8];
    for (s2 = dp_color, s3 = index; s3 < s_end;)
        *(s1 + *s3++) = (ReaL_4)(*s2++ +.1) / ct->c_scale;

    return (1);
}
