#include "gph_typedefs.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: conv_str.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 conv_str (register ByTe_1 *istr, register ByTe_1 *ostr, ByTe_2 len,
                ByTe_1 *c_info, ByTe_2 *cnt)
{
   ByTe_2 sym,sum,offset,adv,slen;
   ByTe_1 word[25];
   register ByTe_1 *w;
   ByTe_2 w_case,w_len;


/************************************************************************/
/*  Begin to process the input string -- initialize the total number of */
/*  characters processed to 0                                           */
/************************************************************************/

   sum = 0;
   *cnt = 0;

/************************************************************************/
/*  Loop over input string until all of the characters have been        */
/*  processed                                                           */
/************************************************************************/

   while (len > sum)
   {

/************************************************************************/
/* Get beyond any leading blanks.  Each blank is counted as 1 character */
/************************************************************************/

      if (*istr == ' ')
      {
         ++istr;
         ++sum;
         if (len <= sum)
            continue;
      }

/************************************************************************/
/*  Strip out the first word in the string                              */
/************************************************************************/

      offset = strip_str (istr,word,' ',&w_case);

/************************************************************************/
/*  Update both the sstr pointer and the number of characters processed */
/************************************************************************/

      istr = istr + offset;
      sum += offset;

/************************************************************************/
/*  If the word has both upper and lowe case letters it is not a        */
/*  recognized symbol -- treat it as normal text                        */
/************************************************************************/

      if (w_case == 0)
      {
         adv = ascii_ch (word,ostr,&slen,c_info); 
         ostr = ostr + slen;
         *cnt += slen;
         continue;
      }

/************************************************************************/
/*  Check to see if the stripped out word represents as greek character */
/************************************************************************/

      if (greek_ch (word,offset,w_case,ostr,&slen,c_info))
      {
          ostr = ostr + slen;
          *cnt += slen;
          continue;
      }

      sym = symbol_ch (word,offset,ostr,&slen,c_info);
      *cnt += slen;
      if (sym == 1)
      {
            ostr = ostr + slen;
            continue;
      }
      else
         if (sym == 2)
            return (-sum);

      if (w_case == 2)
         for (w=word; w<word+offset; ++w)
             *w += 32;
      adv = ascii_ch (word,ostr,&w_len,c_info); 
      ostr = ostr + w_len;
      *cnt += w_len;

   }

   return (sum);
}
