#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#include "blockdata.h"
#define SUPSUB 0.6
#define SBOFF  0.4

static ByTe_1 rcsid[] = "$Id: chr_dspl.c,v 1.1 1999/11/21 07:46:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 chr_dspl (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 ph, ReaL_4 th, 
               ReaL_4 rot, ByTe_1 hv, ByTe_1 just, ByTe_1 *str, 
               ByTe_2 len, ByTe_2 color)
{
   extern struct   memory minfo;
   extern struct   config parm;
   extern struct   mapinfo map;
   extern struct   init_val ival;
   extern ByTe_2   indlen,iddlen;
   extern ByTe_2   idd[8625],ind[789];
   extern ByTe_2   lc[150];
   extern ByTe_2   indzer;
   extern ByTe_2   ifnt,ic,it,ito;
   extern ReaL_4   rlx,rly,rlox,rloy;
   extern u_ByTe_1 ascii[60];

   struct dev_graph *dg, *dg_end;

   static ByTe_2 mode = -1;
   static ByTe_1  err_rd = 0;

   register struct window *wn;
   register ByTe_2 *ch;
   register ByTe_1  *chr;
   register ByTe_2 *s_end;

   ReaL_8 r1,r2,r3,r4,rx,ry,st,ct,cot,sit,zz,yy,xx;
   ReaL_8 wfac,r;
   ReaL_8 ang, x1,y1;
   ReaL_8 sgn;

   ReaL_4 sprih=32.,spriw=16.,sindh=20.,sindw=12.,scarh=14.;
   ReaL_4 mxend,myend,ix,iy;
   ReaL_4 *f1,in[3],jx,jy,csize[10], sb[10];
   ReaL_4 *out; 

   int f5,f6;

   ByTe_4 slen;
   ByTe_4 test;
   ByTe_4 lev;

   ByTe_2 icnum1=49,icnum2=575,indgre=384,indind=128,indcar=256;
   ByTe_2 indlow=64;
   ByTe_2 luc_char,n3,hv_char;
   ByTe_2  id1,id2,id3,id4,ipass,ico,hv_cnt,luc_cnt,ii,indpoi,
           ierr,l2,l1,numdun,save_color,cnt;
   ByTe_2 font;
   ByTe_2 save_dev;

   ByTe_1 idpc[256];
   ByTe_1 *Fs = PathSep;
   ByTe_1 verticle;
   ByTe_1 got_l1;
   ByTe_1 save_univ, save_wndim;
   ByTe_1 a_out,a_win,updn,nc,nchol;
   ByTe_1 undone = 0,err_code;
   ByTe_1  CharPath[80];

   if ((slen = strlen (str)) == 0)
      return (-1);

   err_code = (w != parm.wn_num) ? window (w,"CHR_DSPL") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("CHR_DSPL","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   font = abs (parm.font);
   if (font%2 != mode) 
   {
       mode = font%2;
       indlen = icnum1*16;
       iddlen = (icnum2*16*15-1)/16+1;
       if (mode != 1)
       {
          /* open complex digitized ascii files */
          sprintf (CharPath,"%s%sdatafiles%spwritxc1.bin",getenv("GPH_HOME"),
                    Fs, Fs);
          f5 = open(CharPath,O_RDONLY);
          sprintf (CharPath,"%s%sdatafiles%spwritxc2.bin",getenv("GPH_HOME"),
                    Fs, Fs);
          f6 = open(CharPath,O_RDONLY);
       }
       else 
       {
          /* open duplex digitized ascii files */
          sprintf (CharPath,"%s%sdatafiles%spwritxd1.bin",getenv("GPH_HOME"),
                    Fs, Fs);
          f5 = open(CharPath,O_RDONLY);
          sprintf (CharPath,"%s%sdatafiles%spwritxd2.bin",getenv("GPH_HOME"),
                    Fs, Fs);
          f6 = open(CharPath,O_RDONLY);
       }

       lseek(f5,0L,0);
       lseek(f6,0L,0);
       read(f5,ind,indlen*2);
       read(f6,idd,iddlen*2);
       close(f5);
       close(f6);
       if (file_chk(mode) !=0)
       {
          g_error("CHR_DSPL","CHAR ARRAY NOT LOADED CORRECTLY",0);
	  err_rd = 1;
       }
   }

   wn           = parm.win;
   a_out        = parm.alt_out;
   a_win        = parm.alt_win;
   parm.c_color = color;
   save_color   = parm.l_color;
   save_univ    = parm.univ;
   save_wndim   = wn->dimen;
   font         = parm.font;
   plt_color (-1,color);

   if (parm.univ > 7)
   {
      x += map.rotlong;
      x = (x > 180.0) ? x - 360.0 : (x < -180.0) ? 360.0 + x : x;
      if (!mapxy (&x, &y, parm.univ - 8))            /* yes - tranlate pos */
         return (-1);
   }

   in[0] = x;
   in[1] = y;
   in[2] = z;
   to_univcor (1,in,0);
   if (wn->dimen == 3) {
      wn->dimen = 2;
      to_univcor (1,in,0);
   }
   out = in;


/*** determine if any of the devices must use the hard font  ***/

   cnt    = -1;
   dg = parm.drv;
   dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
   while (parm.drv < dg_end)
   {
      if (err_rd || font < 0 || (parm.drv->dev->attri & 1 ) == 1)
      {
         if (dg->_hdfont(*out,*(out+1),ph,th,rot,hv,just,str,slen,color)<0)
	 {
	    cnt += 2;
            ++undone;
         }
      }
      else
      {
	 cnt += 2;
         ++undone;
      }
      ++parm.drv;
   }

   if ((parm.cstyle==1 && (wn->type == 1 || wn->type == 3)) || parm.cstyle == 2)
   {
      f1 = (ReaL_4 *)minfo.mxyz;
      f1 += 3 * ival.points;
      *f1++ = *out;
      *f1++ = *(out+1);
      *f1++ = *(out+2);
      nc = (parm.cstyle == 1) ? 3 : 5;
      set_alt_wn (nc,parm.c_win);
   }

   parm.drv = dg;
   if (undone == 0)
   {
      plt_color (-1,save_color);
      wn->dimen = save_wndim;
      set_alt_wn (a_out,a_win);
      return (-1);
   }
   else
   {
      if ((undone != ival.devices) && (ival.devices == 2))
      {
	 parm.drv += (cnt == 1) ? 0 : 1; 
	 ival.devices = 1;
	 save_dev = 2;
      }
      else
	 save_dev = ival.devices;
   }

   if (!(str[0] == 39 && str[1] == ' ')) 
      interpret (str,idpc,hv);
   else
      strcpy (idpc,&str[2]);

   slen = strlen (idpc);

   chr = idpc;

/*** make all the fonts have the same character size ***/

   switch (font)
   {
      case 1:
      case 2:
      default:
         csize[0] = parm.csize;
         break;
      case 3:
      case 4:
         csize[0] = parm.csize * 32.0 / 20.0;
         break;
      case 5:
      case 6:
         csize[0] = parm.csize * 32.0 / 14.0;
         break;
   }

   /* Adjusting the phi angle to the window */

   while (ph < 0.0)
     ph += 360.0;

   while (ph > 360.0)
     ph -= 360.0;

   ang  = ph/90.0 - (int)(ph/90.0); 
   test = ang * 1000;
   if (test > 1 && test < 998)
   {
      ang = ph*3.1416/180.0;
      x1 = (ph > 90.0 && ph < 270.0) ? -wn->slope[0] : wn->slope[0];
      y1 = tan(ang);
      y1 = abs (y1);
      y1 = (ph > 180.0) ? -y1 * wn->slope[1] : y1 * wn->slope[1]; 
      ph = atan2 (y1,x1) * 180.0/3.1416;
   }

   id1 = ifnt;
   id2 = ic;
   id3 = it;
   id4 = ito;
   r1 = rlx;
   r2 = rly;
   r3 = rlox;
   r4 = rloy;
   sit = sine (ph);
   cot = cosin(ph);
   ipass = (just == -1) ? 1 : 0;
   plt_corsys (2);
   
   if (parm.ostyle == 1)
   {
      parm.ostyle = 2;
      sgn = -1.0;
   }
   else
      sgn = 1.0;

   while (1) 
   {
       if (ipass == 1)                         /* Only if ipass = 1 is */
          mv_n_drw(w,*out,*(out+1),0.0,0,0);   /* any drawing done     */

       lev = 0;
       got_l1 = 0;                       /* no l1 value set yet       */
       sb[0] = 0.0;                      /* no sub-sup script yet     */
       ix = *out;                        /* saved base x position     */
       iy = *(out+1);                    /* saved base y position     */
       rx = *out;                        /* base x position           */
       ry = *(out+1);                    /* base y position           */
       xx = *out;                        /* base x position           */
       yy = *(out+1);                    /* base y position           */
       zz = csize[lev] * 32.0 / 21.;     /* normalized character size */
       ct = zz * cot;
       st = zz * sit;
       rlx *= zz;
       rly *= zz;
       ii = 0;
       luc_char = 0;
       luc_cnt = 0;
       hv_char = 0;
       hv_cnt = 0;
       ico = 0;
       updn = 'A';
       verticle = 0;
       while (1)
       {
          if (++ii > slen)
             break;
          nc = *(chr + ii - 1);
          if (nc != 39)
          {
             if (nc >= ' ' && nc <= 'Z') 
             {
                if (verticle < 0)
                   verticle = 0;

                nchol = ascii [nc - ' '];
                indpoi = nchol + ifnt + ic + it;
                if (luc_char!=0)
                   ++luc_cnt;
                if (hv_char != 0)
                {
                   if (++hv_cnt > hv_char)
                      hv_char = 0;
                   else
                   {
                      if (hv_cnt != 1)
                      {
                         rx += sgn * rly * sit;
                         ry -= rly * cot;
                      }
                      verticle = 1;
                   }
                }

                numdun = xtch(indpoi,ipass);
                if (numdun!=0)
                {
                   l1 = lc[0];         /* left half-width of char         */
                   l2 = lc[1];         /* right half-width of char        */
                   got_l1 = 1;         /* left and right half-width set   */

                   if (!verticle)
                   {
                      rx -= sgn * l1 * ct;  /* update base x to mid of char  */
                      ry -= l1 * st;        /* update base y to mid of char  */
                   }

                   xx = rx;            /* save character x mid-point      */
                   yy = ry;            /* save character y mid-point      */

                   if (!verticle)
                   {
                      rx += sgn * l2 * ct;  /* update base x to end of char */
                      ry += l2 * st;        /* update base y to end of char */
                   }
                   else
                      verticle = -1;

                   if (ipass)          /* character to be output         */
                   {
                      lc[0] = indzer;
                      s_end = lc + numdun;
                      for (ch = lc + 2; ch < s_end; ch += 2)
                         if (*ch != indzer)
                         {
                            jx = xx + sgn * (*ch * ct - *(ch+1) * st + .5);
                            jy = yy + *ch * st + *(ch+1) * ct + .5;
                            if (*(ch-2) != indzer)
                               mv_n_drw(w,jx,jy,0.0,1,0);
                            else
                               mv_n_drw(w,jx,jy,0.0,0,0);
                         }
                   }

                   if (luc_char!=0)
                      if (luc_cnt>=luc_char)
                      {
                         luc_char = 0;
                         luc_cnt = 0;
                         ic = (ic+indlow)%(2*indlow);
                      }

                }
             }
             else
                g_error("CHR_DSPL","ILLEGAL CHARATER IN STRING",0);

             continue;
          }

          ierr = 0;
          while (1)
          {
               if (++ii > slen)
               {
                  mv_n_drw (w,0.,0.,0.,0,2);
                  plt_corsys (save_univ);
                  plt_color (-1,save_color);
                  set_alt_wn (a_out,a_win);
                  parm.drv = dg;
		  ival.devices = save_dev;
                  if (parm.ostyle == 2)
                      parm.ostyle = 1;
                  return (-1);
               }

               nc = *(chr + ii -1);
               switch (nc)
               {
                  default:
                     ++ierr;
                     g_error("CHR_DSPL","ILLEGAL FUNCTION CODE",0);
                     if (ierr == 10)
		     {
                        set_alt_wn (a_out,a_win);
                        parm.drv = dg;
		        ival.devices = save_dev;
                        if (parm.ostyle == 2)
                           parm.ostyle = 1;
                        return (-1);
                     }
                     break;
                  case 39:
                  case ',':
                  case 'Q':
                     break;
                  case 'A': 
                     hv_char = 0;
                     updn = 'A';
                     if (verticle == -1 && got_l1)
                     {
                        rx += sgn * l2 * ct; /* update base x to end of char */
                        ry += l2 * st;       /* update base y to end of char */
                     }
                     break;
                  case 'B':
                     sb[++lev] = -1.0;
                     break;
                  case 'C':
                     rx = ix + sgn * rly * sit;
                     ry = iy - rly * cot;
                     ix = rx;
                     iy = ry;
                     break;
                  case 'D':
                     hv_cnt = 0;
                     updn = 'D';
                     if (!verticle && got_l1)
                     {
                        rx -= sgn * l1 * ct; /* update base x to mid of char */
                        ry -= l1 * st;   /* update base y to mid of char */
                     }
                     ii = gtnum(idpc,slen,ii,&hv_char);
                     if (hv_char == 0)
                        hv_char = slen - 1;
                     hv_char = abs(hv_char);
                     break;
                  case 'G':
                     ifnt = indgre;
                     break;
                  case 'H':
                     ii = gtnum(idpc,slen,ii,&n3);
                     rx += (n3 == 0) ? sgn * rlx : sgn * rlx * n3 / 1000.0;
                     break;
                  case 'I':
                     it = indind;
                     rlx = sindw * zz;
                     rly = sindh * zz;
                     break;
                  case 'K':
                     it = indcar;
                     rlx = 8. * zz;
                     rly = scarh * zz;
                     break;
                  case 'L':
                     ic = indlow;
                     luc_cnt = 0;
                     ii = gtnum(idpc,slen,ii,&luc_char);
                     ico = ic;
                     break;
                  case 'N':
                     zz = csize[--lev] * 32.0 / 21.;
                     ct = zz * cot;
                     st = zz * sit;
                     rlx = r1 * zz;
                     rly = r2 * zz;

                     rx += sgn * rly * SBOFF * sb[lev+1] * sit;
                     ry -= rly * SBOFF * sb[lev+1] * cot;

                     break;
                  case 'P':
                     it = 0;
                     rlx = spriw * zz;
                     rly = sprih * zz;
                     break;
                  case 'R':
                     ifnt = 0;
                     break;
                  case 'S':
                     sb[++lev] = 1.0;
                     break;
                  case 'U':
                     ic = 0;
                     luc_cnt = 0;
                     ii = gtnum(idpc,slen,ii,&luc_char);
                     ico = ic;
                     break;
                  case 'V':
                     ii = gtnum(idpc,slen,ii,&n3);
                     ry += (n3 == 0) ? rly : rly * n3 / 1000.0;
                     break;
                  case 'X':
                     ii = gtnum(idpc,slen,ii,&n3);
                     rx = n3;
                     verticle = 1;
                     break;
                  case 'Y':
                     ii = gtnum(idpc,slen,ii,&n3);
                     ry = n3;
                     break;
             }

             if (nc == 'S' || nc == 'B' || nc == 'N')
             {
                if (nc != 'N')
                {
                   rx -= sgn * rly * SBOFF * sb[lev] * sit;
                   ry += rly * SBOFF * sb[lev] * cot;

                   jx = csize[lev-1] * SUPSUB;            
                   csize[lev] = (jx > 4.0) ? jx : 4.0;
                   zz = csize[lev] * 32.0 / 21.;
                   ct = zz*cot;
                   st = zz*sit;
                   rlx = r1 * zz;
                   rly = r2 * zz;
                }
                rlox = rlx;
                rloy = rly;
             }
             if (nc == 39)
                break;
           }
           if (nc == 39)
              continue;
        }

        rlx /= zz;
        rly /= zz;

        if (ipass)
           break;

        ipass = 1;                          /* Initiate text output phase */
/*
        mxend = xx + l2 * ct - *out;   
        myend = yy + l2 * st - *(out+1);
*/
        mxend = rx - *out;        /* X-length of text           */
        myend = ry - *(out+1);    /* Y-length of text           */
        r = mxend*mxend + myend*myend;      /* Absolute test length       */
        r = sqrt(r);
        wfac = (just == 0) ? -0.5 : -1.0;
        if (updn == 'D')
        {
           *out += wfac * r * sit;
           *(out+1) -= wfac * r * cot;
        }
        else
        {
           *out += mxend*wfac;
           *(out+1) += myend*wfac;
        }
        ifnt = id1;
        ic = id2;
        it = id3;
        ito = id4;
        rlx = r1;
        rly = r2;
        rlox = r3;
        rloy = r4;
   }
   mv_n_drw (w,0.0,0.0,0.0,0,2);
   plt_corsys (save_univ);
   plt_color (-1,save_color);
   set_alt_wn (a_out,a_win);
   parm.drv = dg;
   ival.devices = save_dev;
   wn->dimen = save_wndim;
   if (parm.ostyle == 2)
      parm.ostyle = 1;
   return(1);
}
