#include "gph_str.h"
#include "gph_ansi.h"

#define abs(a) ((a) > 0) ? (a) : -(a);

static ByTe_1 rcsid[] = "$Id: box.c,v 1.1 1999/11/21 07:46:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 box (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, 
                      ReaL_4 xx, ReaL_4 yy, ReaL_4 zz)
{
   extern struct config parm;

   register ReaL_4 *f1, *f2, *f3;
   register ReaL_4 tmp;

   ReaL_4 rx[5],ry[5],rz[5];
   ByTe_1 err_code;
     
   err_code = (w != parm.wn_num) ? window (w,"BOX") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("BOX","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

  /**** Because of convensions assumed in the driver routines, ****/
  /**** in particular the polygon fill routine, that the boxes ****/
  /**** are drawn counter-clockwise - shift the points to      ****/
  /**** ensure this will occur -- note that we really only     ****/
  /**** need to do this if fill is on but it probably costs    ****/
  /**** little in time to do it for all cases - also it is     ****/
  /**** needed for two dimensional figures but again it won't  ****/
  /**** hurt to do it for boxes drawn in the xy plane          ****/

   if (xx == x || yy == y)
   {
      mv_n_drw (w,x,y,z,0,0);
      mv_n_drw (w,xx,yy,zz,1,1);
   }
   else
   {
      f1 = rx;
      f2 = ry;
      f3 = rz;

      if (x > xx)
      {
         tmp = x;
         x   = xx;
         xx  = tmp;
      }
      if (y > yy)
      {
         tmp = y;
         y   = yy;
         yy  = tmp;
      }

      *f1++ = x;
      *f2++ = y;
      *f3++ = z;
      *f1++ = xx;
      *f2++ = y;
      *f3++ = z;
      *f1++ = xx;
      *f2++ = yy;
      *f3++ = z;
      *f1++ = x;
      *f2++ = yy;
      *f3++ = z;
      *f1 = x;
      *f2 = y;
      *f3 = z;

      poly (w,rx,ry,rz,5);

   }
   return (1);
}
