/***************************************************************************
 *                                                                         *
 *  Set the axis scaling in window n.  Scaling along any of the three      *
 *  orthogonal axis can be set to linear (0) or log (1)                    *
 *                                                                         *
 ***************************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: axis_scale.c,v 1.1 1999/11/21 07:46:14 chris.gurgiolo.b2r Stab chrisg $";

void axis_scale (ByTe_1 w, ByTe_1 x, ByTe_1 y, ByTe_1 z)
{
  extern struct config parm;

  register ByTe_1 *c1, *c2;

  ByTe_1 Ec;
  ByTe_1 sca[3];
   
  if (w != parm.wn_num)
     Ec = window (w,"AXIS_SCALE");

  c1 = sca;
  *c1++ = x;
  *c1++ = y;
  *c1   = z;

  c2 = parm.win->axis;
  for (c1 = sca; c1 < sca + parm.win->dimen; ++c1,++c2)
  {
     if (*c1 < 0 || *c1 > 1)
     {
        g_error ("AXIS_SCALE","BAD SCALE VALUE -- SET TO LINEAR",0);
        *c2 = 0;
     }
     else
        *c2 = *c1;
  }

  if (parm.win->open)
     scale_win (0);    

}
