#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: arc.c,v 1.1 1999/11/21 07:46:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 arc (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 r, ReaL_4 start, 
            ReaL_4 stop, ReaL_4 res, ByTe_1 gen)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;

   register struct window *wn;
   register struct dev_graph *dg, *dg_end;
   register ReaL_4 *f1;
   register ReaL_4 rad;

   ReaL_4 in[3], hold;
   ReaL_4 mres, dang;
   ByTe_4 proj;
   ByTe_1 err_code;
   
   err_code = (w != parm.wn_num) ? window (w,"ARC") : parm.win->open;
   if (err_code <= 0)
   {
       g_error ("ARC","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
       return (0);
   }

   if (parm.univ > 7)
   {
      proj = parm.univ - 8;
      in[0] = x;
      in[1] = y;
      mapxy ( &in[0], &in[1], proj); 
      x = in[0];
      y = in[1];
      in[0] = 0.0;
      in[1] = r;
      mapxy ( &in[0], &in[1], proj); 
      r = in[0];
   }

   wn = parm.win;
   dang = stop - start; 

 /**********************************************************************/
 /*  If the window has been flipped or rotated then the arc must also  */
 /*  be flipped or rotated -- this is done through a change in the     */
 /*  beginning and ending angles                                       */
 /*                                                                    */
 /*  First correct for window rotation                                 */
 /**********************************************************************/
  
   if (wn->ang[2] != 0 && dang != 360.0)
   {
      start = start + wn->ang[2]/10.0;
      stop = stop + wn->ang[2]/10.0;
   }

/**********************************************************************/
/*  Correct for window flipping                                       */
/**********************************************************************/

   if (wn->flip[0] == 1)
   {
      hold = start;
      start = 360 - stop;
      stop = 360 - hold;
   }

   if (wn->flip[1] == 1)
   {
      hold = start;
      start = 180 - stop;
      stop = 180 - hold;
   }

/**********************************************************************/
/*  Put the beginning and ending angles in the range 0 to 360 degrees */
/**********************************************************************/

   while (start < 0.0)
     start += 360.0;

   start = 360.0 * (start / 360.0 - (ByTe_4) (start / 360.0));
   stop  = 360.0 * (stop  / 360.0 - (ByTe_4) (stop  / 360.0));
   if (stop <= start)
      stop += 360.0;

/**********************************************************************/
/*  resolution check -- make sure that the resolution will give at    */
/*  least three points along the arc                                  */
/**********************************************************************/

   if (res <= 0)
   {
      res = 1.0;
      g_error ("ARC","RESOLUTION <= 0  -- SET TO 1",0);
   }

   dang = stop - start; 
   if (dang < 360.0 || parm.fill < 0)
   {
      mres = dang / 2.0;
      if (mres < res)
      {
	 res = mres;
         g_error ("ARC","RESOLUTION TO LARGE -- SET TO MAXIMUM",0);
      }
   }
   else
   {
      mres = dang / 3.0;
      if (mres < res)
      {
	 res = mres;
         g_error ("ARC","RESOLUTION TO LARGE -- SET TO MAXIMUM",0);
      }
   }

   if (gen == 1)
   {
      f1 = in; 
      *f1++ = r;
      *f1++ = r;
      *f1   = 0.0;
      to_univcor (1,in,0);
      rad = in[0];

      f1 = in; 
      *f1++ = 0.0;
      *f1++ = 0.0;
      *f1   = 0.0;
      to_univcor (1,in,0);
      rad -= in[0];
      if (rad < 0)
         rad = -rad;

      f1 = in; 
      *f1++ = x;
      *f1++ = y;
      *f1   = z;
      to_univcor (1,in,0);

      dg = parm.drv;
      dg_end = (struct dev_graph *)minfo.mdrv + ival.devices;
      while (parm.drv < dg_end)
      {
          if (parm.drv->_arc (in[0],in[1],rad,start,stop,res) == -1)
             soft_arc (x,y,z,r,start,stop,res,gen);
         ++parm.drv;
      }
      parm.drv = dg;

   }
   else
      soft_arc (x,y,z,r,start,stop,res,gen);

   return (1);
}
