/**********************************************************************/
/*                                                                    */
/*  NOTE:  This implementation of vectors does not preserve the       */
/*         the incoming arrays!  A better implementation would be     */
/*         to use the mxyz array multiple times to build do the       */
/*         output through lines.                                      */
/*                                                                    */
/**********************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: VecTors.c,v 1.1 1999/11/21 07:46:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 VecTors (ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 *L, ReaL_4 *P, 
                     ReaL_4 *T, ByTe_2 N)
{
   register ReaL_4 *f1, *fp, *ft, *fend;
   ReaL_4 R[6];
   ReaL_4 st;

   if (N < 1)
   {
      if (N == 1) 
         return ( VecTor (w,x, y, z, L[0], P[0], T[0]) );

      R[0] = x;
      R[1] = y;
      R[2] = z;
      fend = L + N;

      for (f1 = L, fp = P, ft = T; f1 < fend; ++f1, ++fp, ++ft) 
      {
         st = sine(*ft);
         R[3] = R[0] + *f1 * st * cosin(*fp);
         R[4] = R[1] + *f1 * st * sine(*fp);
         R[5] = R[2] + *f1 * cosin(*ft);
   
         *f1 = R[0];
         *fp = R[1];
         *ft = R[2];
         R[0] = R[3];
         R[1] = R[4];
         R[2] = R[5];
      }

      *f1 = R[0];
      *fp = R[1];
      *ft = R[2];

      return ( lines (w, L, P, T, N+1) );
   }

   g_error ("VECTORS","< 1 END POINT, NO OUTPUT",0);
   return (0);
}
