#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: plot_2d.c,v 1.1.1.1 2000/02/01 15:04:28 chrisg Exp chrisg $";

/*********************************************************************
*                                                                    *
*                      PLOT_2D  SUBROUTINE                           *
*                                                                    * 
*  DESCRIPTION                                                       * 
*                                                                    * 
*  INPUT VARIABLES                                                   * 
*     fmt - plot format                                              *
*           0 - histogram, data at edge                              *
*           1 - histogram, data centered                             *
*           2 - scatter plot                                         *
*           3 - line plot                                            *
*           4 - bar graph, data at edge                              *
*           5 - bar graph, data centered                             *
*           6 - labeled lines                                        *
*                                                                    * 
*  USAGE                                                             * 
*                                                                    * 
*  NECESSARY SUBPROGRAMS                                             * 
*                                                                    * 
*  EXTERNAL VARIABLES                                                * 
*                                                                    * 
*  INTERNAL VARIABLES                                                * 
*                                                                    * 
*  BUGS                                                              * 
*                                                                    * 
*********************************************************************/

ByTe_4 plot_2d(ByTe_1 pn, ByTe_1 ax, ByTe_1 ay, ByTe_1 az, ReaL_4 *x, 
             ReaL_4 *y, ReaL_4 *z, ByTe_4 beg, ByTe_4 end,
             ByTe_1 *fmt, ByTe_2 hue)
{
   extern struct config parm; 
   struct window *wn; 
   struct graph  *gf; 
   register ReaL_4 *f1, *f2, *f3;
   register ReaL_4 xx;
   register ByTe_1 *c1,*c2;
   register ByTe_2 i;
   ReaL_4 *fend;
   ReaL_4 dist, *f4, *f5;
   ReaL_4 dx;
   ByTe_1 vp,sav_clip,sav_lstyle,axis[3],sav_bd[3];
   ByTe_1 same,sav_fill;
   ByTe_2 sav_color;
   ByTe_2 sav_csize,cs,sav_fcolor;
   ByTe_2 labhue;
   ReaL_4 sav_ex[3],x1,y1,yl,xl;
   ByTe_1 mv_flg;
   ByTe_1 Lg1, Lg2, mode, adv, DiR;
   ByTe_2 npts;

   if (plotnm (pn,"PLOT_2D",1) != 1 )
   {
       g_error ("PLOT_2D","REQUESTED PLOT HAS NOT BEEN DEFINED",0);
       return (0);
   }

   if (end < 0)
   {
      g_error ("PLOT_2D","END POINT LESS THAN ZERO",0);
      return (0);
   }

   if (beg < 0)
      beg = 0;

   npts = end - beg + 1;
   if (npts < 2 && fmt[0] != 2)
   {
      g_error ("PLOT_2D","LESS THAN TWO DATA POINTS AND LINE OUTPUT",0);
      return (0);
   }

   gf = parm.grf;
   vp = gf->window;
   wn = parm.win;
   sav_color = parm.l_color;
   sav_fcolor = parm.f_color;
   sav_fill = parm.fill;
   sav_lstyle = parm.lstyle;
   sav_clip = wn->clip;
   plt_color (0,hue);
   clip (vp,1);

   c2 = gf->axis;
   for (c1 = axis; c1 < axis + 3;)
      *c1++ = *c2++; 

   for (i=0; i<3; ++i)
   {
      sav_bd[i] = gf->bad_data[i];
      sav_ex[i] = gf->exclude[i];
   }

   same = set_axis (pn,ax,ay,az);

/*** initial check for log scaling and data which is <= 0.0  ***/

   f1 = x + beg;
   f2 = f1 + npts;
   for (i=0; i<2; ++i)
   {
       if (wn->axis[i] == 1)
       {
          if (gf->bad_data[i] != 'O')
          {
             for (; f1 < f2; ++f1) 
                if (*f1 <= 0)
	           *f1 = gf->exclude[i];
          }
          else
          {
             gf->bad_data[i] = 'L';
             gf->exclude[i]  = 0.0;
          }
       }

       f1 = y + beg;
       f2 = f1 + npts;
   }
       
   switch (*fmt)
   {
      case 0:
         DiR = fmt[1];
         f1 = x + beg;
         f2 = y + beg;
         fend = x + end;
         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
             mv_n_drw (vp, *f1, *f2, 0.0, 0, 0);
             if (DiR == 0)
             {
                for ( ; f1 < fend; )
                {
                    mv_n_drw (vp, *(++f1), *f2, 0.0, 1, 0);
                    mv_n_drw (vp, *f1, *(++f2), 0.0, 1, 0);
                }
             }
             else
             {
                for ( ; f1 < fend; )
                {
                    mv_n_drw (vp, *f1, *(++f2), 0.0, 1, 0);
                    mv_n_drw (vp, *(++f1), *f2, 0.0, 1, 0);
                }
             }
         }
         else
         {
            mv_flg  = 0;
            for ( ; f1 < fend;  ++f1, ++f2)
            {
               if (legal (*f1, *f2, 0.0) == 1)
               {
                  if (mv_flg == 0)
                  {
                     mv_n_drw (vp, *f1, *f2, 0.0, 0,0);
                     mv_flg = 1;
                  }
                  else
                  {
                     mv_n_drw (vp, *f1, y1, 0.0, mv_flg, 0);
                     mv_n_drw (vp, *f1, *f2, 0.0, mv_flg, 0);
                  }
                  y1 = *f2;
               }
	       else
	          mv_flg = 0;
            }
         }
         mv_n_drw (vp,0.0,0.0,0.0,0,2);
         break;
      case 1:
         f1 = x + beg;
         f2 = y + beg;
         fend = x + end;
         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
            x1 = *f1++;
            y1 = *f2++;
            mv_n_drw (vp, x1, y1, 0.0, 0, 0);

            xl = x1 - ( *f1 - x1 ) / 2;
            mv_n_drw (vp,xl,y1,0.0,1,0);

            for ( ; f1 <= x + end; )
            {
               dist = x1 + (*f1 - x1)/2;
   
               mv_n_drw (vp,dist,y1,0.0,1,0);
               mv_n_drw (vp,dist,*f2,0.0,1,0);
               mv_n_drw (vp,*f1,*f2,0.0,1,0);
               
               x1 = *f1++;
               y1 = *f2++;
            }
         }
         else
         {
            mv_flg  = 0;
            Lg1 = legal (*f1, *f2, 0.0);
            x1 = *f1++;
            y1 = *f2++;
            for ( ; f1 <= x + end;)
            {
               Lg2 = legal (*f1, *f2, 0.0);
               if (mv_flg == 0)
               {
                  if (Lg1 == 1 && Lg2 != 2 && Lg2 != 6)
                  {
                     mv_n_drw (vp,x1,y1,0.0,0,0);
                     mv_flg = 1;
                  }
                  else
                  {
                     if (Lg2 == 1 && Lg1 != 2 && Lg1 != 6)
                     {
                        xl = x1 + (*f1 - x1)/2;
                        mv_n_drw (vp, xl, *f2, 0.0, 0, 0);
                        mv_flg = 1;
                     }
                  }
               }

               if (mv_flg == 1)
               {
                  if (Lg1 == 1 && Lg2 != 2 && Lg2 != 6)
                  {
                     xl = x1 + (*f1 - x1)/2;
                     mv_n_drw (vp, xl, y1, 0.0, 1, 0);
                  }

                  if (Lg1 == 1 && Lg2 == 1)
                  {
                     xl = x1 + (*f1 - x1)/2;
                     mv_n_drw (vp, xl, *f2, 0.0, 1, 0);
                  }

                  if (Lg2 == 1 && Lg1 != 2 && Lg1 != 6)
                     mv_n_drw (vp, *f1, *f2, 0.0, 1, 0);

                  if (Lg2 != 1)
                     mv_flg = 0;
               }

               x1 = *f1++;
               y1 = *f2++;
               Lg1 = Lg2;
            }
         }
         mv_n_drw (vp,0.0,0.0,0.0,0,2);
         break;
      case 2:
         c1 = fmt + 1;                /* data label      */
         fend = x + end;

         sav_csize = parm.csize;
         c2 = fmt + 1;                /* data label      */
         while (*c2++ != '\0');       /* skip data label */
         if (*c2 != '\0')             /* csize given     */
         {                            /* yes             */
            sscanf(c2,"%hd",&cs);     /* get it          */
            chr_size (cs);            /* apply it        */
         }
         while (*c2++ != '\0');       /* skip char size  */
         if (*c2 != '\0')             /* hold specified? */
         {                            /* yes             */
            sscanf(c2,"%f",&dx);      /* get it          */
            adv = 1;                  /* set advance     */
         }
         else 
            adv = 0;

         f3 = (wn->dimen == 2) ? x:z;

         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
            if (*c1 == '\0')
            {
               plt_color (0,hue);
               for (f1 = x + beg ,f2 = y + beg; f1 <= x + end; ++f1,++f2) 
               {
                   point(vp,*f1,*f2,*f3);
                   if (adv)
                   {
                      for (xx = *f1 + dx; xx < *(f1 + 1); xx += dx)
                          point(vp,xx,*f2,*f3);
                   }
               }
            }
            else
            {
               for (f1 = x + beg ,f2 = y + beg; f1 <= x + end; ++f1,++f2) 
               {
                   chr_dspl(vp,*f1,*f2,*f3,0.0,0.0,0.0,0,0,c1,-1,hue);
                   if (adv)
                   {
                      for (xx = *f1 + dx; xx < *(f1 + 1); xx += dx)
                         chr_dspl(vp,xx,*f2,*f3,0.0,0.0,0.0,0,0,c1,-1,hue);
                   }
               }
            }
         }
         else
         {
            if (*c1 == '\0')
            {
               plt_color (0,hue);
               for (f1 = x + beg ,f2 = y + beg; f1 <= x + end; ++f1,++f2) 
	           if (legal(*f1,*f2,0.0) == 1)
                   {
                       point(vp,*f1,*f2,*f3);
                       if (adv)
                       {
                          for (xx = *f1 + dx; xx < *(f1 + 1); xx += dx)
                             point(vp,xx,*f2,*f3);
                       }
                   }
            }
            else
            {
               for (f1 = x + beg ,f2 = y + beg; f1 <= x + end; ++f1,++f2) 
	           if (legal(*f1,*f2,0.0) == 1)
                   {
                       chr_dspl(vp,*f1,*f2,*f3,0.0,0.0,0.0,0,0,c1,-1,hue);
                       if (adv)
                       {
                          for (xx = *f1 + dx; xx < *(f1 + 1); xx += dx)
                             chr_dspl(vp,xx,*f2,*f3,0.,0.,0.,0,0,c1,-1,hue);
                       }
                   }
            }
         }
         chr_size (sav_csize);
      break;
      case 3:
         f1 = x + beg;
         f2 = y + beg;
         fend = x + end;
         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
            mv_n_drw (vp,*f1++,*f2++,0.0,0,0);
            for ( ; f1 <= x + end; )
                mv_n_drw (vp,*f1++,*f2++,0.0,1,0);
         }
         else
         {
            mv_flg  = 0;
            for ( ; f1 <= x + end; ++f1,++f2)
            {
               if (legal (*f1, *f2, 0.0) == 1)
               {
                  mv_n_drw (vp,*f1,*f2,0.0,mv_flg,0);
                  if (mv_flg == 0)
                     mv_flg = 1;
               }
	       else
	          mv_flg = 0;
            }
         }
         mv_n_drw (vp,0.0,0.0,0.0,0,2);
         break;
      case 4:
         f1 = x + beg;
         f2 = y + beg;
         yl = parm.grf->gwn->plot[1];
         fill (0,hue);
         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
            x1 = *f1++;
            for ( ; f1 <= x + end; )
            {
                box (vp,x1,yl,0.0,*f1,*f2++,0.0);
                x1 = *f1++;
            }
         }
         else
         {
            mv_flg  = 0;
            for ( ; f1 <= x + end; ++f1,++f2)
            {
               if ((Lg1 = legal (*f1,*f2,0.0)) == 1)
               {
                  if (mv_flg == 0)
                  {
                     x1 = *f1;
                     y1 = *f2;
                     mv_flg = 1;
                  }
                  else
                     box (vp,x1,yl,0.0,*f1,y1,0.0);
                  x1 = *f1;
                  y1 = *f2;
               }
	       else
               {
                  if (mv_flg == 1 && Lg1 == 3)
                     box (vp,x1,yl,0.0,*f1,y1,0.0);
	          mv_flg = 0;
               }
            }
         }
         break;
      case 5:
         fill (0,hue);
         f1 = x + beg;
         f2 = y + beg;
         yl = parm.grf->gwn->plot[1];

         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
         {
            x1 = *f1++;
            y1 = *f2++;
            xl = x1 - (*f1 - x1)/2;
            box (vp, xl, y1, 0.0, x1, y1, 0.0);
            for ( ; f1 <= x + end; )
            {
               dist =   x1 + (*f1 - x1)/2;
               box (vp,x1,yl,0.0,dist,y1,0.0);
               box (vp,dist,yl,0.0,*f1,*f2,0.0);
               x1 = *f1++;
               y1 = *f2++;
            }
         }
         else
         {
            mv_flg  = 0;
            for ( ; f1 <= x + end;)
            {
               Lg2 = legal (*f1, *f2, 0.0);
               if (Lg2 != 2 && Lg2 != 6)
	       {
                   if (mv_flg == 0)
                   {
                      x1 = *f1;
                      y1 = *f2;
                      Lg1 = Lg2;
                      mv_flg = 1;
                   }
                   else
                   {
                      if (mv_flg == 1 && Lg1 == 1)
                      {
                         xl = x1 - (*f1 - x1)/2;
                         box (vp, xl, y1, 0.0, x1, y1, 0.0);
                         mv_flg = 2;
                      }
                      dist = x1 + (*f1 - x1)/2;
                      if (Lg1 == 1)
                         box (vp,x1,yl,0.0,dist,y1,0.0);
                      if (Lg2 == 1)
                         box (vp,dist,yl,0.0,*f1,*f2,0.0);
                   }
               }
               else
                  mv_flg = 0;

               x1 = *f1++;
               y1 = *f2++;
               Lg1 = Lg2;
            }

            if (Lg2 == 1)
            {
               dist = x1 + (*(f1 - 1) - x1)/2;
               box (vp, x1, yl, 0.0, dist, y1, 0.0);
            }

         }
         break;
      case 6:
         c1 = fmt + 1;                       /* data point label */
         c2 = fmt + 1;                       /* data point label */
         while (*c2++ != '\0');              /* skip label       */
         if (*c2 != '\0')                    /* character size   */
            sscanf(c2,"%hd",&cs);            /* read if there    */
         else                                /* else             */
            cs = parm.csize;                 /* current size     */
         while (*c2++ != '\0');              /* skip char size   */
         mode = (*c2 == '\0') ? 1 : *c2;     /* get mode         */
         while (*c2++ != '\0');              /* skip mode        */
         if (*c2 == '\0')                    /* at color         */
            labhue = hue;                     /* default hue      */
         else                                /* else             */
            sscanf(c2,"%hd",&labhue);        /* get data lab hue */

         f1 = x + beg;
         f2 = y + beg;
         if (gf->bad_data[0] == 'O' && gf->bad_data[1] == 'O')
            lab_lines (vp,f1,f2,f1,npts,c1,mode,cs,labhue);
         else
         {
            npts = 0;
            f4 = f1;
            f5 = f2;
            for ( ; f1 <= x + end; ++f1,++f2)
            {
               if (legal (*f1,*f2,0.0) == 1)
                  ++npts;
	       else
               {
                  if (npts > 0)
                     lab_lines (vp,f4,f5,f4,npts,c1,mode,cs,labhue);
                  f4 = f1 + 1;
                  f5 = f2 + 1;
                  npts = 0;
               }
            }
            if (npts > 0)
               lab_lines (vp,f4,f5,f4,npts,c1,mode,cs,labhue);
         }

         break;
   }
     

   plt_color (sav_lstyle,sav_color);
   clip (vp,sav_clip);
   fill (sav_fill,sav_fcolor);
   for (i=0; i<3; ++i)
   {
      gf->exclude[i]  = sav_ex[i];
      gf->bad_data[i] = sav_bd[i];
   }

   if (!same)
      same = set_axis (pn,axis[0],axis[1],axis[2]);

   return (1);
}
