#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: init_gf.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 init_gf (ByTe_1 gn)
{
    extern struct config parm;
    extern struct memory   minfo;
    extern struct init_val ival;
    struct graph   *gf, *gf_end;
    struct numbers *nm;
    struct window  *swn, *wn_end;
    struct labels  *lb;
    register ReaL_4 *fpt;
    register ByTe_2 *spt;
    register u_ByTe_1 *ucpt;
    register ByTe_1 *cpt;
    ByTe_1 save_w;

    if (minfo.mgraf == NOMEM)
      return (0);

    if (gn >= 0)
    {
       gf = (struct graph *)minfo.mgraf;
       gf_end = gf + ival.graphs;
       for ( ; gf < gf_end; ++gf)
          if (gf->plotnm == gn)
	     break;

       if (gf >= gf_end)
          return (0);
    }
    else
       gf = parm.grf;

    if (parm.win != gf->gwn)
    {
       swn         = parm.win;
       save_w      = parm.wn_num;
       parm.win    = parm.grf->gwn;
       parm.wn_num = -1;
       close_win (-1);
       parm.win    = swn;
       parm.wn_num = save_w;
    }
    else
    {
       close_win (gf->window);
       parm.wn_num = 0;
       if (minfo.mwin == NOMEM)
          return (0);

       swn = (struct window *)minfo.mwin;
       wn_end = swn + ival.windows;
       for ( ; swn < wn_end; ++swn)
       {
          if (swn->viewport >= 0)
          {
             parm.win   = swn;
             parm.wn_num = swn->viewport;
             break;
          }
       }
    }

    nm = parm.grf->num;
    lb = parm.grf->lab;

    gf->plotnm = -1;
    
    cpt = &gf->plot;
    *cpt++ = 0;
    *cpt++ = 0;
    *cpt++ = 0;
    *cpt++ = -1;
    *cpt++ = 0;
    *cpt++ = 0;
    *cpt++ = 'O';
    *cpt++ = 'O';
    *cpt++ = 'O';
    *cpt++ = 0;
    *cpt++ = 0;
    *cpt++ = 0;
    *cpt++ = 4;
    *cpt++ = 8;
    for (; cpt < gf->dr_axis;)
        *cpt++ = 0;
    for (; cpt < gf->dr_axis + 24;)
        *cpt++ = 1;

    ucpt = gf->mj_tcs;
    for (; ucpt < gf->mj_tcs + 12;)
        *ucpt++ = 5;

    spt = gf->mj_tc_len;
    for (; spt < gf->mn_tc_len;)
        *spt++ = 10;
    for (; spt < gf->mn_tc_len+6;)
        *spt++ = 5;

    fpt = gf->exclude;
    for (; fpt < gf->exclude + 33;)
        *fpt++ = 0.0;

    lb->font = 1;

    cpt = lb->base_set;
    for (; cpt < lb->base_set + 12;)
        *cpt++ = 0.0;

    lb->size    = 16;
    lb->spacing = 1.5;
    lb->offset  = 1.0;

    fpt = lb->obase;
    for (; fpt < lb->obase + 24;)
        *fpt++ = 0.0;

    cpt = nm->font;
    for (; cpt < nm->skip;)
        *cpt++ = 1;
    for (; cpt < nm->skip + 24;)
        *cpt++ = 0;

    spt = nm->size;
    for (; spt < nm->size + 6;)
        *spt++ = 16;

    fpt = nm->spacing;
    for (; fpt < nm->gap;)
        *fpt++ = 1.0;
    for (; fpt < nm->obase;)
        *fpt++ = 2.0;
    for (; fpt < nm->obase + 24;)
        *fpt++ = 0.0;

    parm.gf_num = -1;

    return (1);
}
