#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: color_bar.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

void color_bar (ByTe_1 gn, ByTe_1 w, ReaL_4 x1, ReaL_4 y1, ReaL_4 z1, 
                ReaL_4 x2, ReaL_4 y2, ReaL_4 z2, ByTe_1 *fmt, ReaL_4 mn, 
                ReaL_4 mx, ReaL_4 *col)
{
   extern struct config parm;

   struct color    *ct;
   struct scr_info *dv;
   struct window   *wn;

   register u_ByTe_1 *c1, *cend;
   register ByTe_1 *c2;

   ReaL_4 up, low, interval;

   ByTe_4  C, min_cl, max_cl;

   ByTe_2 col_s, cols = 0;

   ByTe_1 gw;
   ByTe_1 exc, cor, sca, ver, out;

   ByTe_1 *name = "COLOR_BAR";
   ByTe_1 *error1 = "UNKNOWN EXC VALUE -- SET TO 1";
   ByTe_1 *error2 =  "UNKNOWN COR VALUE -- SET TO 4";
   ByTe_1 *error3 = "MAX OR MIN <= 0 WITH LOG SCALING, NOW LINEAR SCALING";
   ByTe_1 *error4 = "UNKNOWN VER VALUE -- SET TO 1";
   ByTe_1 *error5 = "UNKNOWN OUT VALUE -- SET TO 1";

/*
   plotnm (gn, name, 0); 
*/

   c2 = fmt;                                      /* pntr to fmt array       */

   /**************************************************************************/
   /*  These next few lines do nothing but check the input looking for       */
   /*  correct values.  If no values are given, then default values are      */
   /*  supplied.  An early value of 100 means rest are default.              */ 
   /**************************************************************************/

   if (*c2 == 100)                                /* default format?         */
      exc = 1;                                    /* yes exc to 1            */
   else                                           /* no - take given value   */ 
   {
      exc = *c2++;                                /* set exc and adv fmt ptr */
      if (exc < 0 || exc > 1)                     /* valid exc value?        */
      {                                           /* no!                     */
         g_error (name, error1, 0);               /* tell user               */
         exc = 1;                                 /* 1st & last colors omit  */
      }
   }

   if (*c2 == 100)                                /* default format?         */
      cor = 4;                                    /* yes cor to 4            */
   else                                           /* no - take given value   */ 
   {
      cor = *c2++;                                /* set cor and adv fmt ptr */
      if (cor < 0 || cor > 7)                     /* valid cor value?        */
      {                                           /* no!                     */
         g_error (name, error2, 0);               /* tell user               */
         cor = 4;                                 /* set to win scaling      */
      }
   }

   if (*c2 == 100)                                /* default format?         */
      sca = 0;                                    /* yes sca to 0 (linear)   */
   else                                           /* no - take given value   */ 
   {
      sca = *c2++;                                /* set cor and adv fmt ptr */
      if ((mx <= 0.0 || mn <= 0.0) && sca == 1)   /* neg scaling & log axis? */ 
      if (cor < 0 || cor > 7)                     /* valid cor value?        */
      {                                           /* no!                     */
         g_error (name, error3, 0);               /* tell user               */
         sca = 0;                                 /* scaling to linear       */
      }
   }

   if (*c2 == 100)                                /* default format?         */
      ver = 1;                                    /* yes ver to 1 (vertical) */
   else                                           /* no - take given value   */ 
   {
      ver = *c2++;                                /* set ver and adv fmt ptr */
      if (ver < 0 || ver > 1)                     /* valid ver value?        */
      {                                           /* no!                     */
         g_error (name, error4, 0);               /* tell user               */
         ver = 1;                                 /* ver to vertical         */
      }
   }

   if (*c2 == 100)                                /* default format?         */
      out = 1;                                    /* yes out to 1 (draw)     */
   else                                           /* no - take given value   */ 
   {
      out = *c2++;                                /* set out and adv fmt ptr */
      if (out < 0 || out > 1)                     /* valid out value?        */
      {                                           /* no!                     */
         g_error (name, error5, 0);               /* tell user               */
         out = 1;                                 /* out to draw colorbar    */
      }
   }

   dv = parm.drv->dev;                            /* pntr to device info     */
   ct = parm.drv->ctb;                            /* pntr to color tbl info  */

   if (out == 1)                                  /* c-bar to be drawn?      */
   {                                              /* yes!                    */
      place_plot (gn,w,x1,y1,z1,x2,y2,z2,cor);    /* place the colorbar      */
      plot_axis (gn,0,0,0,0,0,0);                 /* all scales linear       */
      plot_scale (gn, 2, 0., 0., 0., 1., 1., 0.); /* generic min, max values */
      axis_fmt (gn,0);                            /* axis = box              */
      init_plot (gn,0,4,8);                       /* initialize c_bar window */

      gw = parm.grf->window;                      /* c_bar window number     */

      wn = parm.win;                              /* pntr to window info     */

      wn->clip = 1;                               /* clipping on to edge     */
   }

   /**************************************************************************/
   /* If this is a color device,,then find the first loaded position in the  */
   /* color table beginning from 0 and then the number of sequential colors  */
   /* loaded                                                                 */
   /**************************************************************************/

   min_cl = 0;                                    /* init 1st color pos to 0 */
   if (dv->ctl > 2)                               /* device has > 2 colors?  */
   {                                              /* yes!                    */
      c1 = (u_ByTe_1 *)ct->wcp;                   /* pntr to color tbl stat  */
      cend = c1 + dv->ctl;                        /* end of color tbl stat   */
      while (*c1 == 0 || *c1 == 255)              /* while no color loaded   */
      {
         ++c1;                                    /* inc pos in color status */
         ++min_cl;                                /* inc pos of 1st color    */
      }

      max_cl = min_cl;                            /* save beg color location */ 
      for ( ; c1 < cend; ++c1)                    /* loop over rest of tbl   */
      {
         if (*c1 > 0 && *c1 != 255)               /* loaded color?           */
            ++max_cl;                             /* yes! new max color pos  */
         else                                     /* break in color table    */
            break;                                /* we found a max          */
      } 

      cols = max_cl - min_cl - 2 * exc;           /* colors in color bar     */
      if (cols < 3)                               /* only 1 or 2 colors?     */
      {                                           /* yes - make it equiv b/w */
         min_cl = 0;                              /* set min color pos       */
         max_cl = 1;                              /* set max color pos       */
      }
      else
      {
         min_cl = min_cl + exc;                   /* set min color pos       */
         max_cl = max_cl - exc - 1;               /* set max color pos       */
      }
   }
   else                                           /* b/w color setup         */
      max_cl = 1;                                 /* set max color pos       */

   if (out == 1)                                  /* c-bar to be drawn?      */
   {                                              /* yes!                    */
      if (cols > 2)                               /* more than two colors?   */
      {                                           /* yes!                    */
         col_s = min_cl;                          /* start color location    */

         interval = 1.0/(ReaL_4)cols;             /* height per color        */
         low = 0.0;                               /* low boundary of c-bar   */
         if (ver == 1)                            /* color bar is vertical?  */
         {                                        /* yes!                    */
            while (col_s <= max_cl)               /* loop over colors        */
            {
               C = (col_s + 0.5) / ct->c_scale;   /* middle of color band    */
               fill (0, (ByTe_2)C);               /* turn on fill            */
               up = low + interval;               /* upper edge for this col */
               box (gw,0.0,low,0.0,1.0,up,0.0);   /* put it in color bar     */
               low = up;                          /* top edge now bottom     */
               ++col_s;                           /* next color              */
            }
         }
         else                                     /* horizontal color bar    */
         {
            low = 0.0;                            /* left boundary of c-bar  */
            while (col_s <= max_cl)               /* loop over colors        */
            {
               C = (col_s + 0.5) / ct->c_scale;   /* middle of color band    */
               fill (0, (ByTe_2)C);               /* turn on fill            */
               up = low + interval;               /* right edge for this col */
               box (gw,low,0.0,0.0,up,1.0,0.0);   /* put it in color bar     */
               low = up;                          /* top edge now bottom     */
               ++col_s;                           /* next color              */
            }
         }

         fill (-1,-1);                            /* turn off fill           */
      }
      else                                        /* b/w color bar - no cols */
         box (gw, x1, y1, 0.0, x2, y2, 0.0);      /* just draw outline       */

      if (ver == 1)                               /* vertical colorbar?      */
      {                                           /* yes!                    */
         plot_axis (gn,0,sca,0,0,sca,0);          /* scale the y axis        */
         plot_scale (gn,2,-1.0,mn,0.0,1.0,mx,0.); /* set y max and min val   */
      }
      else
      {                                           /* horizontal colorbar     */
         plot_axis (gn,sca,0,0,sca,0,0);          /* scale the x axis        */
         plot_scale (gn,2,mn,-1.0,0.0,mx,1.0,0.); /* set x max and min val   */
      }
      init_plot (gn,0,4,8);                       /* initialize c_bar window */
   }

   *(col+2) = (max_cl - 0.5) / ct->c_scale;       /* upper color cutoff      */
   *(col+3) = min_cl / ct->c_scale;               /* lower color cutoff      */
   *(col+3) = *(col+3) - *(col+3) * .00001;       /* lower for rounding      */

   max_cl = (max_cl + 1) / ct->c_scale;           /* maximum 32767 color pos */
   min_cl = min_cl /ct->c_scale;                  /* minimum 32767 color pos */

   mn = mn - mn * 0.0001;                         /* lower min for rnding    */
   switch (sca)                                   /* switch on scaling       */
   {
      case 0:                                     /* linear scaling          */
         *col = (max_cl - min_cl) / (mx - mn);    /* slope in conv val->col  */
         *(col+1) = min_cl - mn * *col;           /* inter in conv val->col  */
         break;
      case 1:                                     /* log scaling             */
         up = log10(mx);                          /* log of max value        */
         low = log10(mn);                         /* log of min value        */
         *col = (max_cl - min_cl) / (up - low);   /* slope conv log(V)->col  */
         *(col+1) = min_cl - low * *col;          /* inter conv log(V)->col  */
         break;
   }
}
