#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: centertxt.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 centertxt(ByTe_1 pn, ByTe_1 axis) 
{
   extern struct config parm;
   struct graph *gf;
   ReaL_8 center;
   ReaL_4 cen;
   ByTe_2 sx;

   if (plotnm (pn,"CENTERTXT",0) == 0)
   {
      g_error ("CENTERTXT","AXIS SCALING NOT DEFINED YET",0);
      return (1.0);
   }

   gf = parm.grf; 
 
   if (axis < 0 || axis > 11)
   {
      g_error ("CENTERTXT","UNDEFINED AXIS NUMBER",0);
      return (gf->mx_sca[0]*100.0);
   }

   sx = axis/2;

   if (gf->scale[sx])
   {
      center = (log(gf->mx_sca[sx]) + log(gf->mn_sca[sx]))/2.0;
      cen    = exp(center);
   }
   else   
      cen = (gf->mx_sca[sx] + gf->mn_sca[sx])/2;

   return (cen);
}
