#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>
#define abs(a) ((a) < 0.0) ? -(a) : (a)

static ByTe_1 rcsid[] = "$Id: add_ebars.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

/*********************************************************************
*                                                                    *
*                      PLOT_2D  SUBROUTINE                           *
*                                                                    * 
*  DESCRIPTION                                                       * 
*                                                                    * 
*  INPUT VARIABLES                                                   * 
*     opts - plot options                                            *
*     opt[0] = 0 - Guassian error bars                               *
*     opt[0] = 1 - Errors are passed in as percentage of full width  *
*     opt[0] = 2 - Errors are passed in as thh n lower values        *
*                                                                    * 
*     opt[1] = 0 - draw errors as lines centered on point            *
*     opt[1] = 1 - draw errors as box about point                    *
*                                                                    * 
*     opt[2] = 0 - draw x error bars only                            *
*     opt[2] = 1 - draw y error bars only                            *
*     opt[2] = 2 - draw z error bars only                            *
*     opt[2] = 3 - draw x and y error bars only                      *
*     opt[2] = 4 - draw x and z error bars only                      *
*     opt[2] = 5 - draw y and z error bars only                      *
*     opt[2] = 6 - draw x, y and z error bars                        *
*                                                                    * 
*     opt[3] = 0 - don't output data                                 *
*     opt[3] = 1 - output data as points                             *
*     opt[3] = 2 - output data as cahracters                         *
*                                                                    * 
*     opt[4-A] = char to use for outputting data data                *
*                                                                    * 
*     opt[B-C] = char size                                           *
*  USAGE                                                             * 
*                                                                    * 
*  NECESSARY SUBPROGRAMS                                             * 
*                                                                    * 
*  EXTERNAL VARIABLES                                                * 
*                                                                    * 
*  INTERNAL VARIABLES                                                * 
*                                                                    * 
*  BUGS                                                              * 
*                                                                    * 
*********************************************************************/

ByTe_4 add_ebars (ByTe_1 pn, ByTe_1 ax, ByTe_1 ay, ByTe_1 az, ReaL_4 *x, 
                  ReaL_4 *y, ReaL_4 *z, ReaL_4 *sx, ReaL_4 *sy, ReaL_4 *sz, 
                  ByTe_4 beg, ByTe_4 end, ByTe_1 *opts, ByTe_2 hueb, 
                  ByTe_2 hued)
{
   extern struct config parm; 
   struct window *wn; 
   struct graph  *gf; 
   register ReaL_4 *f1, *f2;
   register ByTe_1 *c1,*c2;
   register ByTe_2 i;
   ByTe_1 vp,sav_clip,sav_lstyle,axis[3],sav_bd[3];
   ByTe_1 same,sav_fill;
   ByTe_2 sav_color;
   ByTe_2 sav_fcolor;
   ReaL_4 sav_ex[3],x1,y1,y2,x2;
   ReaL_4 xs,ys;
   ByTe_4 npts;
   ReaL_4 xmax, ymax, xmin, ymin;
   ByTe_1 OutPut[20], ChSize[20];
   ByTe_2 Cs;
  
   if (plotnm (pn,"PLOT_EB",1) != 1 )
   {
       g_error ("PLOT_EB","REQUESTED PLOT HAS NOT BEEN DEFINED",0);
       return (0);
   }

   if (end < 0)
   {
       g_error ("PLOT_EB","END POINT LESS THAN ZERO",0);
       return (0);
   }

   if (beg < 0)
      beg = 0;

   npts = end - beg + 1;

   gf = parm.grf;
   vp = gf->window;
   wn = parm.win;
   sav_color = parm.l_color;
   sav_fcolor = parm.f_color;
   sav_fill = parm.fill;
   sav_lstyle = parm.lstyle;
   sav_clip = wn->clip;
   plt_color (0,hueb);
   clip (vp,1);

   c2 = gf->axis;
   for (c1 = axis; c1 < axis + 3;)
      *c1++ = *c2++; 

   for (i=0; i<3; ++i)
   {
      sav_bd[i] = gf->bad_data[i];
      sav_ex[i] = gf->exclude[i];
   }

   same = set_axis (pn,ax,ay,az);

/*** initial check for log scaling and data which is <= 0.0  ***/

   f1 = x + beg;
   f2 = f1 + npts;
   for (i=0; i<2; ++i)
   {
       if (wn->axis[i] == 1)
       {
          if (gf->bad_data[i] != 'O')
          {
             for (; f1 < f2; ++f1) 
                if (*f1 <= 0)
	           *f1 = gf->exclude[i];
          }
          else
          {
             gf->bad_data[i] = 'L';
             gf->exclude[i]  = 0.0;
          }
       }

       f1 = y + beg;
       f2 = f1 + npts;
   }

   if (gf->gwn->plot[0] < gf->gwn->plot[3])
   {
      xmin = gf->gwn->plot[0];
      xmax = gf->gwn->plot[3];
   }
   else
   {
      xmin = gf->gwn->plot[3];
      xmax = gf->gwn->plot[0];
   }

   if (gf->gwn->plot[1] < gf->gwn->plot[4])
   {
      ymin = gf->gwn->plot[1];
      ymax = gf->gwn->plot[4];
   }
   else
   {
      ymin = gf->gwn->plot[4];
      ymax = gf->gwn->plot[1];
   }
       
   switch (opts[0])
   {
      case 0:
         for (f1 = x + beg, f2 = y + beg; f1 <= x + end; ++f1,++f2) 
         {
             xs = sqrt(abs(*f1));
             ys = sqrt(abs(*f2));
             x1 = *f1 - xs;
             x2 = *f1 + xs;
             if (x1 < xmin) 
                x1 = xmin; 
             if (x2 > xmax) 
                x2 = xmax; 
             y1 = *f2 - ys;
             y2 = *f2 + ys;
             if (y1 < ymin) 
                y1 = ymin; 
             if (y2 > ymax) 
                y2 = ymax; 
             if (opts[1] == 0)
             {
                if ((opts[2] % 3) == 0)
                   line (vp, x1, *f2, 0.0, x2, *f2, 0.0);
                if ((opts[2] == 1) || (opts[2] == 3) || (opts[2] == 6))
                   line (vp, *f1, y1, 0.0, *f1, y2, 0.0);
             }
             else
                box (vp, x1, y1, 0.0, x2, y2, 0.0);
         }
      break;
   }

   plt_color (0,hued);
   if (opts[3] == 1)
      points (vp, x + beg, y + beg, z + beg, npts);  
   else
   {
      if (opts[3] == 2)
      {
         c1 = opts + 4;
         c2 = OutPut;
         while (*c1 != 0)
           *c2++ = *c1++;
         *c2 = 0; 

         ++c1;
         c2 = ChSize;
         while (*c1 != 0)
           *c2++ = *c1++;
         *c2 = 0; 
         sscanf (ChSize, "%hd", &Cs);
         if (Cs <= 0)
            Cs = 10;

         chr_size (Cs);
         for (f1 = x + beg, f2 = y + beg; f1 <= x + end; ++f1,++f2) 
            chr_dspl (vp, *f1, *f2, *f1, 0., 0., 0., 0, 0, OutPut, -1, hued);
      }
   }
     
   plt_color (sav_lstyle,sav_color);
   clip (vp,sav_clip);
   fill (sav_fill,sav_fcolor);
   for (i=0; i<3; ++i)
   {
      gf->exclude[i]  = sav_ex[i];
      gf->bad_data[i] = sav_bd[i];
   }

   if (!same)
      same = set_axis (pn,axis[0],axis[1],axis[2]);
   return (1);
}
