#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_opind.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: eye_pos.c,v 1.1 1999/11/21 08:20:18 chris.gurgiolo.b2r Stab chrisg $";

void eye_pos(ByTe_1 w, ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 rx, 
                       ReaL_4 ry, ReaL_4 rz, ReaL_4 ax, ReaL_4 ay)
{
   extern struct config parm;
   struct window *wn;
   ReaL_8 EYE[16],RX[16],RY[16],RZ[16],TP[16];
   register ReaL_4 *f1;
   register ReaL_8 *d1,*d2,*d3;
   ReaL_8 *end;
   ReaL_4 cx,cy,cz,sx,sy,sz;

/** First place view plane looking down x axis at yz plane with **/
/** up along the +z direction                                   **/

   d1 = EYE;

   *d1++ =  0;
   *d1++ = -1;
   *d1++ =  0;
   *d1++ =  0;

   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  1;
   *d1++ =  0;

   *d1++ = -1;
   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  0;

   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  1;

   if (w != parm.wn_num)
      window (w,"EYE_POS");

   wn = parm.win;
   f1 = wn->eye;
   *f1++ = x;
   *f1++ = y;
   *f1++ = z;
   *f1++ = rx;
   *f1++ = ry;
   *f1++ = rz;
   *f1++ = 1.0/tan (ax * M_PI / 180.0); 
   *f1   = 1.0/tan (ay * M_PI / 180.0); 

   cx = cosin(-rz);
   cy = cosin(-rx);
   cz = cosin(-ry);
   sx = sine(-rz);
   sy = sine(-rx);
   sz = sine(-ry);

/*** Diagonalize rotation and translation matrices  ***/

   d1 = RX;
   d2 = RY;
   d3 = RZ;

   for (d1 = RX; d1 < RX + 15;) 
   {
      *d1++ = 1.0;
      *d2++ = 1.0;
      *d3++ = 1.0;
      end = d1 + 4;
      for ( ; d1 < end; )
      {
         *d1++ = 0.0;
         *d2++ = 0.0;
         *d3++ = 0.0;
      }
   }
   *d1 = 1.0;
   *d2 = 1.0;
   *d3 = 1.0;

   RX[5] = cx;
   RX[6] = sx;
   RX[9] = -sx;
   RX[10] = cx;

   RY[0] = cy;
   RY[2] = sy;
   RY[8] = -sy;
   RY[10] = cy;

   RZ[0] = cz;
   RZ[1] = sz;
   RZ[4] = -sz;
   RZ[5] = cz;

   mult_mtx(4,4,4,RX,EYE,TP);
   mult_mtx(4,4,4,RY,TP,EYE);
   mult_mtx(4,4,4,RZ,EYE,TP);

   d1 = TP;
   f1 = wn->e_mat;

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   d1 = TP;
   *f1++  = -( *d1 * x + *(d1 + 1) * y + *(d1 + 2) * z );
   *f1++  = -( *(d1 + 4) * x + *(d1 + 5) * y + *(d1 + 6) * z );
   *f1++  = -( *(d1 + 8) * x + *(d1 + 9) * y + *(d1 + 10) * z );
   *f1++  = 1.0;

}
