;
pro uget_time_list,inst,ret_err,udf_times
;
; Changed: Harald Frey 01/18/2000  Adapted from cget_time_list.pro for udf-files
;					calculates snapshot time
;
@fuv_cmnblk
;
;
; Read Epoch, break into hr:Min:sec array string  and save in list
  for j = 0, maxrec[inst]-1 do begin
			; start time
         month=fix(strmid(put_doy(udf_times[j].btime.year, $
         	fix(udf_times[j].btime.doy)),0,2))
         day=fix(strmid(put_doy(udf_times[j].btime.year, $
         	fix(udf_times[j].btime.doy)),3,2))
         CDF_EPOCH, epoch1, udf_times[j].btime.year,month,day, $
         		   fix(udf_times[j].btime.hour), $
         		   fix(udf_times[j].btime.min), $
         		   fix(udf_times[j].btime.sec), $
         		   udf_times[j].btime.msec, /COMPUTE_EPOC

			; stop time
         month=fix(strmid(put_doy(udf_times[j].etime.year, $
         	fix(udf_times[j].etime.doy)),0,2))
         day=fix(strmid(put_doy(udf_times[j].etime.year, $
         	fix(udf_times[j].etime.doy)),3,2))
	 		;epoch
         CDF_EPOCH, epoch2, udf_times[j].etime.year,month,day, $
         		   fix(udf_times[j].etime.hour), $
         		   fix(udf_times[j].etime.min), $
         		   fix(udf_times[j].etime.sec), $
         		   udf_times[j].etime.msec, /COMPUTE_EPOC
         		   
			; snapshot time
         dstr[j,inst].epoch = (epoch2+epoch1)/2.d0
         CDF_EPOCH, dstr[j,inst].epoch, year,month,day,hour,min,sec,msec, $
         	/BREAKDOWN_EPOCH
         dstr[j,inst].hrarr = hour
         dstr[j,inst].minarr = min
         dstr[j,inst].secarr = sec

  endfor

;
end
