;********************************************************************
;*** Performs two's compliment on the submittet number. Assuming  ***
;*** that the number is described by 32 bit integer               ***
;***                                                              ***
;*** INPUT:                                                       ***
;***       integer, assumed to be 32 bit long                     ***
;*** OUTPUT:                                                      ***
;***        Two's complement of input.                            ***
;***                                                              ***
;*** Created by Andreas Isaksson 06/04/04                         ***
;*** andisa-8@student.luth.se                                     ***
;********************************************************************

FUNCTION twoscomplement, input
long_input=long64(input)
bitArray = mk_bitarray(long_input, NBITS=32 )

;if signbit is set.
if bitArray[31] eq 1 then begin

    a =  (bitarray+1) mod 2     ; flip 1's and 0's

    twos = 2D ^ INDGEN(31)

    ones=0D
    for g=0,30 do begin
        ones=ones+a[g]*twos[g]
    endfor

    neg_input = -(ones + 1)

    return, neg_input
endif else return, input

end
