;----------------------------------------------------------------------
function  put_doy,year,d_oy,compress=compress

;C****************************************************
;C
;C   author : hfrey, 12-06-99
;C            corrected February 29 string, May 8, 2004	hfrey
;C            added compress for output, March 15, 2006
;C
;C   general description:
;C   This function converts the day of year to month and day.
;C
;C   call_var.  dim. type  I/O  description
;C   MM               I    i    UT Month
;C   DD               I    i    UT Day 
;C
;C   returns                    message
;C   date                       if values ok
;C   
;C**********************************************************************

if ((size(d_oy,/type)) eq 1) then begin
	print,'Binary input not possible'
	return,-1
	endif
	
doy=d_oy
dtab=[31,28,31,30,31,30,31,31,30,31,30,31]

if (year lt 1901 or year gt 2099) then return,-1
if (doy gt 366 or doy lt 1) then return,-1

if((year mod 4) eq 0 and doy eq 60) then feb=1 else feb=0	; 29th February
if((year mod 4) eq 0 and doy gt 59) then doy=doy-1	; leap year

i=-1
repeat begin
	i=i+1
	doy=doy-dtab[i]
	endrep until (doy le 0)

mm=i+1
dd=doy+dtab[i]+feb

if keyword_set(compress) then $
  date=string(fix(mm),'(i2.2)')+string(fix(dd),'(i2.2)') else $
  date=string(fix(mm),'(i2.2)')+'-'+string(fix(dd),'(i2.2)')

return,date

end

