pro display_keo,keo_images,keo_times,n_img_rebin,ncol_rebin,n_image,max_keo_images,$
                keo_xwin,keo_ywin,disp_txt
;
; January 14, 2004, hfrey:	mistake in positioning of stripes corrected
;				last stripe small, new labels
;
@fuv_cmnblk
;
  strMonth=['Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec']

  xtickname = strarr(5,6)
  x2tickname = strarr(5,6)

; check which instrument

  case 1 of
  avail_inst[0]: ppp=0
  avail_inst[1]: ppp=1
  avail_inst[2]: ppp=2
  ELSE: ppp=0
  endcase

  case 1 of
  avail_inst[0]: instrument_name='WIC '
  avail_inst[1]: instrument_name='SI12'
  avail_inst[2]: instrument_name='SI13'
  endcase

;
  erase,bkgrnd
;
; Insert a title

  cdf_epoch, keo_times[0,ppp], year, month, start_day, start_hour, $
        start_min, start_second, /BREAKDOWN_EPOCH
;
  cdf_epoch, keo_times[n_image-1,ppp], year, month, day, end_hour, $
  	end_min, end_second, /BREAKDOWN_EPOCH
;
  strTitle = STRING( $
  FORMAT=$
		'("   ",I2.2," ",A3," ",I4.4)' $
               ,start_day,strMonth(month-1), year)
  xpos = keo_xwin / 2
  ypos = keo_ywin - 3 * !D.Y_CH_SIZE
  xyouts, xpos, ypos, 'FUV Keogram/'+instrument_name+strTitle, /DEVICE, ALIGNMENT=0.5 $
          ,CHARSIZE=1.5,COLOR= txt_clr
  strTitle = STRING( $
  FORMAT=$
		'(I2.2,":",I2.2,"-",I2.2,":",I2.2," UT")' $
               ,start_hour, start_min, end_hour,end_min)
  xpos = keo_xwin / 2
  ypos = keo_ywin - 7 * !D.Y_CH_SIZE
  xyouts, xpos, ypos, strTitle, /DEVICE, ALIGNMENT=0.5 $
          ,CHARSIZE=1.2,COLOR= txt_clr
;
;
;Longitude/MLT
  case keo_mlt_flg of
  1: str_mlt=STRING(FORMAT='(f6.2,", +/-",f6.2," Hour MLT")',(keo_fval1 mod 24.),keo_mltres/2.) 
  0: str_mlt=STRING(FORMAT='(f6.2,", +/-",f6.2," Degree Longitude")',(keo_fval1 mod 360.),keo_lonres/2.)
  2: str_mlt=STRING(FORMAT='(f6.2,", +/-",f6.2," Degree Mag. Lon.")',(keo_fval1 mod 360.),keo_lonres/2.)
  3: str_mlt=STRING(FORMAT='(f6.2,"  to ",f6.2," Degree Mag. Lat.")',keo_fval1,keo_latmax) 
  endcase
  xpos = keo_xwin / 2
  ypos = keo_ywin - 5 * !D.Y_CH_SIZE
  xyouts, xpos, ypos, str_mlt, /DEVICE, ALIGNMENT=0.5 $
          ,CHARSIZE=1.2,COLOR= txt_clr

	; add 2 minutes for imaging sequence for time axis
  cdf_epoch, keo_times[n_image-1,ppp]+2.*60.*1000., year, month, day, end_hour, $
  	end_min, end_second, /BREAKDOWN_EPOCH
;
  x2tickname[*,*]=' '
  if (n_image le 4) then begin
    ntick=2
    xtickname[*,*]=' '
  endif else begin
    ntick=4
    shour=string(start_hour,format='(i2.2)')
    smin=string(start_min,format='(i2.2)')
;    ssec=string(start_second,format='(i2.2)')
    xtickname[0,*]=shour+':'+smin		;+':'+ssec
    shour=string(end_hour,format='(i2.2)')
    smin=string(end_min,format='(i2.2)')
;    ssec=string(end_second,format='(i2.2)')
    xtickname[4,*]=shour+':'+smin		;+':'+ssec

    nstep=float(n_image)/4.0

    for i=1,3 do begin $
		; add 2 minutes for imaging sequence
     cdf_epoch, (keo_times[n_image-1,ppp]+2.*60.*1000.-keo_times[0,ppp])*i/4.+keo_times[0,ppp], $
        year, month, day, hour, minute, second,/BREAKDOWN_EPOCH & $
     shour=string(hour,format='(i2.2)') & $
     smin=string(minute,format='(i2.2)') & $
     xtickname[i,*]=shour+':'+smin & $
    endfor

  endelse
;
  m=0
  for i=0,2 do begin
   if (avail_inst(i) eq 1) then begin
     x_org=45+(m*300)
     y_org=45
     xsize=max_keo_images
     ysize=keo_ywin-180
; Place a Subtitle
     titleX =x_org + xsize/2
     titley=y_org + ysize + 10
     txt=ImageInfo(i).Inst_Id
     xyouts, titleX, titleY, txt, ALIGNMENT=.5, CHARSIZE=1.2, /DEVICE, COLOR=txt_clr
; Insert the axes
;

   xplt=indgen(n_image)
   yplt=indgen(abs(keo_latmax-keo_latmin)/5)
   ypos=y_org-1
   pos=[x_org,ypos,x_org+max_keo_images,ypos+ysize]
   xstr='Time UT'
   dummy = LABEL_DATE(DATE_FORMAT = '%H:%I')	;Simple HH:II

; Rebin and scale the keo_image
   tmp_img=calculate_scaling(keo_images[*,*,i],i)
   		; correct for image sequence with 2 minutes
   x_width=ceil((pos[2]-pos[0])*4.*60./((keo_times[n_image-1,i]+2.*60.*1000.-keo_times[0,i])/1000.))
   for ij=0,n_image-2 do begin $
       time_difference=(keo_times[ij,i]-keo_times[0,i])/(keo_times[n_image-1,i]+2.*60.*1000.-keo_times[0,i]) & $
       x_position=time_difference*(pos[2]-pos[0])+x_org & $
		; width of 4 minutes
       tv,congrid(tmp_img[ij,*],x_width,pos[3]-pos[1],/interp),x_position,y_org & $
;print,x_width,pos[3]-pos[1],x_position,y_org,x_org,time_difference,pos[2],pos[0] & $
       endfor
		; treat last stripe differently
   ij=n_image-1
       time_difference=(keo_times[ij,i]-keo_times[0,i])/(keo_times[n_image-1,i]+2.*60.*1000.-keo_times[0,i])
       x_position=time_difference*(pos[2]-pos[0])+x_org
		; width of 4 minutes
       tv,congrid(tmp_img[ij,*],x_width/2,pos[3]-pos[1],/interp),x_position,y_org
;print,x_width,pos[3]-pos[1],x_position,y_org,x_org,time_difference,pos[2],pos[0]
       

   lin_clr=txt_clr
;   PLOT,[0,1], [0,1]$
;        ,POSITION=pos $
;        ,/DEVICE,/NOERASE,/NODATA $
;        ,XTICKS=ntick,XSTYLE=1,XTICKNAME=xtickname , XTITLE=xstr $
;        ,YTICKS=abs(keo_latmax-keo_latmin)/5, YSTYLE=1, YTITLE='Latitude (deg)',$
;        YRANGE=fix([keo_latmin,keo_latmax]),YMINOR=5,$
;        COLOR=lin_clr
   if (keo_mlt_flg eq 3) then begin
     if (keo_mltmax le keo_mltmin) then tmpmax=keo_mltmax+24. else tmpmax=keo_mltmax
     PLOT,[0,1], [0,1]$
        ,POSITION=pos $
        ,/DEVICE,/NOERASE,/NODATA $
        ,XTICKS=ntick,XSTYLE=1,XTICKNAME=xtickname , XTITLE=xstr $
        , YSTYLE=1, YTITLE='MLT (hours)',$
        YRANGE=fix([keo_mltmin,tmpmax]),YMINOR=5,$
        COLOR=lin_clr 
     endif else $
   PLOT,[0,1], [0,1]$
        ,POSITION=pos $
        ,/DEVICE,/NOERASE,/NODATA $
        ,XTICKS=ntick,XSTYLE=1,XTICKNAME=xtickname , XTITLE=xstr $
        , YSTYLE=1, YTITLE='Latitude (deg)',$
        YRANGE=fix([keo_latmin,keo_latmax]),YMINOR=5,$
        COLOR=lin_clr
;
; Insert Color Bar
	 limits=[keo_xwin-80,y_org,keo_xwin-60,y_org+220]
	 if (baronof) then insertcbar,limits,i,current,KEO_XWIN=keo_xwin,KEO_YWIN=keo_ywin

   m=m+1

   endif
  endfor
;
;
end
;
; Create Keogram filename
FUNCTION keo_filename,keo_stime,keo_etime,indx,ascii_dump=ASCII_DUMP
;
@fuv_cmnblk
;
; Create a filename for Create Gif option

  cdf_epoch, keo_stime, $
        year, month, day, hour, minute,second,/BREAKDOWN_EPOCH
  cdf_epoch, keo_etime, $
        year1, month1, day1, hour1, minute1,second1,/BREAKDOWN_EPOCH

  case 1 of
  avail_inst[0]: ppp='wic_'
  avail_inst[1]: ppp='s12_'
  avail_inst[2]: ppp='s13_'
  endcase
;
; Set filename
  tmpfile=string(FORMAT='("keo_",I4,I2.2,I2.2,"_",I2.2,I2.2,"_",I2.2,I2.2)', $
        year, month, day, hour, minute,hour1,minute1)
  if (multi_inst gt 1) then tmpfile=tmpfile+'_mul' ELSE tmpfile=ppp+tmpfile
  case keo_mlt_flg of
  1: pos=string(FORMAT='("_M",I4.4)',FIX(10*(keo_mltmin+ (indx*keo_mltres)))) 
  0: pos=string(FORMAT='("_L",I4.4)',FIX(10*(keo_lonmin+ (indx*keo_lonres))))
  2: pos=string(FORMAT='("_X",I4.4)',FIX(10*(keo_lonmin+ (indx*keo_lonres))))
  3: pos=string(FORMAT='("_Y",I4.4)',FIX(10*(keo_mltmin+ (indx*keo_mltres)))) 
  endcase
  tmpfile=tmpfile+pos
  if (KEYWORD_SET(ascii_dump)) then tmpfile=tmpfile+'.dat' $
  else tmpfile=tmpfile+'.gif'
  return, tmpfile
;
end
;
;Keo Output Ascii dump
pro keo_ascii,filename,keo_images,keo_times,n_image,disp_txt
;
@fuv_cmnblk
;
  strMonth=['Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec']
;
  OPENW,11,filename
;
  cdf_epoch, keo_times[0,active_inst], $
        year, month, day, hour, minute,second,/BREAKDOWN_EPOCH
  cdf_epoch, keo_times[n_image-1,active_inst], $
        year1, month1, day1, hour1, minute1,second1,/BREAKDOWN_EPOCH
;
;Output Title
  str = STRING( FORMAT='("FUV Imager Keogram   ",I2.2," ",A3," ",I4.4)',$
  		day,strMonth(month-1), year)
  printf,11,str
;
;Longitude/MLT
 case keo_mlt_flg of
 1: str=STRING(FORMAT='(f6.2,",+/-",f6.2," Hour MLT")',(keo_fval1 mod 24.),keo_mltres/2.) 
 0: str=STRING(FORMAT='(f6.2,",+/-",f6.2," Degree Longitude")',(keo_fval1 mod 360.),keo_lonres/2.)
 2: str=STRING(FORMAT='(f6.2,",+/-",f6.2," Degree Mag. Lon.")',(keo_fval1 mod 360.),keo_lonres/2.)
 3: str=STRING(FORMAT='(f6.2,"  to ",f6.2," Degree Mag. Lat.")',keo_fval1,keo_latmax) 
 endcase
  printf,11,str
;
; Output Time Range
  str=string(FORMAT='("Start Time: ",I2.2,I2.2,"  End Time: ",I2.2,I2.2)', hour, minute,hour1,minute1)
  printf,11,str
;
;Output Array Size
  str=STRING(FORMAT='("Starting Latitude: ",f6.2)',keo_latmin)
  printf,11,str
;
;Output Array Size
  str=STRING(FORMAT='("Ending Latitude: ",f6.2)',keo_latmax)
  printf,11,str
;
;Output Array Size
  str=STRING(FORMAT='("Delta Latitude: ",f4.2)',keo_latres)
  printf,11,str
;
;Output Array Size
  str=STRING(FORMAT='("Latitude Array Size: ",i4)',abs(keo_latmax-keo_latmin)/keo_latres)
  printf,11,str
;
;Number of Images
  str=STRING(FORMAT='("No. of time intervals (Images): ",i4)',n_image)
  printf,11,str
;
; No. Instrument
  str=STRING(FORMAT='("Number of Instruments: ",i2)',multi_inst)
  printf,11,str
;
; Dayglow correction
  if (avail_inst[0] eq 1) then begin
    str=STRING(FORMAT='("Dayglow WIC:  ",f5.3,",",f5.3,",",i4,", Angles:",f6.2,",",f6.2,",",f6.2)',$
    	imageinfo[0].airglow_scale,imageinfo[0].inst_azimuth,imageinfo[0].inst_co_elev,imageinfo[0].inst_roll)
    printf,11,str
    endif
  if (avail_inst[1] eq 1) then begin
    str=STRING(FORMAT='("Dayglow SI12: ",f5.3,",",f5.3,",",i4,", Angles:",f6.2,",",f6.2,",",f6.2)',$
    	imageinfo[1].airglow_scale,imageinfo[1].inst_azimuth,imageinfo[1].inst_co_elev,imageinfo[1].inst_roll)
    printf,11,str
    endif
  if (avail_inst[2] eq 1) then begin
    str=STRING(FORMAT='("Dayglow SI13: ",f5.3,",",f5.3,",",i4,", Angles:",f6.2,",",f6.2,",",f6.2)',$
    	imageinfo[2].airglow_scale,imageinfo[2].inst_azimuth,imageinfo[2].inst_co_elev,imageinfo[2].inst_roll)
    printf,11,str
    endif
;
; Output units
;
case calibration_flag of
0: printf,11,'Calibration: Raw units'
1: printf,11,'Calibration: Corrected counts'
2: printf,11,'Calibration: Rayleigh'
endcase
;
;Output Latitude & Values
  for i=0,2 do begin
   if (avail_inst(i) eq 1) then begin
    ;Output Instrument ID
    case i of
	0:str='Instrument: '+'WIC'
	1:str='Instrument: '+'SI12'
        2:str='Instrument: '+'SI13'
    endcase
	printf,11,' '
    printf,11,str
    ; *****
    keo_images_av = fltarr(n_image)
    ; *****
    for j=0,n_image-1 do begin
     ;Output Time
     cdf_epoch, keo_times[j,active_inst], $
        year, month, day, hour, minute,second,/BREAKDOWN_EPOCH
     str=STRING(FORMAT='("TIME: ",i2.2,":",i2.2,":",i2.2)',hour,minute,second)
     printf,11,' '
     printf,11,str
     ;
     for k=0,(abs(keo_latmax-keo_latmin)/keo_latres)-1 do begin
      printf,11,FORMAT='(f10.2)',keo_images[j,k,i]
      ; *****
      keo_lat = keo_latmin + keo_latres/2. + keo_latres*k
      keo_images_av[j] = keo_images_av[j] + keo_images[j,k,i]*cos(keo_lat*!dtor)
      ; *****
     endfor
    endfor
    ; *****
    ; Print out average over latitude for each time step (image)
    ;
    ; Compute sum of weighting factors
    sum_cos_keo_lat = 0.
    for k=0,(abs(keo_latmax-keo_latmin)/keo_latres)-1 do begin
      keo_lat = keo_latmin + keo_latres/2. + keo_latres*k
      sum_cos_keo_lat = sum_cos_keo_lat + cos(keo_lat*!dtor)
    endfor
    ; Divide by sum of weighting factors
    keo_images_av = keo_images_av/sum_cos_keo_lat
    printf,11,''
    printf,11,'Averages over latitude for each time step'
    for j=0,n_image-1 do begin
      ;Output Time
      cdf_epoch, keo_times[j,active_inst], $
         year, month, day, hour, minute,second,/BREAKDOWN_EPOCH
      str=STRING(FORMAT='(i2.2,":",i2.2,":",i2.2)',hour,minute,second)
      printf,11, str+'   ', keo_images_av[j]
    endfor
    ; *****
   endif
  endfor
;
  CLOSE,11
;
end
;

pro popkeo_cell,ncol,img_no,inst,nmeas,keo_images,keo_times,nmlt,nlon
;
@fuv_cmnblk
;
  keo_cnts=REPLICATE(0.,ncol,nmeas)
; Save time tags
  keo_times[img_no,inst]=ImageInfo(inst).epoch
;
case sphere of
; ================= northern hemisphere ======================

	; geomagnetic latitude scan at fixed MLT
1: begin
  case keo_mlt_flg of
  1: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_mlt=rotate(ImageInfo(inst).mlt,5)
   tmp_mlat=rotate(ImageInfo(inst).mlat,5)
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_mlat[i,j] ge keo_latmin) then begin
      m=ROUND((tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      n=ROUND((tmp_mlat[i,j]-keo_latmin)/keo_latres)
      if ((keo_mltmin-0.5*keo_mltres lt 0.) and (24.-tmp_mlt[i,j]+keo_mltmin le 0.5*keo_mltres)) then $
          m=ROUND((24.-tmp_mlt[i,j]+keo_mltmin)/keo_mltres)
      if ((keo_mltmax lt keo_mltmin) and (tmp_mlt[i,j] lt keo_mltmax)) then $
      	m=ROUND((24.+tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      if (m ge 0 and m lt nmlt and n ge 0 and n lt ncol) then begin
;       if (n eq 20) then print,m,n,i,j,tmp_img[i,j],tmp_mlt[i,j],tmp_mlat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nmlt-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nmlt-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nmlt-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
     endif
    endfor
   endfor
;
  endcase

	; geomagnetic MLT scan at fixed magnetic latitude
  3: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_mlt=rotate(ImageInfo(inst).mlt,5)
   tmp_mlat=rotate(ImageInfo(inst).mlat,5)
;   if (keo_mltmin gt keo_mltmax) then ........
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_mlat[i,j] ge keo_latmin) then begin
      n=ROUND((tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      m=FLOOR((tmp_mlat[i,j]-keo_latmin)/keo_latres)
      if ((keo_mltmin-0.5*keo_mltres lt 0.) and (24.-tmp_mlt[i,j]+keo_mltmin le 0.5*keo_mltres)) then $
          n=ROUND((24.-tmp_mlt[i,j]+keo_mltmin)/keo_mltres)
      if ((keo_mltmax le keo_mltmin) and (tmp_mlt[i,j] le keo_mltmax)) then $
      	n=ROUND((24.+tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      if (m ge 0 and m lt nmlt and n ge 0 and n lt ncol) then begin
;       print,m,n,i,j,tmp_img[i,j],tmp_mlt[i,j],tmp_mlat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nmlt-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nmlt-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nmlt-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
     endif
    endfor
   endfor
;
  endcase

	; geographic latitude scan
  0: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_lat=rotate(ImageInfo[inst].glat,5)
   tmp_lon=rotate(ImageInfo[inst].glon,5)
;
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_lat[i,j] ge keo_latmin) then begin
      m=ROUND((tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      n=ROUND((tmp_lat[i,j]-keo_latmin)/keo_latres)
      if ((keo_lonmin-0.5*keo_lonres lt 0.) and (360.-tmp_lon[i,j]+keo_lonmin le 0.5*keo_lonres)) then $
          m=ROUND((360.-tmp_lon[i,j]+keo_lonmin)/keo_lonres)
      if ((keo_lonmax lt keo_lonmin) and (tmp_lon[i,j] lt keo_lonmax)) then $
          m=ROUND((360.+tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      if (m ge 0 and m lt nlon and n ge 0 and n lt ncol) then begin
;        print,m,n,i,j,tmp_img[i,j],tmp_lon[i,j],tmp_lat[i,j],format='(4i4,3f8.2)'
        keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
        keo_cnts[n,m]=keo_cnts[n,m]+1
        endif
     endif
    endfor
   endfor
;
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nlon-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nlon-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nlon-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
;      keo_cnts[j,i]=total(subcnt)
;      keo_images[img_no,j,inst,i]=total(subarr)
     endif
    endfor
   endfor
  endcase

	; geomagnetic latitude scan at fixed magnetic longitude
  2: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_lat=rotate(ImageInfo[inst].mlat,5)
   tmp_lon=rotate(ImageInfo[inst].mlon+360.,5) mod 360.
;
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_lat[i,j] ge keo_latmin) then begin
      m=ROUND((tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      n=ROUND((tmp_lat[i,j]-keo_latmin)/keo_latres)
      if ((keo_lonmin-0.5*keo_lonres lt 0.) and (360.-tmp_lon[i,j]+keo_lonmin le 0.5*keo_lonres)) then $
          m=ROUND((360.-tmp_lon[i,j]+keo_lonmin)/keo_lonres)
      if ((keo_lonmax lt keo_lonmin) and (tmp_lon[i,j] lt keo_lonmax)) then $
          m=ROUND((360.+tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      if (m ge 0 and m lt nlon and n ge 0 and n lt ncol) then begin
;        print,m,n,i,j,tmp_img[i,j],tmp_lon[i,j],tmp_lat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nlon-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nlon-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nlon-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
;      keo_cnts[j,i]=total(subcnt)
;      keo_images[img_no,j,inst,i]=total(subarr)
     endif
    endfor
   endfor
  endcase
  endcase
 endcase
;
; ================= southern hemisphere ======================
-1: begin

  case keo_mlt_flg of
  1: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_mlt=rotate(ImageInfo(inst).mlt,5)
   tmp_mlat=rotate(ImageInfo(inst).mlat,5)

   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_mlat[i,j] le keo_latmin) then begin
      m=ROUND((tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      n=ROUND(-(tmp_mlat[i,j]-keo_latmin)/keo_latres)
      if ((keo_mltmin-0.5*keo_mltres lt 0.) and (24.-tmp_mlt[i,j]+keo_mltmin le 0.5*keo_mltres)) then $
          m=ROUND((24.-tmp_mlt[i,j]+keo_mltmin)/keo_mltres)
      if ((keo_mltmax lt keo_mltmin) and (tmp_mlt[i,j] lt keo_mltmax)) then $
      	  m=ROUND((24.+tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      if (m ge 0 and m lt nmlt and n ge 0 and n lt ncol) then begin
;       if (n eq 20) then print,m,n,i,j,tmp_img[i,j],tmp_mlt[i,j],tmp_mlat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nmlt-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nmlt-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nmlt-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
     endif
    endfor
   endfor
;
  endcase 

	; geomagnetic MLT scan at fixed magnetic latitude
  3: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_mlt=rotate(ImageInfo(inst).mlt,5)
   tmp_mlat=rotate(ImageInfo(inst).mlat,5)

   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_mlat[i,j] le keo_latmin) then begin
      n=ROUND((tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      m=FLOOR(-(tmp_mlat[i,j]-keo_latmin)/keo_latres)
      if ((keo_mltmin-0.5*keo_mltres lt 0.) and (24.-tmp_mlt[i,j]+keo_mltmin le 0.5*keo_mltres)) then $
          n=ROUND((24.-tmp_mlt[i,j]+keo_mltmin)/keo_mltres)
      if ((keo_mltmax le keo_mltmin) and (tmp_mlt[i,j] le keo_mltmax)) then $
      	n=ROUND((24.+tmp_mlt[i,j]-keo_mltmin)/keo_mltres)
      if (m ge 0 and m lt nmlt and n ge 0 and n lt ncol) then begin
       print,m,n,i,j,tmp_img[i,j],tmp_mlt[i,j],tmp_mlat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nmlt-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nmlt-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nmlt-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
     endif
    endfor
   endfor
;
  endcase

  0: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_lat=rotate(ImageInfo[inst].glat,5)
   tmp_lon=rotate(ImageInfo[inst].glon,5)
;
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_lat[i,j] le keo_latmin) then begin
      m=ROUND((tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      n=ROUND(-(tmp_lat[i,j]-keo_latmin)/keo_latres)
      if ((keo_lonmin-0.5*keo_lonres lt 0.) and (360.-tmp_lon[i,j]+keo_lonmin le 0.5*keo_lonres)) then $
          m=ROUND((360.-tmp_lon[i,j]+keo_lonmin)/keo_lonres)
      if ((keo_lonmax lt keo_lonmin) and (tmp_lon[i,j] lt keo_lonmax)) then $
          m=ROUND((360.+tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      if (m ge 0 and m lt nlon and n ge 0 and n lt ncol) then begin
;       if (n eq 20) then print,m,n,i,j,tmp_img[i,j],tmp_lon[i,j],tmp_lat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nlon-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nlon-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nlon-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
;      keo_cnts[j,i]=total(subcnt)
;      keo_images[img_no,j,inst,i]=total(subarr)
     endif
    endfor
   endfor
  endcase

  2: begin
   tmp_img=rotate(ImageInfo(inst).image,3)
   tmp_lat=rotate(ImageInfo[inst].mlat,5)
   tmp_lon=rotate(ImageInfo[inst].mlon+360.,5) mod 360.
;
   for j=0,nypix-1 do begin
    for i=0,nxpix-1 do begin
     if (tmp_lat[i,j] le keo_latmin) then begin
      m=ROUND((tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      n=ROUND(-(tmp_lat[i,j]-keo_latmin)/keo_latres)
      if ((keo_lonmin-0.5*keo_lonres lt 0.) and (360.-tmp_lon[i,j]+keo_lonmin le 0.5*keo_lonres)) then $
          m=ROUND((360.-tmp_lon[i,j]+keo_lonmin)/keo_lonres)
      if ((keo_lonmax lt keo_lonmin) and (tmp_lon[i,j] lt keo_lonmax)) then $
          m=ROUND((360.+tmp_lon[i,j]-keo_lonmin)/keo_lonres)
      if (m ge 0 and m lt nlon and n ge 0 and n lt ncol) then begin
;       if (n eq 20) then print,m,n,i,j,tmp_img[i,j],tmp_lon[i,j],tmp_lat[i,j],format='(4i4,3f8.2)'
       keo_images[img_no,n,inst,m]=keo_images[img_no,n,inst,m]+tmp_img[i,j]
       keo_cnts[n,m]=keo_cnts[n,m]+1
      endif
     endif
    endfor
   endfor
;
;
; Fill Undersample areas using area wieghted tech.
; the way this is done can create wrong data, if the mlt-steps are too wide
; however, at the moment I do not know of a better way to do it
; therefore it will stay for now, Harald Frey, April 25, 2001
;
   subarr=fltarr(3,3)
   subcnt=intarr(3,3)
   for i=0,nlon-1 do begin
    for j=0,ncol-1 do begin
     if (keo_cnts[j,i] eq 0) then begin
      subarr=0.
      subcnt=0
      subarr=keo_images[img_no,(j-1)>0:(j+1)<(ncol-1),inst,(i-1)>0:(i+1)<(nlon-1)]
      subcnt=keo_cnts[(j-1)>0:(j+1)<(ncol-1),(i-1)>0:(i+1)<(nlon-1)]
      good_idx=where(subcnt gt 0,ngdndx)
      if (ngdndx gt 0) then keo_images[img_no,j,inst,i]=total(subarr(good_idx))/total(subcnt(good_idx))
;      keo_cnts[j,i]=total(subcnt)
;      keo_images[img_no,j,inst,i]=total(subarr)
     endif
    endfor
   endfor
  endcase
  endcase
 endcase
endcase
;
  keo_images[img_no,*,inst,*]=keo_images[img_no,*,inst,*]/(keo_cnts > 1.)
;
end
;
