;%W% %G%
;
; Insert a geomagnetic image into a window without overwriting the contents.
;

PRO xform_plot,mlt_img,xpos,ypos,xsize,ysize,inst,record,rfresh
;
@fuv_cmnblk
;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999			Applying the latest FUV modifications
; Hassan Dougani	10/28/1999			Modify structures for multiple Instrument capability
;
;------------------------------------------------------------------------------------
;
;
;    ; parameters
;txt_clr = black
;   lin_clr = txt_clr
    lbl_clr = txt_clr
    lin_sty = 0

    lat_lim = 90. - latmin
    img_xsize = float(nxpix)
    img_ysize = float(nypix)
;
    x_img_org = (xpos + ( (xsize - nxpix)/2 ))/xwin
;    if(makegif)then x_img_org=1.0
    y_img_org = (ypos + ( (ysize - nypix) ))/ywin
    if (rfresh eq 0) then begin
     mlt_img = CONGRID(mlt_img,nxpix,nypix)
     mlt_img = smooth(mlt_img, 3)
     mlt_rdy=1
    endif else mlt_img=imageinfo(inst).mlt_img
;
;    case inst of
;    0: max_value= 13000.
;    1: max_value=80.
;    2: max_value=80.
;    endcase
    if (ps_flag eq 1) then $
      TV,calculate_scaling(mlt_img,inst)>0,x_img_org,y_img_org,/NORMAL,$
      	XSIZE=float(xsize)/xwin,YSIZE=float(ysize)/ywin $
    else $
      TV,calculate_scaling(mlt_img,inst)>0,x_img_org,y_img_org,/NORMAL
;      TV,bytscl(mlt_img>0,max=max_value),x_img_org,y_img_org,/NORMAL
;hfrey
;print,'mag_img',max(mlt_img),mean(mlt_img) 
    Imageinfo(inst).mlt_img=mlt_img
    ; plot latitude lines
    npts = 500
    a = FINDGEN(npts)*(!PI*2.005/FLOAT(npts))
    cx = 10.*cos(a)
    cy = 10.*sin(a)
    !P.THICK=1

    pos = [x_img_org, y_img_org,x_img_org+(img_xsize)/xwin, y_img_org+(img_ysize)/ywin]

    PLOT,cx,cy,/NOERASE,/NODATA,COLOR=grd_color,linestyle=lin_sty, $
       position=pos, /NORMAL, $
       xstyle=1+4,ystyle=1+4, $
       xrange=[-lat_lim,lat_lim], $
       yrange=[-lat_lim,lat_lim], $
       charsize=1.2, BACKGROUND = bkgrnd
    ncirc = FLOOR(.1*lat_lim)
    FOR i=0,ncirc-1 DO BEGIN
      scl = i+1.
      IF (i EQ ncirc-1) THEN $
        oplot,scl*cx,scl*cy,COLOR=grd_color,linestyle=lin_sty $
      ELSE oplot,scl*cx,scl*cy,COLOR=grd_color,linestyle=lin_sty
    ENDFOR

    ; plot longitude lines
    lx1 = -lat_lim + 2.*lat_lim*FINDGEN(npts)/(npts-1.)
    ly1 = 0.*lx1
    ly2 = -lat_lim + 2.*lat_lim*FINDGEN(npts)/(npts-1.)
    lx2 = 0.*ly2
    lx3 = SQRT(0.5)*lx1
    ly3 = lx3
    lx4 = lx3
    ly4 = -ly3
    oplot,lx1,ly1,COLOR=grd_color,linestyle=lin_sty
    oplot,lx2,ly2,COLOR=grd_color,linestyle=lin_sty
    oplot,lx3,ly3,COLOR=grd_color,linestyle=lin_sty
    oplot,lx4,ly4,COLOR=grd_color,linestyle=lin_sty

    xh = [1,lat_lim-3,1,-lat_lim+1]
    yh = [-lat_lim+1,1,lat_lim-3,1]
    s2 = SQRT(50.)
    xl = (s2*(1.+FINDGEN(4))+2)
    yl = (s2*(1.+FINDGEN(4))-1)
    XYOUTS,xh(0),yh(0),'0',COLOR=txt_clr,CHARSIZE=1.0,/DATA
    XYOUTS,xh(1),yh(1),'6',COLOR=txt_clr,CHARSIZE=1.0,/DATA
    XYOUTS,xh(2),yh(2),'12',COLOR=txt_clr,CHARSIZE=1.0,/DATA
    XYOUTS,xh(3),yh(3),'18',COLOR=txt_clr,CHARSIZE=1.0,/DATA
  case sphere of
  1: begin
    XYOUTS,xl(0),yl(0),'80',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(1),yl(1),'70',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(2),yl(2),'60',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(3),yl(3),'50',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    endcase
  -1: begin
    XYOUTS,xl(0),yl(0),'-80',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(1),yl(1),'-70',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(2),yl(2),'-60',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    XYOUTS,xl(3),yl(3),'-50',COLOR=txt_clr,CHARSIZE=xsize/256.,/DATA
    endcase
    endcase

  	; mark positions
   posi_check=where(position_long ne 0. and position_lati ne 0.,count)
   if (count gt 0) then begin
   plots,pos[0]+position_xr/xwin,pos[1]+position_yr/ywin,psym=4,/normal,COLOR=txt_clr
   endif

END


PRO insertMagImg, Limits, inst,record,rfresh
;
@fuv_cmnblk
;
 ;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999			Applying the latest FUV modifications
; Hassan Dougani	10/28/1999			Modify structures for multiple Instrument capability
;
;------------------------------------------------------------------------------------
;
   ; Determine our drawing region location and size
    llx = Limits(0)    ; Lower left x
    lly = Limits(1)    ; Lower left y
    urx = Limits(2)    ; Upper right x
    ury = Limits(3)    ; Upper right y

    xsize = urx-llx+1
    ysize = ury-lly+1
    xpos = llx
    ypos = lly

    ;Insert a title
    titleX =  float(xpos + xsize/2)/xwin
    titleY = float(ypos -16)/ywin
    if (multi_inst eq 1) then $
     xyouts, titleX, titleY, 'Apex MLat/MLT', ALIGNMENT=.5, /NORMAL, COLOR=txt_clr $
    else begin
     titley=float(ypos + ysize + 5)/ywin
     txt=ImageInfo(inst).Inst_Id
     xyouts, titleX, titleY, txt, ALIGNMENT=.5, CHARSIZE=1.2, /NORMAL, COLOR=txt_clr
    endelse


    ; Transform image to magnetic local time

; ----- Original IDL xform code ------------
;    xform, ImageInfo.image, ImageInfo.mlat, ImageInfo.mlt $
;         , ImageInfo.latmin, ImageInfo.hgt, mlt_img
; ------------------------------------------

; ----- Original IDL code ported to C (faster) ----------
;    nCell = FIX(4.*(90. - ImageInfo.latmin))
;    mlt_img = FLTARR(nCell+1,nCell+1)

;    lResult=call_external('uviidl.so','xform', $
;              ImageInfo.image, ImageInfo.mlat, ImageInfo.mlt, $
;              ImageInfo.latmin, ImageInfo.hgt, mlt_img)
; -------------------------------------------------------
; ------- New IDL code 11/24/98 -------------------------
    if (rfresh eq 0) then begin
     image=rotate(ImageInfo(inst).image,6)

;     if (imageinfo[inst].o_gci[2] lt 0.) then sphere=-1
     geo2mlt, image, ImageInfo(inst).mlat, ImageInfo(inst).mlt, $
             mlt_img, latmin, ImageInfo(inst).hgt, sphere
    endif
; -------------------------------------------------------
; ----- New IDL code ported to C (faster) ----------
;    nCell = FIX(4.*(90. - ImageInfo.latmin))
;    mlt_img = FLTARR(nCell+1,nCell+1)

;    lResult=call_external('uviidl.so','geo2mlt', $
;              ImageInfo.image, ImageInfo.mlat, ImageInfo.mlt, $
;              ImageInfo.latmin, mlt_img)
; -------------------------------------------------------
    ; Plot it
    xform_plot,mlt_img,xpos,ypos, xsize,ysize, inst, record,rfresh
END

