;%W% %G%
;
; Insert a geodetic image into a window without overwriting the contents.
;
PRO insertGeoImg, Limits, inst,record
;
;
@fuv_cmnblk
;
    ; Determine our drawing region location and size
    llx = Limits(0)    ; Lower left x
    lly = Limits(1)    ; Lower left y
    urx = Limits(2)    ; Upper right x
    ury = Limits(3)    ; Upper right y
    xsize = urx-llx+1
    ysize = ury-lly+1
    xpos = llx
    ypos = lly

    ;Insert a title
    titleX = ( xpos + xsize/2)/xwin
    titleY = (ypos-16)/ywin
    txt='Geographic Lat/Lon'
    if (gci_flag eq 1 ) then txt=txt+' (GCI)'
    if (multi_inst eq 1) then $
     xyouts, titleX, titleY,txt , ALIGNMENT=.5, /NORMAL, color= txt_clr $
    else begin
     titley=(ypos + ysize + 5)/ywin
     txt=ImageInfo(inst).Inst_Id
    if (gci_flag eq 1 ) then txt=txt+' (GCI)'
     xyouts, titleX, titleY, txt, ALIGNMENT=.5, CHARSIZE=1.2,/NORMAL, COLOR=txt_clr
    endelse

    ;Plot the image
    gmap, inst, record,xpos, ypos, xsize, ysize
END



