;%W% %G%
;
; Insert a color bar into a window without overwriting the contents.
;
PRO insertCbar, Limits, inst, record,keo_xwin=KEO_XWIN,keo_ywin=KEO_YWIN,$
	character=character
;
; 08-Sep-2006  hfrey   introduced keyword character for character size
;
@fuv_cmnblk
;
    ; Determine our drawing region location and size
    llx = Limits(0)    ; Lower left x
    lly = Limits(1)    ; Lower left y
    urx = Limits(2)    ; Upper right x
    ury = Limits(3)    ; Upper right y
    ;Create a color bar
    if (scale_type eq 0) then begin
     minval = log_scl_min
     maxval = log_scl_max > (minval+1)
    endif else begin
     minval=lin_scl_min
     maxval=lin_scl_max > (minval+1)
    endelse
    if KEYWORD_SET(KEO_XWIN) then begin
     xwin1=keo_xwin
     ywin1=keo_ywin
    endif else begin
     xwin1=xwin
     ywin1=ywin
    endelse
    cbdepth = 220.*nypix/256.
    cbwidth = 20.*nxpix/256.
    tmp = lindgen(cbdepth)
    bar = congrid(rotate(tmp,1),cbwidth,cbdepth)
    bar = bytscl(bar,TOP=top_color)

    ; Draw the color bar centered in the drawing region
    imgsize = size(bar)
    imgsizeX = imgsize(1)
    imgsizeY = imgsize(2)
;   xpos = llx + ((urx - llx) - imgsizeX) / 2
    xpos = llx + cbwidth - 5
    ypos = lly + ((ury - lly) - imgsizeY) / 2
    if (ps_flag eq 1) then $
     tv, bar, float(xpos)/xwin1, float(ypos)/ywin1,/NORMAL,$
         XSIZE=float(imgsizeX)/xwin1,YSIZE=float(imgsizeY)/ywin1 $
    else  tv, bar, float(xpos)/xwin1, float(ypos)/ywin1,/NORMAL

    ; Frame the color bar
    pos=[float(xpos)/xwin1, float(ypos)/ywin1, float(xpos+cbwidth-1)/xwin1, float(ypos+cbdepth-1)/ywin1]
    if (scale_type eq 0) then begin
     PLOT,[0,1],[minval,maxval] $
        ,POSITION=pos $
        ,/NORMAL,/NOERASE,/NODATA $
        ,XTICKS=1,XSTYLE=1,XTICKNAME=[' ',' '] $
        ,YTICKS=1, YTICKNAME=[' ',' '], YSTYLE=1, /YLOG, COLOR=lin_clr
    endif else begin
     PLOT,[0,1],[minval,maxval] $
        ,POSITION=pos $
        ,/NORMAL,/NOERASE,/NODATA $
        ,XTICKS=1,XSTYLE=1,XTICKNAME=[' ',' '] $
        ,YTICKS=1, YTICKNAME=[' ',' '], YSTYLE=1, COLOR=lin_clr
	endelse
    case calibration_flag of
        2: strTitle = 'Rayleighs'
        1: strTitle = 'Corrected counts'
        0: strTitle = 'Raw'		;'photon cm!U-2!Ns!U-1!N'
    endcase

    if keyword_set(character) then char_size=character else char_size=0.4+0.4*nxpix/256.

    AXIS, YAXIS=1, YRANGE=[minval,maxval],CHARSIZE=char_size, $
        /NORMAL , YSTYLE=1, YTICKLEN=-0.2, COLOR=txt_clr
 ;
    xyouts, float(xpos-8)/xwin1, float(ypos+40)/ywin1, strTitle, /NORMAL, $
            ORIENTATION=90, CHARSIZE=char_size+0.2, COLOR=txt_clr

END
