pro ic_gci_2_gse, gci, gse,  sra, sdec

; Program ic_gci_2_gse.pro
; Author  Thomas Immel
; Date    2-10-03, that's February.
; 
; Program to calculate gse coords of vectors or array of vectors for
; pixels in images. Initially and maybe never to be saved in
; imageinfo. Could be calculated in a second call to fuv_ptg.pro and
; passed back on request. This is aimed at use in the background program.
;
;  provided ; gci ra and dec of pixel (fltarr(2) or fltarr(2,n)
;           ; sra, sdec. RA and Dec of Sun (fltarr(2))
;           ; ra and dec should be provided in units of degrees.
;  returned ; gse x,y,z vector fltarr(3) or fltarr(3,n)
;
;
;
;
;
;http://www-ssc.igpp.ucla.edu/personnel/russell/papers/gct1.html/
;
;
;
;      The most common required transformation into the GSE system of
;      those discussed so far is from the GEI system. The direction of
;      the ecliptic pole (0, -0.398, 0.917) is constant in the GEI
;      system. The X-axis, the direction of the Sun, may be obtained
;      in GEI from the equations in Appendix 2. If this direction is
;      (S 1, S 2 , S < sub.3. > ), then the Y-axis in GEI (Y 1 , Y 2 ,
;      Y 3> ) is = 
;      (0, -0.398, 0.917) X (S 1, S 2, S 3 )
;and the transformation is
;    (S 1   S 2    S 3  ) (Vx)        = (Vx)
;    (Y 1  Y 2     Y 3  ) (Vy)        = (Vy)
;    (0   -0.398   0.917) (Vz)  <GEI> = (Vz) <GSE>


ra = reform(gci(0, *))  ;expect ra in degrees.
helper = size(ra)   ;necessary size determination
r_ra = ra/!radeg    ;covert ra to radians
r_dec   = reform(gci(1, *)/!radeg)

xgei = cos(r_ra)*cos(r_dec)
ygei = sin(r_ra)*cos(r_dec)
zgei = sin(r_dec); (1-xgei^2-ygei^2)^0.5  ;=sin(r_dec)
if helper(0) gt 1 then begin
  gei_arr = fltarr(3, helper(2))
  gei_arr(0, *) = xgei &  gei_arr(1, *) = ygei
  gei_arr(2, *) = zgei
endif

r_sra = sra/!radeg    ;output from sun3 is not in hours, but degrees already
r_sdec = sdec/!radeg

sxgei = cos(r_sra)*cos(r_sdec)
sygei = sin(r_sra)*cos(r_sdec)
szgei = sin(r_sdec) ; (1-sxgei^2 - sygei^2)^0.5    ; =sin(r_sdec)


trans_arr = fltarr(3, 3)
trans_arr(*, 0) = [sxgei, sygei, szgei]
trans_arr(*, 1) = crossp([0, -0.398, 0.917], reform(trans_arr(*, 0)))
trans_arr(*, 2) = [0,  -0.398, 0.917]

if helper(0) gt 1 then begin
  print, 'make transformation matrix a 3d array'
  trans_arr_3d = fltarr(3, 3, helper(2))
  for i = 0, helper(2)-1 do trans_arr_3d(*, *, i) = trans_arr
  v_gse = trans_arr_3d # gci_arr
  

endif else begin

v_gse = trans_arr##[xgei, ygei, zgei]
gse = v_gse
endelse

stop
end


