;--------------------------------------------------------------

PRO con_plot, clon, clat,cont_color=cont_color

@fuv_cmnblk

tmp1 = [0000, 0521, 2002, 4078, 4109, $
4118, 4129, 4181, 4198, 4207, 4216, 4219, 4233, $
4242, 4300, 4339, 4349, 4360, 4371, 4378, 4384, $
4388, 4398, 4405, 4412, 4416, 4426, 4438, 4450, $
4458, 4465, 4475, 4482, 4534, 4556, 4565, 4680, $
4692, 4700, 4730, 4752, 4815, 4840, 4848, 4855, $
4873, 4899, 4908, 4914, 4923, 4930, 4948, 5031, $
5055, 5061, 5065, 5070, 5074, 5081, 5089, 5098, $
5108, 5120, 5134, 5155, 5196, 5201, 5270, 5277, $
5283, 5291, 5305, 5312, 5319, 5326, 5514, 5521, $
5532, 5538, 5566, 5576, 5585, 5591, 5601, 5606]

tmp2 = [ 5626, 5642, 5659, 5681, 5698, 5778, 5822, 5834, $
5843, 5852, 5860, 5866, 5872, 5925, 5931, 5938, $
5944, 5953, 5970, 5982, 6001, 6042, 6049, 6089, $
6095, 6102, 6109, 6116, 6126, 6133, 6141, 6148, $
6154, 6244, 6275, 6286, 6303, 6321, 6338, 6354, $
6368, 6375, 6394, 6401, 6408, 6418, 6424, 6718, $
6727, 6735, 6759, 6813, 6860, 6865, 6933, 6977]

tmp3 = [ 6984, 7018, 7023, 7029, 7040, 7059, 7065, 7073, $
7085, 7095, 7168, 7248, 7268, 7276, 7293, 7298, $
7304, 7310, 7433, 7480, 7494, 7503, 7521, 7550, $
7594, 7620, 7632, 7641, 7648, 7653, 7658, 7667, $
7674, 7680, 7685, 7701, 7707, 7717, 7726, 7736, $
7745, 7752, 7761, 7770 ]

con_slist = [tmp1, tmp2, tmp3]

tmp1 = [ 0520, 1998, 4075, 4108, 4116, $
4127, 4179, 4196, 4205, 4214, 4218, 4231, 4240, $
4298, 4337, 4348, 4359, 4369, 4376, 4383, 4387, $
4391, 4401, 4408, 4415, 4424, 4436, 4449, 4457, $
4464, 4474, 4480, 4532, 4555, 4564, 4677, 4690, $
4699, 4729, 4751, 4814, 4839, 4847, 4854, 4872, $
4877, 4907, 4913, 4922, 4929, 4947, 4979, 5050, $
5060, 5064, 5069, 5073, 5080, 5088, 5097, 5106, $
5119, 5133, 5154, 5192, 5200, 5269, 5275, 5282, $
5290, 5304, 5308, 5318, 5325, 5513, 5520, 5530, $
5536, 5565, 5575, 5584, 5590, 5600, 5605, 5625 ]

tmp2 = [ 5641, 5658, 5680, 5697, 5777, 5821, 5826, 5841, $
5847, 5859, 5865, 5871, 5919, 5930, 5937, 5942, $
5952, 5969, 5980, 6000, 6041, 6048, 6088, 6094, $
6098, 6107, 6114, 6125, 6132, 6139, 6147, 6153, $
6243, 6274, 6285, 6302, 6320, 6337, 6353, 6367, $
6374, 6380, 6400, 6406, 6417, 6423, 6717, 6725, $
6734, 6757, 6812, 6859, 6864, 6932, 6975, 6983 ]

tmp3 = [ 7017, 7021, 7027, 7038, 7058, 7064, 7071, 7083, $
7090, 7167, 7247, 7267, 7274, 7288, 7296, 7303, $
7309, 7432, 7479, 7493, 7502, 7519, 7549, 7593, $
7615, 7631, 7640, 7644, 7652, 7657, 7665, 7672, $
7678, 7684, 7700, 7705, 7715, 7725, 7735, 7740, $
7751, 7757, 7769, 7784 ]

con_elist = [ tmp1, tmp2, tmp3 ]

n_cons = (size(con_slist))(1)

FOR pos = 0, n_cons - 1 DO $
   OPLOT,clon(con_slist(pos):con_elist(pos)), $
	clat(con_slist(pos):con_elist(pos)), MIN_VALUE=-100, $
        COLOR=con_color

END

;
;

PRO grid_plot,glat,glon,xpimg,ypimg,sslat
@fuv_cmnblk

latdel=15.
londel=45.
lon=rotate(glon,5)
lat=rotate(glat,5)
;lon=glon
t_lat = CONGRID(lat, xpimg, ypimg, /INTERP)
t_lon = CONGRID(lon, xpimg, ypimg)

nlat = 51
; find the nearest whole number of latdels to the sslat
midl = FIX( sslat - ( sslat MOD latdel ) )
; generate nlat increments centered about 0 of size latdel
incr = latdel*( INDGEN(nlat) - (nlat - 1)/2 )
temp = midl + incr
indx = WHERE(temp GT -90 AND temp LT 90, count)
IF (count GT 0) THEN lat_lvls = temp(indx)

CONTOUR, t_lat, LEVELS=lat_lvls,/OVERPLOT,COLOR=grd_color

nlon = londel* INDGEN(FIX( 360. / londel ))
;
CONTOUR, t_lon, LEVELS=nlon,/OVERPLOT,COLOR=grd_color
;
END
;
;--------------
; %W% %G%
;
FUNCTION vec_norm,v
    RETURN, SQRT(DOUBLE(v(0)*v(0) + v(1)*v(1) + v(2)*v(2)))
END
FUNCTION unit_vec,v
    RETURN, v/vec_norm(v)
END

;--------------------------------------------------------------

PRO rot_con,xcon,ycon,xpimg,ypimg,roti_val
;
@fuv_cmnblk
;
aspect_ratio=nypix/nxpix
xcon = aspect_ratio*((xpimg) - xcon)
;ycon = ypimg - ycon				; for system 2 don't do this

tempx = xcon
tempy = ycon
CASE roti_val OF
  0: ;do nothing
  1: BEGIN
       xcon = nypix - tempy
       ycon = tempx
     END
  2: BEGIN
       xcon = nypix - tempx
       ycon = nypix - tempy
     END
  3: BEGIN
       xcon = tempy
       ycon = nypix - tempx
     END
ENDCASE

END


;--------------------------------------------------------------

PRO gmap,inst,record,xpos,ypos,xsize,ysize
;
@fuv_cmnblk
forward_function calculate_scaling
;
   ; Constants
    earth_radius = 6378.136D
    pi2 = 0.5*!DPI

    ; produce rotation matrix: gci -> geo coordinates
    ic_gci_to_geo,ImageInfo(inst).time,rotm
    irotm = INVERT(TRANSPOSE(rotm))

    xax = unit_vec(ImageInfo(inst).l0)
    yax = unit_vec(CROSSP(ImageInfo(inst).a_gci3,ImageInfo(inst).l0))
    zax = unit_vec(CROSSP(xax,yax))

    	; now we need to rotate for the TDI angle
    	; first rotate vector around y so it lies in the y-z plane with x=0
    d1=sqrt(xax[2]^2+xax[0]^2)
    w1=acos(xax[2]/d1)*180.d/!dpi*((xax[0] gt 0.)*2.d0-1.d0)
        ; rotate -w1 around y-axis
    y1_matrix=[[ cos(-w1*!dpi/180.d), 0.d0, sin(-w1*!dpi/180.d)],$
               [           0.d0     , 1.d0,          0.d0      ],$
               [-sin(-w1*!dpi/180.d), 0.d0, cos(-w1*!dpi/180.d)]]
    xzw=y1_matrix##xax
    	; now rotate vector around x so it coincides with the z-axis
	w2=acos(xzw[2])*180.d/!dpi*((xzw[1] gt 0.)*2.d0-1.d0)
	; rotate w2 around x-axis
    x1_matrix=[[ 1.d0,       0.d0        ,           0.d0     ],$
               [ 0.d0, cos(w2*!dpi/180.d), -sin(w2*!dpi/180.d)],$
               [ 0.d0, sin(w2*!dpi/180.d),  cos(w2*!dpi/180.d)]]
    	; now rotate around z with the TDI angle
    w3=-imageinfo[inst].inst_roll
    z1_matrix=[[ cos(w3*!dpi/180.d), -sin(w3*!dpi/180.d), 0.d0],$
               [ sin(w3*!dpi/180.d),  cos(w3*!dpi/180.d), 0.d0],$
               [         0.d0      ,          0.d0      , 1.d0]]
    first_matrix=z1_matrix##x1_matrix##y1_matrix
    	; now go back from z-axis to x-z plane
    x2_matrix=[[ 1.d0,        0.d0        ,            0.d0     ],$
               [ 0.d0, cos(-w2*!dpi/180.d), -sin(-w2*!dpi/180.d)],$
               [ 0.d0, sin(-w2*!dpi/180.d),  cos(-w2*!dpi/180.d)]]
    	; and finally back around y
    y2_matrix=[[ cos(w1*!dpi/180.d), 0.d0, sin(w1*!dpi/180.d)],$
               [           0.d0    , 1.d0,          0.d0     ],$
               [-sin(w1*!dpi/180.d), 0.d0, cos(w1*!dpi/180.d)]]
       	; now the big moment that xax should not have changed, but yax
    final_matrix=y2_matrix##x2_matrix##first_matrix
    check_result_xax=final_matrix##xax
    if (total((xax-check_result_xax)^2) gt 1.e-15) then begin
    	result=dialog_message('Error! Consult Harald Frey!')
    	endif
    yax=reform(final_matrix##yax)
    zax=reform(final_matrix##zax)

    roti_val=0
    latdel=15
    londel=45
    xpwin = xsize
    ypwin = ysize
    xpimg = xpwin
    ypimg = ypwin

    x_img_org = (xpos + ( (xsize - xpimg)/2 ))/xwin
    y_img_org = (ypos + 1.0*( (ysize - ypimg) ))/ywin
;
;Make the image square
    image = ImageInfo(inst).image
    tmp_img=rotate(calculate_scaling(image,inst),3)	

    if (ps_flag eq 1) then $
     TV,tmp_img>0,x_img_org,y_img_org,/NORMAL,$
        XSIZE=float(xsize)/xwin,YSIZE=float(ysize)/ywin $
    else  TV,tmp_img>0,x_img_org,y_img_org,/NORMAL

; Draw noon Meridian/Continent/Lat/Lon
    if (drawcont eq 1) then begin
    ; establish plotwindow for image
    xrange = [0,xpimg-1]
    yrange = [0,ypimg-1]

    pos = [x_img_org, y_img_org,x_img_org+(xpimg-1)/xwin, y_img_org+(ypimg-1)/ywin]
    PLOT,[0,0],[0.0],/NODATA,XRANGE=xrange,YRANGE=yrange, $
      POSITION=pos,/NOERASE,/NORMAL,XSTYLE=13,YSTYLE=13, BACKGROUND=bkgrnd

    ; draw noon meridian
    cdf_epoch, ImageInfo(inst).epoch, year, month, day, $
               hour, minute, second, /BREAKDOWN_EPOCH

    doy = get_doy(day, month, year)
    if (year lt 1950 or year gt 2050 or day eq 0 or day gt 31 or month eq 0 or month gt 12) then begin
              stat_txt= 'Invalid Date..'
              widget_control, status_id, set_value=stat_txt
	          return
    endif
    subsol, year, doy, time=[hour, minute, second], sslat, sslon
    nmlat = -90.0 + FINDGEN(181)
    nmlon = sslon * REPLICATE(1.0, 181)
    lltopix_arr, ImageInfo(inst),nmlat, nmlon, emis_hgt, $
                 xax, yax, zax, ImageInfo(inst).o_gci, ImageInfo(inst).time, $
                 ydev, xdev, adev, irotm,xpimg,ypimg

    adx = WHERE(adev GT 0.5 * !PI, npts)
    if (npts GT 0) then begin
        xln = xdev(adx)
        yln = ydev(adx)
        rot_con,xln,yln,xpimg,ypimg,roti_val
        OPLOT, xln, yln, COLOR= con_color
    endif
;
; Draw continent/Lat/Lon
;
     lltopix_arr,ImageInfo(inst),cilat,cilon, $
          emis_hgt,xax,yax,zax, $
         ImageInfo(inst).o_gci,ImageInfo(inst).time,$
         ycon,xcon,acon,irotm,xpimg,ypimg
;
     rot_con,xcon,ycon,xpimg,ypimg,roti_val
     invalid = WHERE( acon LT (!DPI * 0.5D) )
     xcon( invalid ) = -101
     ycon( invalid ) = -101
;
	 con_plot, xcon, ycon
   dummy=where(xcon ge 0. and xcon le 255. and ycon ge 0. and ycon le 255.,count)
;
;  Draw Lat/Lon Using Contour Option
	 if (test_latlon eq 0 and count gt 0) then $
		grid_plot,imageinfo(inst).glat,imageinfo(inst).glon,xpimg,ypimg,sslat
	endif
;
south_pole=0
if (south_pole) then begin
	; plot South Pole
    nmlat = [63.7,65.8,67.8,69.2,69.5,68.5,66.5,64.3,62.4,61.3,61.2,62.1,63.7]
    nmlon = [300.3,302.4,301.9,298.6,293.3,288.2,285.3,285.0,286.6,289.6,293.3,297.1,300.3]
    lltopix_arr, ImageInfo(inst),nmlat, nmlon, emis_hgt, $
                 xax, yax, zax, ImageInfo(inst).o_gci, ImageInfo(inst).time, $
                 ydev, xdev, adev, irotm,xpimg,ypimg
    adx = WHERE(adev GT 0.5 * !PI, npts)
    if (npts GT 0) then begin
        xln = xdev(adx)
        yln = ydev(adx)
        rot_con,xln,yln,xpimg,ypimg,roti_val
        OPLOT, xln, yln, COLOR= 255
	endif
    endif
;

fast=0
if (fast) then begin
  if (fast_flag eq 0) then read,'Do you want FAST orbit? y/n, full, read_file: ',fast_answer
  case inst of
    0: inst_name='wic'
    1: inst_name='s12'
    2: inst_name='s13'
    endcase
  t1=string(year,format='(i4)')+'-'+string(month,format='(i2.2)')+'-'+$
  	string(day,format='(i2.2)')+'/'+string(hour,format='(i2.2)')+$
       ':'+string(minute,format='(i2.2)')+':'+string(second,format='(i2.2)')
  t2=time_double(t1)
  fast_dat={time:0d0,time_string:' ',flat:0.,flon:0.,ilat:0.,ilon:0.,mlt:0.,$
     xarr:0.,yarr:0.,footpoint:0.}
	; FAST calculations
  if (strlowcase(fast_answer) eq 'y') then begin
    t3=t2+findgen(241)-60.d0		; time 60 seconds before to 3 min after
    fast_data=replicate(fast_dat,n_elements(t3))
    get_fa_orbit,t3,/all,/time_array
    get_data,'FLAT',data=flat
    fast_data.time=flat.x
    fast_data.time_string=time_string(flat.x)
    fast_data.flat=flat.y
    get_data,'FLNG',data=flng
    fast_data.flon=(flng.y+360.) mod 360.
    get_data,'ILAT',data=ilat
    fast_data.ilat=ilat.y
    get_data,'ILNG',data=ilng
    fast_data.ilon=ilng.y
    get_data,'MLT',data=mlt
    fast_data.mlt=mlt.y
    input_data=fltarr(2,n_elements(fast_data.flat))
    input_data[0,*]=fast_data.flat
    input_data[1,*]=(fast_data.flon+360.) mod 360.
    lltopix_arr,ImageInfo(inst),input_data[0,*],input_data[1,*], $
         emis_hgt,xax,yax,zax,ImageInfo(inst).o_gci,ImageInfo(inst).time,$
         yarr,xarr,aarr,irotm,xpimg,ypimg
    fast_data.xarr=xpimg-reform(xarr)
    fast_data.yarr=reform(yarr)
    oplot,xpimg-xarr,yarr 
    plots,xpimg-xarr[60],yarr[60],psym=4
    fast_data.footpoint=(rotate(image,3))[fast_data.xarr,fast_data.yarr]
    fast_flag=0
    endif	; yes
;
  if (strlowcase(fast_answer) eq 'full') then begin
    t3=t2+findgen(241)*10.-600.d0	; time 600 seconds before to 30 min after
    fast_data=replicate(fast_dat,n_elements(t3))
    get_fa_orbit,t3,/all,/time_array
    get_data,'FLAT',data=flat
    fast_data.time=flat.x
    fast_data.time_string=time_string(flat.x)
    fast_data.flat=flat.y
    get_data,'FLNG',data=flng
    fast_data.flon=flng.y
    get_data,'ILAT',data=ilat
    fast_data.ilat=ilat.y
    get_data,'ILNG',data=ilng
    fast_data.ilon=ilng.y
    get_data,'MLT',data=mlt
    fast_data.mlt=mlt.y
    input_data=fltarr(2,n_elements(fast_data.flat))
    input_data[0,*]=fast_data.flat
    input_data[1,*]=fast_data.flon
    lltopix_arr,ImageInfo(inst),input_data[0,*],input_data[1,*], $
         emis_hgt,xax,yax,zax,ImageInfo(inst).o_gci,ImageInfo(inst).time,$
         yarr,xarr,aarr,irotm,xpimg,ypimg
    fast_data.xarr=xpimg-reform(xarr)
    fast_data.yarr=reform(yarr)
    oplot,xpimg-xarr,yarr 
    plots,xpimg-xarr[60],yarr[60],psym=4
    fast_data.footpoint=(rotate(image,3))[fast_data.xarr,fast_data.yarr]
    fast_flag=0
    endif		; full

;	reading file
  if (strlowcase(fast_answer) eq 'read_file') then begin
     read,'Input file name: ',answer
     fuv_read_fast_file,answer,conjugate_data
     lltopix_arr,ImageInfo(inst),conjugate_data.input[1],conjugate_data.input[2], $
          emis_hgt,xax,yax,zax, $
         ImageInfo(inst).o_gci,ImageInfo(inst).time,$
         yarr,xarr,aarr,irotm,xpimg,ypimg
     oplot,xpimg-xarr,yarr
;     plots,xpimg-xarr[60],yarr[60],psym=4
     fast_name='fast_file_'+inst_name+'_'+string(year,format='(i4)')+'_'+$
	string(doy,format='(i3.3)')+'_'+$
	string(hour,format='(i2.2)')+string(minute,format='(i2.2)')+$
	string(second,format='(i2.2)')+'.sav'
;     imageinfo_simple=imageinfo[inst]
;     footpoint=(rotate(image,3))[xpimg-xarr,yarr]
;     save,imageinfo_simple,fast_data,input_data,emis_hgt,xax,yax,zax, $
;                  yarr,xarr,aarr,irotm,xpimg,ypimg,sslat,footpoint,$
;                  x_img_org,y_img_org,xln, yln,xcon, ycon,filename=fast_name,/xdr
     fast_flag=0
     endif	; file

  endif		; fast

	;stars
if (star_flag eq 1) then begin
  case inst of
   0: begin
      if (calibration_flag eq 2) then bright=4000 else bright=3000
      roundlim=[-1.,1.]
      endcase
   1: begin
      if (calibration_flag eq 2) then bright=2000 else bright=50
      roundlim=[-1.5,1.5]
      endcase
   2: begin
      if (calibration_flag eq 2) then bright=4000 else bright=60
      roundlim=[-1.,1.]
      endcase
   endcase
  find,rotate(image,3),x,y,flux,sharp,roundness,bright,5,roundlim,[0.1,1.0],print=0,/silent
  print,'     STAR       X       Y     FLUX     SHARP    ROUND'
  if (n_elements(x) ne 0) then for i=0,n_elements(x)-1 do print,$
	format='(4x,i5,2f8.2,f9.1,2f9.2)', $
	              i+1, x[i], y[i], flux[i], sharp[i], roundness[i]
  endif

	; mark positions
posi_check=where(position_long ne 0. and position_lati ne 0.,count)
if (count gt 0) then begin
    position_lati=position_lati[posi_check]
    position_long=position_long[posi_check]
    lltopix_arr,ImageInfo(inst),position_lati,$	; Latitude
    	position_long, $
         emis_hgt,xax,yax,zax,ImageInfo(inst).o_gci,ImageInfo(inst).time,$
         yarr,xarr,aarr,irotm,xpimg,ypimg
    print,'  '
    print,'Position:'
    print,' Longitude  Latitude   X-pixel   y-pixel  Mag-Lon    Mag-Lat    MLT'
    plots,xpimg-xarr,yarr,psym=4,COLOR=txt_clr
    star_flag=0
    geo_to_apex,position_lati,position_long,mlat,mlon,apxfile
    read_epoch, ImageInfo(inst).epoch, year, month, day, hr, min, sec $
              , ms, ut, doy
    get_lt,ut,year,month,day,position_lati,position_long,apxfile,glt,fast_mlt
    angle=fast_mlt*360./24.+270.
    if (sphere eq 1) then dist=(90.-mlat)*(nxpix-1)/2./(90.-latmin) else $
      dist=-(-90.-mlat)*(nxpix-1)/2./(90.-latmin)
    position_xr=(nxpix-1)/2.+dist*cos(angle*!dtor)
    position_yr=(nypix-1)/2.+dist*sin(angle*!dtor)
    for i=0,count-1 do $
    print,position_long[i],position_lati[i],xpimg-xarr[i],yarr[i],$
       mlon[i],mlat[i],fast_mlt[i],format='(6f10.2,f8.2)'
   endif


if (!d.name ne 'PS') then begin
  if (star_flag eq 1) then begin
     dummy=where(new_starsx lt 0. or new_starsx gt 255. or $
                 new_starsy lt 0. or new_starsy gt 255.,count)
     pp_starsx=new_starsx
     if (count gt 0) then pp_starsx[dummy]=-1000.
     plots,pp_starsx,new_starsy,psym=2
     endif
  endif

END
