;@(#)getdir.pro	1.2 08/25/99
; This procedure picks the directory name (such as 1999/121/) from /UVIDATA directory.
; Builds Level one, Orbit, Attitude, and Partial Attitude filenames, Searches and selects the latest version of files.(KM);
; Default file locations
;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999	Applying the lastes FUV modifications
; Harald Frey		01/17/2000	Introducing filetype_flag for UDF
; Harald Frey		02/15/2000	introduced last_epoch to deal with UDF
;
;------------------------------------------------------------------------------------
;
 pro getudfdir, err_no, wic_ret, s12_ret, s13_ret, eventval, nselect = nselect, $
         starttime=starttime, stoptime=stoptime
;
@fuv_cmnblk
;

if (not keyword_set(starttime) and not keyword_set(stoptime)) then begin 

;expected Directory structure as in UDF
;
;Get path for WIC file
;
    err_no = 0
    L1path =DATA_PATH
    l1count=0
    pocount=0
    nrcount = 0
    selected_inst[*] = 0
    avail_inst[*] = 0
;
    CASE eventval of
    11300: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2000*D', $
    		TITLE='Please select one UDF file')
    11301: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2001*D', $
    		TITLE='Please select one UDF file')
    11302: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2002*D', $
    		TITLE='Please select one UDF file')
    11303: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2003*D', $
    		TITLE='Please select one UDF file')
    11304: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2004*D', $
    		TITLE='Please select one UDF file')
    11305: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2005*D', $
    		TITLE='Please select one UDF file')
    11306: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2006*D', $
    		TITLE='Please select one UDF file')
    11307: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2007*D', $
    		TITLE='Please select one UDF file')
    11308: pick=DIALOG_PICKFILE(PATH=L1path, FILTER='IMFHWIC2008*D', $
    		TITLE='Please select one UDF file')
    ENDCASE
;
; fix UNIX dialog_pickfile under IDL 6.0
   if (pick ne '') then begin
           numb1=strpos(pick,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(pick)
             pick=strmid(pick,0,numb1)+strmid(pick,numb1+2,numb2-numb1-2)
             endif
  	   endif
;
; Get directory with Year and day
    p2len= strlen(pick)
;
	filetypes=strmid(pick,p2len-4,3)
	IF (filetypes EQ 'CDF') THEN BEGIN
	 	ext='.cdf'
	        err_no=1
             stat_txt= 'CDF files are not supported here, Select again.'
             widget_control, status_id, set_value=stat_txt
	         return
	        end

	filetypes=strmid(pick,p2len-1,1)
	CASE filetypes OF
	 'D': ext='.udf'
	else:  begin
	        err_no=1
            stat_txt= 'No first Level1 cdf found, Select again.'
            widget_control, status_id, set_value=stat_txt
	        return
	       end
	endcase
;
    inst_pos=strpos(pick,'IMF',/reverse_search)
    first_year=strpos(pick,'19',inst_pos)		; 1999
     ; I know that I here produce a Y21H bug, because the whole thing
     ; does not work after the year 2099
     ; hopefully nobody will use UDF at that time anymore
    second_year=strpos(pick,'20',inst_pos)	; 2000 and later
    if (first_year eq -1) then first_year=100000l
    if (second_year eq -1) then second_year=100000l
    laenge=min([first_year,second_year])
    time_day=strmid(pick,laenge,11)		; now we construct everything
    
;
  widget_control, /HOURGLASS
;
; first Instrument
;
	; get the times
    return_value=fuv_read_udf(file=pick,/inventory)	
    lastrec=n_elements(return_value)
    ret_err=0
;    altitudes=fuv_read_udf(file=pick,variable='RADIUS')
    altitude=fltarr(100)+3.	
;
    fuv_mission_correction,return_value[0].btime.year,return_value[0].btime.doy,correction_value
    if (correction_value[0] eq 1. and correction_value[1] eq 1. and correction_value[2] eq 1.) then begin
           calibration_flag=0
           WIDGET_CONTROL,SET_VALUE=calibration_flag,calib_id
       	   result=dialog_message('Only raw counts possible for this day')
           endif

    inst_pos=strpos(pick,'/IM',/reverse_search) 
    first_year=strpos(pick,'19',inst_pos)			; 1999
    second_year=strpos(pick,'20',inst_pos)		; 2000 and later
    if (first_year eq -1) then first_year=100000l
    if (second_year eq -1) then second_year=100000l
    laenge=min([first_year,second_year])
    instrument = strmid(pick,inst_pos+1,laenge-inst_pos-1)	; 1 because /

    CASE instrument of
    'IMFHWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; HWIC
    'IMFLWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; LWIC
    'IMF12LSI': begin inst=1 & avail_inst[1]=1 & s12_ret=return_value & ENDCASE	; SI12
    'IMF13LSI': begin inst=2 & avail_inst[2]=1 & s13_ret=return_value & ENDCASE	; SI13
    ELSE: begin
	  err_no=1
            stat_txt= 'No first Level1 cdf found, Select again.'
            widget_control, status_id, set_value=stat_txt
	        return
	  endcase
    endcase

;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif else begin
       print,' Level 1 File =',pick
       selected_inst(inst)=1
       L1DIRFILE(inst)=pick
       L1DIR(inst) = strmid(pick,0,inst_pos)
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
       uget_time_list,inst,ret_err,return_value
    endelse

;
; next Instrument, most probably SI12
;
    CASE inst of
    0: BEGIN
       file=findfile(l1dir[inst]+'/IMF12LSI'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    1: BEGIN
       file=findfile(l1dir[inst]+'/IMF13LSI'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    2: BEGIN
       file=findfile(l1dir[inst]+'/IMFHWIC'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    ENDCASE
;
    ret_err=0
    l1usrfile=file[0]		; if there are more than one
;
    inst_pos=strpos(file[0],'/IM',/reverse_search) 
    first_year=strpos(file[0],'19',inst_pos)			; 1999
    second_year=strpos(file[0],'20',inst_pos)		; 2000 and later
    if (first_year eq -1) then first_year=100000l
    if (second_year eq -1) then second_year=100000l
    laenge=min([first_year,second_year])
    instrument = strmid(file[0],inst_pos+1,laenge-inst_pos-1)	; 1 because /

    CASE instrument of
    'IMFHWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; HWIC
    'IMFLWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; LWIC
    'IMF12LSI': begin inst=1 & avail_inst[1]=1 & s12_ret=return_value & ENDCASE	; SI12
    'IMF13LSI': begin inst=2 & avail_inst[2]=1 & s13_ret=return_value & ENDCASE	; SI13
    ELSE: begin
	  err_no=1
            stat_txt= 'No first Level1 cdf found, Select again.'
            widget_control, status_id, set_value=stat_txt
	        return
	  endcase
    endcase

;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif else begin
       print,' Level 1 File =',l1usrfile
       selected_inst(inst)=1
       L1DIRFILE(inst)=l1usrfile
       L1DIR(inst) = strmid(pick,0,inst_pos)
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
    endelse


;
; next Instrument, most probably SI13
;
    CASE inst of
    1: BEGIN
       file=findfile(l1dir[inst]+'/IMF13LSI'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    2: BEGIN
       file=findfile(l1dir[inst]+'/IMFHWIC'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    0: BEGIN
       file=findfile(l1dir[inst]+'/IMF12LSI'+strmid(time_day,0,7)+'*D')
       return_value=fuv_read_udf(file=file[0],/inventory)
       ENDCASE
    ENDCASE
;
;
    ret_err=0
    l1usrfile=file[0]		; if there are more than one
;
    inst_pos=strpos(file[0],'/IM',/reverse_search) 
    first_year=strpos(file[0],'19',inst_pos)			; 1999
    second_year=strpos(file[0],'20',inst_pos)		; 2000 and later
    if (first_year eq -1) then first_year=100000l
    if (second_year eq -1) then second_year=100000l
    laenge=min([first_year,second_year])
    instrument = strmid(file[0],inst_pos+1,laenge-inst_pos-1)	; 1 because /

    CASE instrument of
    'IMFHWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; HWIC
    'IMFLWIC' : begin inst=0 & avail_inst[0]=1 & wic_ret=return_value & ENDCASE	; LWIC
    'IMF12LSI': begin inst=1 & avail_inst[1]=1 & s12_ret=return_value & ENDCASE	; SI12
    'IMF13LSI': begin inst=2 & avail_inst[2]=1 & s13_ret=return_value & ENDCASE	; SI13
    ELSE: begin
	  err_no=1
            stat_txt= 'No first Level1 cdf found, Select again.'
            widget_control, status_id, set_value=stat_txt
	        return
	  endcase
    endcase

;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif else begin
       print,' Level 1 File =',l1usrfile
       selected_inst(inst)=1
       L1DIRFILE(inst)=l1usrfile
       L1DIR(inst) = strmid(pick,0,inst_pos)
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
    endelse
;
endif else begin
;
;Get data for WIC
;
    err_no = 0
    L1path =DATA_PATH
    l1count=0
    pocount=0
    nrcount = 0
    selected_inst[*] = 0
    avail_inst[*] = 0
    filetypes= 'D'
;
  widget_control, /HOURGLASS
;
; first Instrument
;
	; get the times
    return_value=fuv_read_udf(starttime=[yeara,doya,houra,0],$
           stoptime=[years,doys,hours,0],vinst='IMFHWIC',/inventory)	
    lastrec=n_elements(return_value)
    ret_err=0
    altitude=fltarr(100)+3.	
;
    fuv_mission_correction,return_value[0].btime.year,return_value[0].btime.doy,correction_value
    if (correction_value[0] eq 1. and correction_value[1] eq 1. and correction_value[2] eq 1.) then begin
           calibration_flag=0
           WIDGET_CONTROL,SET_VALUE=calibration_flag,calib_id
       	   result=dialog_message('Only raw counts possible for this day')
           endif

    inst=0 & avail_inst[0]=1 & wic_ret=return_value	; HWIC
;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif 
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
;
; next Instrument, most probably SI12
;
    return_value=fuv_read_udf(starttime=[yeara,doya,houra,0],$
           stoptime=[years,doys,hours,0],vinst='IMF12LSI',/inventory)	
;
    ret_err=0
;
    inst=1 & avail_inst[1]=1 & s12_ret=return_value	; SI12
;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif 
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
;
; next Instrument, most probably SI13
;
    return_value=fuv_read_udf(starttime=[yeara,doya,houra,0],$
           stoptime=[years,doys,hours,0],vinst='IMF13LSI',/inventory)	
;
;
    ret_err=0
;
    inst=2 & avail_inst[2]=1 & s13_ret=return_value    ; SI13
;
; find if there is anything
    if (n_elements(return_value) lt 1) then ret_err=1
;
    if (ret_err eq 1) then begin
          stat_txt= 'No data found.'
          widget_control, status_id, set_value=stat_txt
          wait,5.5
          stat_txt=''
          widget_control, status_id, set_value=stat_txt
    endif else begin
       cdf_id(inst)=!values.f_nan
       maxrec(inst)=n_elements(return_value)
       endelse

  endelse

    end

