;@(#)getudf_var.pro	7.0 11/02/2006
;
;; Created 06-23-99 (K.M)
;; Current is record number returned by recnum(Event.Index).
;---------------------------------------------------------------------------
; This the latest version of GIFWALK program.  
; Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999	Applying the lastes FUV modifications
; Hassan Dougani	10/28/1999	Modify structures for multiple Instruments
; Harald Frey		01/18/2000	transferred the original getcdf_var into
;					getudf_var for reading UDF
; Harald Frey		02/15/2000	introduced last_epoch to deal with UDF
;			10/05/2000 	small changes
;			10/19/2000	enable SIs
;			02/07/2001	removed last_epoch again
; T Immel		02/11/2001	added nowid keyword
;			02/13/2001 	included get_inst_angles_p
; Harald Frey		06/18/2001	several simplifications, fixed airglow bug
;					WIC HV for calibration
; Harald Frey		07/06/2001	reset all magnetic arrays
; Harald Frey		09/19/2001	full airglow/temperature/rayleigh calibration
; Harald Frey		07/12/2002	spin axis during 2001 summer vacation
; Harald Frey		11/04/2004	spin axis during 2004 summer vacation
; Harald Frey		12/20/2004	added angle keywords
; Harald Frey		11/26/2005	spin axis during 2005 summer vacation
; Harald Frey           01/12/2006      use satellite data for pointing
; Harald Frey           11/02/2006      many changes becauseof use satellite data for pointing
;
;-----------------------------------------------------------------------------
;
;
pro getudf_var,inst,record,ret_err,nowid=nowid,delta_phi=delta_phi,$
	delta_theta=delta_theta,delta_omega=delta_omega

@fuv_cmnblk
;
;
;  stat_txt = 'Processing Data for Highlighted Record.. '
;  if not keyword_set(nowid) then WIDGET_CONTROL, status_id, set_value=stat_txt

; Do for Curent record.

    ret_err = 0
    irec = record

    ImageInfo.epoch=dstr(record,inst).epoch
    imageinfo[inst].mlat[*]=0.
    imageinfo[inst].mlon[*]=0.
    imageinfo[inst].mlt[*]=0.
    imageinfo[inst].mlt_img[*]=0.

                 ;Adjust time to time at beginning of integration period
                 ; we subtract 15 s from the snapshot time
    CDF_EPOCH, dstr(record,inst).epoch-15000., year, month, day, hour, minute, $
                                second, msec, /BREAKDOWN_EPOCH

    doy=get_doy(day,month,year)

    CASE inst of
    0: vinst='IMFHWIC'
    1: vinst='IMF12LSI'
    2: vinst='IMF13LSI'
    ENDCASE
    endhour=hour+1
    enddoy=doy+((hour+1)/24)

	; for the non-real-time-operation
        return_value=fuv_read_udf(starttime=[year,doy,hour,minute,0], $
        stoptime=[year,enddoy,endhour,0,0],/one_record, $
        vinst=vinst)
print,'Starttime: ',return_value.btime
;Spin #	do not need, save time
;    Imageinfo(inst).spin=return_value.spin[0]
;
;Radius
;
    Imageinfo(inst).radius=sqrt(return_value.orb_x[0]^2+return_value.orb_y[0]^2+$
    	return_value.orb_z[0]^2)/6372.
    Imageinfo(inst).hgt=Imageinfo(inst).radius
;
;FOSCALE
    Imageinfo(inst).fovscale=return_value.fovscale[0]
;
;Spin Phase interpolate from pm1 and pm2
    if keyword_set(delta_time) then time_addition=delta_time else time_addition=0.
    center_time=(return_value.end_met[0]-return_value.start_met[0])/2.+$
    	return_value.start_met[0]+time_addition

    min_time=min(abs([return_value.pm1_valid_met,return_value.pm2_valid_met]-center_time),rate_ind)
    if (rate_ind eq 0) then old_phase1=(return_value.pm1_spinphase+360.d0*return_value.pm1_spin_rate*$
         (center_time-return_value.pm1_valid_met)/1000.d0/60.+360.d0) mod 360.d0 else $
         old_phase1=(return_value.pm2_spinphase+360.d0*return_value.pm2_spin_rate*$
         (center_time-return_value.pm2_valid_met)/1000.d0/60.+360.d0) mod 360.d0

    if (return_value.pm2_spinphase lt return_value.pm1_spinphase) then return_value.pm2_spinphase=$
        return_value.pm2_spinphase+360.d0
    spin_phase1=interpol([return_value.pm1_spinphase,return_value.pm2_spinphase],$
        [return_value.pm1_valid_met,return_value.pm2_valid_met],center_time)
    if (keyword_set(new_phase)) then spin_phase1=new_phase
    Imageinfo(inst).spin_phase=spin_phase1	; 
;        
;	init for offset angles
new=0
;
; during summer vacation we can skip all the calculations of spin axis
;
	; 2001 summer vacation, [2001,159,0,0] to [2001,233,2,0]
    if (center_time gt 3.794d10 and center_time lt 4.434d10) then begin
        restore,'$FUVIEW_HOME/attitude/spin_axis_2001.sav'
	x_comp=funct_fun(center_time/1.d10,x_parameters)
	y_comp=funct_fun(center_time/1.d10,y_parameters)
	z_comp=funct_fun(center_time/1.d10,z_parameters)
	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
;	print,'magnitudes 2001 ',total(Imageinfo(inst).a_gci3^2),magnitude
	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
	goto,skip_satellite_for_now
	endif
	; 2002 april vacation, [2002,108,0,0] to [2002,110,0,0]
;    if (center_time gt 6.507d10 and center_time lt 6.52428d10) then begin
;        restore,'$FUVIEW_HOME/attitude/spin_axis_2002.sav'
;	x_comp=funct_fun(center_time/1.d10,x_parameters)
;	y_comp=funct_fun(center_time/1.d10,y_parameters)
;	z_comp=funct_fun(center_time/1.d10,z_parameters)
;	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
;	print,'April magnitudes 2002 ',total(Imageinfo(inst).a_gci3^2),magnitude
;	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
;	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
;	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
;	goto,skip_satellite_for_now
;	endif
	; 2002 summer vacation, [2002,141,22,0] to [2002,234,12,0]
    if (center_time gt 6.8d10 and center_time lt 7.6d10) then begin
        restore,'$FUVIEW_HOME/attitude/spin_axis_2002.sav'
	x_comp=funct_fun(center_time/1.d10,x_parameters)
	y_comp=funct_fun(center_time/1.d10,y_parameters)
	z_comp=funct_fun(center_time/1.d10,z_parameters)
	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
;	print,'magnitudes 2002 ',total(Imageinfo(inst).a_gci3^2),magnitude
	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
	goto,skip_satellite_for_now
	endif
	; 2003 summer vacation, [2003,160,0,0] to [2003,228,0,0]
    if (center_time gt 10.11d10 and center_time lt 10.6975d10) then begin
        restore,'$FUVIEW_HOME/attitude/spin_axis_2003.sav'
	x_comp=funct_fun(center_time/1.d10,x_parameters)
	y_comp=funct_fun(center_time/1.d10,y_parameters)
	z_comp=funct_fun(center_time/1.d10,z_parameters)
	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
	goto,skip_satellite_for_now
	endif
	; 2004 summer vacation, [2004,162,19,30] to [2004,243,5,0]	; 1,2 checked
    if (center_time gt 13.288d10 and center_time lt 13.982d10) then begin
;        restore,'$FUVIEW_HOME/attitude/spin_axis_2004.sav'
        restore,getenv('FUVIEW_HOME')+dir_sep+'attitude'+dir_sep+'spin_axis_2004.sav'
	x_comp=funct_fun(center_time/1.d10,x_parameters)
	y_comp=funct_fun(center_time/1.d10,y_parameters)
	z_comp=funct_fun(center_time/1.d10,z_parameters)
	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
	goto,skip_satellite_for_now
	endif
	; 2005 summer vacation, [2005,165,5,0] to [2005,237,21,30]	; 1,2 checked
    if (center_time gt 16.488d10 and center_time lt 17.099d10) then begin
;        restore,'$FUVIEW_HOME/attitude/spin_axis_2005.sav'
        restore,getenv('FUVIEW_HOME')+dir_sep+'attitude'+dir_sep+'spin_axis_2005.sav'
	x_comp=funct_fun(center_time/1.d10,x_parameters)
	y_comp=funct_fun(center_time/1.d10,y_parameters)
	z_comp=funct_fun(center_time/1.d10,z_parameters)
	magnitude=sqrt(x_comp^2+y_comp^2+z_comp^2)
	Imageinfo(inst).a_gci3[0]=x_comp/magnitude
	Imageinfo(inst).a_gci3[1]=y_comp/magnitude
	Imageinfo(inst).a_gci3[2]=z_comp/magnitude
	goto,skip_satellite_for_now
	endif
;
;Spin Axis Coordinates interpolate from pm1 and pm2
    linear_term=(return_value.pm2_sv_x[0]-return_value.pm1_sv_x[0])/$
    	(return_value.pm2_valid_met[0]-return_value.pm1_valid_met[0])
    off_set=return_value.pm2_sv_x[0]-linear_term*return_value.pm2_valid_met[0]
    Imageinfo(inst).a_gci3[0]=center_time*linear_term+off_set

    linear_term=(return_value.pm2_sv_y[0]-return_value.pm1_sv_y[0])/$
    	(return_value.pm2_valid_met[0]-return_value.pm1_valid_met[0])
    off_set=return_value.pm2_sv_y[0]-linear_term*return_value.pm2_valid_met[0]
    Imageinfo(inst).a_gci3[1]=center_time*linear_term+off_set

    linear_term=(return_value.pm2_sv_z[0]-return_value.pm1_sv_z[0])/$
    	(return_value.pm2_valid_met[0]-return_value.pm1_valid_met[0])
    off_set=return_value.pm2_sv_z[0]-linear_term*return_value.pm2_valid_met[0]
    Imageinfo(inst).a_gci3[2]=center_time*linear_term+off_set
;
; Dates before summer 2002 will use old way
if ((return_value.btime.year eq 2000) or (return_value.btime.year eq 2001) or $
   (return_value.btime.year eq 2002 and return_value.btime.doy le 234)) then begin
      print,'Calculation done the old way!'
      goto,skip_satellite_for_now
      endif

; read satellite data for spin axis orientation
;
interval=1
read_axis_again:
    res1=fuv_read_udf(starttime=[return_value.btime.year,$
        fix(return_value.btime.doy),fix(return_value.btime.hour),$
        fix(return_value.btime.min)-interval],$
        stoptime=[return_value.etime.year,$
        fix(return_value.etime.doy),fix(return_value.etime.hour),$
        fix(return_value.etime.min)+interval],$
        vinst='IMS4BYTE')
    res2=fuv_read_udf(starttime=[return_value.btime.year,$
        return_value.btime.doy,fix(return_value.btime.hour),$
        fix(return_value.btime.min)-interval],$
        stoptime=[return_value.etime.year,$
        return_value.etime.doy,fix(return_value.etime.hour),$
        fix(return_value.etime.min)+interval],$
        vinst='IMS2BYTE')
;
if ((size(res2,/type) ne 8) or (size(res1,/type) ne 8)) then begin
   result=dialog_message('No satellite data! Calculation will be done the old way.')
   print,'Old way'
   goto,skip_satellite_for_now
   endif
   
		; Time Axis
qqq=where(res2.d_qual[182] eq 0)
time2=where(res1.star_tracker_data_met_stamp-shift(res1.star_tracker_data_met_stamp,1) lt -6500.,count_time2)
if (count_time2 eq 0) then begin
	; everything is fine, just fill coarse time
   if (min(res2[qqq].(190)) eq max(res2[qqq].(190))) then res2[*].(190)=max(res2[qqq].(190)) else $
       stop
   endif else begin
   res2[0:time2-1].(190)=min(res2[qqq].(190))
   res2[time2:*].(190)=max(res2[qqq].(190))
   endelse
int_time=reform(res2.(190)*6553.6+res1.star_tracker_data_met_stamp)

	; read more if time interval is not right
if ((center_time/1.d3-int_time[0]) gt 0. and $
   (int_time[n_elements(int_time)-1]-center_time/1.d3) gt 0.) then begin
   ok=1
   endif else begin
   print,'Times: ',center_time/1.d3-int_time[0],int_time[n_elements(int_time)-1]-center_time/1.d3
   interval=5*interval
   if (interval gt 25) then begin
      print,'I give up reading satellite data'
      return
      endif
   goto,read_axis_again
   endelse
;
; Quaternions
;
qqq=where(res1.d_qual[20,*] ne 0,count)
if (count ne 0) then stop
q1s=res1.Q1__gci_to_ast_w_att_uncer
for i=0l,n_elements(q1s)-1l do q1s[i]=twoscomplement(q1s[i])
;
qqq=where(res1.d_qual[21,*] ne 0,count)
if (count ne 0) then stop
q2s=res1.Q2__gci_to_ast_w_att_uncer
for i=0l,n_elements(q2s)-1l do q2s[i]=twoscomplement(q2s[i])
;
qqq=where(res1.d_qual[22,*] ne 0,count)
if (count ne 0) then stop
q3s=res1.Q3__gci_to_ast_w_att_uncer
for i=0l,n_elements(q3s)-1l do q3s[i]=twoscomplement(q3s[i])
;
qqq=where(res1.d_qual[23,*] ne 0,count)
if (count ne 0) then stop
q4s=res1.Q4__gci_to_ast_w_att_uncer
for i=0l,n_elements(q4s)-1l do q4s[i]=twoscomplement(q4s[i])
;
magnitude=sqrt(q1s^2+q2s^2+q3s^2+q4s^2)
q1s=q1s/magnitude
q2s=q2s/magnitude
q3s=q3s/magnitude
q4s=q4s/magnitude
;
	; rotation matrix
b=[q1s^2-q2s^2-q3s^2+q4s^2,2*(q1s*q2s+q3s*q4s),2*(q1s*q3s-q2s*q4s),$
   2*(q1s*q2s-q3s*q4s),(-1.)*q1s^2+q2s^2-q3s^2+q4s^2,2.*(q2s*q3s+q1s*q4s),$
   2.*(q1s*q3s+q2s*q4s),2.*(q2s*q3s-q1s*q4s),(-1.)*q1s^2-q2s^2+q3s^2+q4s^2]
	; between star tracker and s/c X
ast_offset=[[ 0.382683d0,-0.923880d0, 0.000000d0],$
            [-0.909844d0,-0.376870d0, 0.173648d0],$
            [-0.160430d0,-0.066452d0,-0.984808d0]]
vector=[[0.d0],[0.d0],[1.d0]]	; do not touch
axiss=dblarr(3,n_elements(res1))
	; ugly for loop
for i=0,n_elements(res1)-1 do begin $
  matri4=transpose(reform(b[*,i],3,3)) & $	; do not touch
  result4=matri4##ast_offset##vector & $	; do not touch
  axiss[*,i]=result4 & $			; do not touch
  endfor

	; check if there is any problem with the time alignment
dummy=where(abs((int_time-shift(int_time,1))) gt 20.,time_count)
case 1 of
(time_count eq 0): ok=1 
(time_count eq 1): begin
		if (dummy eq 0) then ok=1 else stop
		endcase
(time_count eq 2 and dummy[0] eq 0): begin
	      stop
	      int_time=[int_time[1:dummy[1]-1],int_time[dummy[1]+1:*]]
	      axiss=[[axiss[*,1:dummy[1]-1]],[axiss[*,dummy[1]+1:*]]]
              endcase
(time_count eq 3 and dummy[0] eq 0 and dummy[2] ne (n_elements(int_time)-1)): begin
	      stop
	      int_time=[int_time[1:dummy[1]-1],int_time[dummy[2]+1:*]]
	      axiss=[[axiss[*,1:dummy[1]-1]],[axiss[*,dummy[2]+1:*]]]
              endcase
(time_count eq 3 and dummy[0] eq 0 and dummy[2] eq (n_elements(int_time)-1)): begin
	      stop
	      int_time=int_time[1:dummy[1]-1]
	      axiss=[axiss[*,1:dummy[1]-1]]
              endcase
ELSE: begin
	print,'something funny with time line'
	stop
	endcase
endcase

;stop
;window,2
;set_plot,'z'
;!p.multi=[0,1,2]
;plot,geo_data[0,*],good_angle,/xstyle,/ystyle
;plots,center_time,geo_angle,psym=2,color=253
;plot,geo_data[0,*],(good_angle+360.d0) mod 360.d0,/xstyle,/ystyle,xrange=[center_time-10000,center_time+10000]
;plots,center_time,geo_angle,psym=2,color=253
;device,/close
;set_plot,'x'

	; spin axis
newx=interpol(axiss[0,*],int_time,center_time/1.d3)
newy=interpol(axiss[1,*],int_time,center_time/1.d3)
newz=interpol(axiss[2,*],int_time,center_time/1.d3)
magn_f=sqrt(newx^2+newy^2+newz^2)
newx=temporary(newx/magn_f)
newy=temporary(newy/magn_f)
newz=temporary(newz/magn_f)

print,'  '
print,'Final: ',center_time/1.d3,imageinfo[inst].spin_phase,old_phase1,$
   Imageinfo(inst).a_gci3,newx,newy,newz,format='(a7,f12.2,2f8.3,6f10.6)'

	; free some variables
axiss=0 & res1=0 & res2=0 & q1s=0 & q2s=0 & q3s=0 & q4s=0
Imageinfo(inst).a_gci3=[newx,newy,newz]
new=1

skip_satellite_for_now:
;        
;--- get azimuth, co_elevation, and roll angles.
;
	if keyword_set(no_print) then get_inst_angles_p,inst,return_value.btime.year,return_value.btime.doy,inst_angles,no_print=1,new=new else $
	     get_inst_angles_p,inst,return_value.btime.year,return_value.btime.doy,inst_angles,new=new
;
;Orbit Coordinates
    Imageinfo(inst).o_gci(0)=return_value.orb_x[0]
    Imageinfo(inst).o_gci(1)=return_value.orb_y[0]
    Imageinfo(inst).o_gci(2)=return_value.orb_z[0]
;
;Horizontal FOV
    case inst of
	0:  begin
	    Imageinfo(inst).hfov=17.2		;return_value.hfov[0]
            if (return_value.btime.year eq 2000 and return_value.btime.doy ge 285) then Imageinfo(inst).hfov=17.27
            if (return_value.btime.year gt 2000) then Imageinfo(inst).hfov=17.27
	    endcase
	1:  begin
	    Imageinfo(inst).hfov=16.3		;for 2000, 167<day<278
	    if (return_value.btime.year eq 2000 and return_value.btime.doy lt 168) then Imageinfo(inst).hfov=17.2
	    if (return_value.btime.year eq 2000 and return_value.btime.doy gt 277) then Imageinfo(inst).hfov=16.75
	    if (return_value.btime.year gt 2000) then Imageinfo(inst).hfov=16.75
	    ENDCASE
	2:  Imageinfo(inst).hfov=16.5		;return_value.hfov[0]
	ENDCASE

;--- save these angles in imageinfo structure

        Imageinfo(inst).inst_azimuth=inst_angles(0)
        Imageinfo(inst).inst_co_elev=inst_angles(1)
        Imageinfo(inst).inst_roll=inst_angles(2)
        if keyword_set(delta_phi) then Imageinfo(inst).inst_azimuth=inst_angles(0)+delta_phi
        if keyword_set(delta_theta) then Imageinfo(inst).inst_co_elev=inst_angles(1)+delta_theta
        if keyword_set(delta_omega) then Imageinfo(inst).inst_roll=inst_angles(2)+delta_omega

;Vertical FOV
    case inst of
    	0:  Imageinfo(inst).vfov=17.2		;return_value.vfov[0]
    	1:  Imageinfo(inst).vfov=17.5		;return_value.vfov[0]
    	2:  Imageinfo(inst).vfov=16.8		;return_value.vfov[0]
    	ENDCASE

;Spin Axis in S/C
    Imageinfo(inst).sc_sv(0)=return_value.scsv_x[0]
    Imageinfo(inst).sc_sv(1)=return_value.scsv_y[0]
    Imageinfo(inst).sc_sv(2)=return_value.scsv_z[0]


;Get Image and HV
;
    case inst of
    0:    begin
    	  raw_image = rotate(return_value.wic_pixels,4)
          Imageinfo[inst].hv_phos=return_value.hv_phos[0]
          Imageinfo[inst].hv_mcp=return_value.hv_mcp[0]
          endcase
    else: begin
          tmp_image = rotate(return_value.si_pixels,3)
          raw_image = Congrid(REFORM(tmp_image),256,256)
          Imageinfo[inst].hv_mcp=return_value.hv[0]		;Place in hv_mcp
          Imageinfo[inst].hv_phos=0.
          endcase
   endcase

;
;Calculate angular_resolutions
   ImageInfo(inst).angl_res_r=ImageInfo(inst).vfov/ImageInfo(inst).rows
   ImageInfo(inst).angl_res_c=(ImageInfo(inst).hfov*ImageInfo(inst).fovscale)/ImageInfo(inst).cols
;
;Calculating Pointing Information for the image
   fuv_calc_pointing, inst, posX, posY, posZ, record
;
;Calibrate image
;
;Detector calibration correction
;Apply Flat-Field/Absoute calibration/BKG subtraction

    ff_corr=1.0
    bkg_level=0.0
    airglow_counts=0.0
    rayleigh_conversion=[1.0,1.0,1.0]
    temp_correction=1.0
    airglow_temperature=[1.0,0.94,0.99]	; determined from days for determination

;--- do airglow corrections/subtraction

if airglow_flag gt 0 then begin
  
  imageinfo[inst].airglow_scale=airglow_scale
  if inst gt 0 then begin
	downshift
        spare_imageinfo=SIinfo(inst)		;image_bckgnd_p requires that the imageinfo
        spare_imageinfo.image = congrid(raw_image, 128, 128) ; -new for active dayglow subtraction
  endif else begin                              ;structure reflects the true resolution
    spare_imageinfo = imageinfo(inst)           ;of the imager!!
    spare_imageinfo.image = raw_image        ; -new for active dayglow subtraction
  endelse

;--- noflat not set because want that done separately
;  image_fuview_bckgnd,spare_imageinfo,airglow_counts,0,/nof107,/bias  

;--- early versions of image_fuview_bckgnd did not examine the image
;    for its counting rates, and did not mind that the image was
;    rotated with respect to the angles. NOW WE CARE, since we are
;    doing an active subtraction of counts. Now the spare_imageinfo.image
;    array must be rotated.

;print,  '6-28-02 - TJI working with new dayglow subtraction'
;  stop  ; 6-28-02 - TJI working with new dayglow subtraction

  
;

  spare_imageinfo.image = rotate(spare_imageinfo.image, 3)
  image_fuview_bckgnd, spare_imageinfo, airglow_counts, 0, airglow_flag  ;airglow counts will be flat.

;-should we un-flatfield airglow_counts?

  airglow_counts=congrid(airglow_counts,256,256)  
  off_bck = where(imageinfo[inst].dza gt 85,offcount)

  bkg_level=airglow_scale(2)
  bkg_power=airglow_scale(1)
  bkg_multi=airglow_scale(0)

  airglow_counts=bkg_multi * (airglow_counts^bkg_power) 
  if offcount gt 0 then airglow_counts(off_bck)=min(airglow_counts[50:200,50:200])
  airglow_counts=rotate(airglow_counts,1)	

endif 

;--- separately apply conversions to absolute brightness

    imageinfo[inst].calibration_flag=calibration_flag
    case calibration_flag of
    0: temperature_correction=1.	; do nothing, raw values
    1: begin
       ff_corr=get_fuview_flatfield(year,doy,inst)
       case inst of
         0: ff_corr=rotate(ff_corr,1)
         1: ff_corr=congrid(rotate(ff_corr,1),256,256)
         2: ff_corr=congrid(rotate(ff_corr,1),256,256)
         endcase
       temp_correction=correction_value[inst]
;--- if using active dayglow subtraction, comment out the following line
;       if (airglow_flag eq 1) then airglow_counts=airglow_counts/airglow_temperature[inst]
       endcase
    2: begin
      ff_corr=get_fuview_flatfield(year,doy,inst)
       case inst of
         0: ff_corr=rotate(ff_corr,1)
         1: ff_corr=congrid(rotate(ff_corr,1),256,256)
         2: ff_corr=congrid(rotate(ff_corr,1),256,256)
         endcase
      temp_correction=correction_value[inst]
;--- if using active dayglow subtraction, comment out the following line
;      if (airglow_flag eq 1) then airglow_counts=airglow_counts/airglow_temperature[inst]
      rayleigh_conversion = [0.613, 0.0235, 0.0153]
      endcase
    endcase

;--- done with calculation, now apply all corrections.

;    cal_img = ((raw_image*temp_correction-airglow_counts)*ff_corr-bkg_level)/rayleigh_conversion[inst] > 0.
;    airglow_counts is still *flat*, while raw_image is definitely NOT

    cal_img = (((raw_image-airglow_counts)*temp_correction)*ff_corr-bkg_level)/rayleigh_conversion[inst] > 0.

;--- done with absolute brightness conversions

;    stop

    ImageInfo(inst).image = cal_img
    ImageInfo(inst).min = 3.0
    ImageInfo(inst).max = 300.0
    lastrec = maxrec(inst) - 1
    stat_txt = ''
    if not keyword_set(nowid) then WIDGET_CONTROL,status_id, set_value=stat_txt

end
