;%W% %G%
;
PRO get_lt,ut,year,month,day,lat,lon,apexfile, glt,mlt 

    ;Calculate local times in geodetic and magnetic coords.

    ;INPUT:
    ;ut      Universal Time in hours
    ;year    year
    ;month   month of year (1-12)
    ;day     day of month (1-31)
    ;lat     geodetic latitude
    ;lon     geodetic longitude
    ;apexfile - name of data file containing apex coordinates

    ;OUTPUT:
    ;glt     geodetic local time, angle between current meridian
    ;         and meridian containing subsolar point with 12 hour
    ;         phase shift so glt=0 corresponds with midnight
    ;mlt     magnetic local time, same as glt but using magnetic
    ;         meridians

    ;get Julian daynumber, needed for the call to ephem
    greg_to_jdaynum,year,month,day,jd

    ;get equation of time and Greenwich hour angle
    ephem,jd,ut,gha,dec,eqtime

    ;calculate geodetic local time
    glt = (lon + gha)/15. - 12. 
   
    ;check range of glt 0-24 
    ndx=WHERE(glt LT 0,count)
    IF(count GT 0) THEN glt(ndx)=glt(ndx)+24.
    ndx=WHERE(glt GT 24,count)
    IF(count GT 0) THEN glt(ndx)=glt(ndx)-24.

    ;get solar longitude degrees.  the equation of time is
    ;given in degrees and must be converted to hours.
    slon = (12. - ut - (eqtime/15.))*15.

    ;convert geodetic data into magnetic data
    geo_to_apex,lat,lon,lat_mag,lon_mag, apexfile
    geo_to_apex,dec,slon,slat_mag,slon_mag, apexfile

    ;calculate magnetic local time
    mlt = (lon_mag - slon_mag)/15. + 12.

    ;check range of mlt 0-24 
    ndx=WHERE(mlt LT 0,count)
    IF(count GT 0) THEN mlt[ndx]=mlt[ndx]+24.
    ndx=WHERE(mlt GT 24,count)
    IF(count GT 0) THEN mlt[ndx]=mlt[ndx]-24.

END
