; fuv_read_udf.pro version 4.0.2, February 1, 2006, Harald Frey, SSL-UCB
;=============================================================================
;+
; This module is generated by the script 'gen_list_of_all.pl'.
;
; DO NOT EDIT THIS FILE.  YOUR CHANGES WILL BE LOST.
;
;  copied from Ed Santiago, January 28, 2000
;-
FUNCTION vinst_to_full_path, vi
  IF N_Params() NE 1 THEN MESSAGE, 'Usage: p = vinst_to_full_path( vinst )'

  On_Error, 2
  tbl = StrArr(109, 5)
  tbl[  0,*] = ['IMAGE','IMAGE1','SAT','SAT','IMS4BYTE']
  tbl[  1,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCBDDMP']
  tbl[  2,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCBOOT']
  tbl[  3,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCCQDMP']
  tbl[  4,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCDRAM']
  tbl[  5,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCECMDQ']
  tbl[  6,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCHIRHK']
  tbl[  7,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCLORHK']
  tbl[  8,*] = ['IMAGE','IMAGE1','CIDP','CIDP','IMCMEMD']
  tbl[  9,*] = ['IMAGE','IMAGE1','EUV','EUVHSKP','IMEDHSKP']
  tbl[ 10,*] = ['IMAGE','IMAGE1','EUV','EUVHSKP','IMEINTRN']
  tbl[ 11,*] = ['IMAGE','IMAGE1','EUV','EUVHSKP','IMEMEMD']
  tbl[ 12,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES0CHS']
  tbl[ 13,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES0EVT']
  tbl[ 14,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES0IMG']
  tbl[ 15,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES0WSZ']
  tbl[ 16,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES1CHS']
  tbl[ 17,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES1EVT']
  tbl[ 18,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES1IMG']
  tbl[ 19,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES1WSZ']
  tbl[ 20,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES2CHS']
  tbl[ 21,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES2EVT']
  tbl[ 22,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES2IMG']
  tbl[ 23,*] = ['IMAGE','IMAGE1','EUV','EUVSCI','IMES2WSZ']
  tbl[ 24,*] = ['IMAGE','IMAGE1','EUV','EUVHSKP','IMESTAT']
  tbl[ 25,*] = ['IMAGE','IMAGE1','EUV','EUVHSKP','IMETAPE']
  tbl[ 26,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMF12HSI']
  tbl[ 27,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMF12LSI']
  tbl[ 28,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMF13HSI']
  tbl[ 29,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMF13LSI']
  tbl[ 30,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMFCPMSG']
  tbl[ 31,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFECHO']
  tbl[ 32,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMFGEO']
  tbl[ 33,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFHSKP']
  tbl[ 34,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMFHWIC']
  tbl[ 35,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMFLWIC']
  tbl[ 36,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFMEMD']
  tbl[ 37,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFNVRAM']
  tbl[ 38,*] = ['IMAGE','IMAGE1','FUV','FUVSCI','IMFSIPHA']
  tbl[ 39,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFSUNAL']
  tbl[ 40,*] = ['IMAGE','IMAGE1','FUV','FUVHSKP','IMFSUNTR']
  tbl[ 41,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHACCUM']
  tbl[ 42,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHALARM']
  tbl[ 43,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHASTAT']
  tbl[ 44,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHCALS']
  tbl[ 45,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHECHO']
  tbl[ 46,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHICNO']
  tbl[ 47,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHIH']
  tbl[ 48,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHIHE']
  tbl[ 49,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHIMCPH']
  tbl[ 50,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHIMCPL']
  tbl[ 51,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHISSDE']
  tbl[ 52,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHMACRO']
  tbl[ 53,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHMEMC']
  tbl[ 54,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHMEMD']
  tbl[ 55,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHMLIM']
  tbl[ 56,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHMPHA']
  tbl[ 57,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHMRPHA']
  tbl[ 58,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHPARM']
  tbl[ 59,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHSCHED']
  tbl[ 60,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHSPARM']
  tbl[ 61,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHSPHA']
  tbl[ 62,*] = ['IMAGE','IMAGE1','HENA','HENASCI','IMHSRPHA']
  tbl[ 63,*] = ['IMAGE','IMAGE1','HENA','HENAHSKP','IMHSTAT']
  tbl[ 64,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLDHSKP']
  tbl[ 65,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLECHO']
  tbl[ 66,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLEVENT']
  tbl[ 67,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLHKPRT']
  tbl[ 68,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLHSKP']
  tbl[ 69,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLHVSTB']
  tbl[ 70,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLIMAGE']
  tbl[ 71,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLMEMD']
  tbl[ 72,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLNAHKP']
  tbl[ 73,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLQLOOK']
  tbl[ 74,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLROI0']
  tbl[ 75,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLROI1']
  tbl[ 76,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLROI2']
  tbl[ 77,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLROI3']
  tbl[ 78,*] = ['IMAGE','IMAGE1','LENA','LENASCI','IMLSNGLS']
  tbl[ 79,*] = ['IMAGE','IMAGE1','LENA','LENAHSKP','IMLSTRCH']
  tbl[ 80,*] = ['IMAGE','IMAGE1','MENA','MENASCI','IMMHRSNG']
  tbl[ 81,*] = ['IMAGE','IMAGE1','MENA','MENASCI','IMMIMAGE']
  tbl[ 82,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMLHSKP']
  tbl[ 83,*] = ['IMAGE','IMAGE1','MENA','MENASCI','IMMLRSNG']
  tbl[ 84,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMMEMD']
  tbl[ 85,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMNHKA']
  tbl[ 86,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMNHKB']
  tbl[ 87,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMNHKC']
  tbl[ 88,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMRHSKP']
  tbl[ 89,*] = ['IMAGE','IMAGE1','MENA','MENAHSKP','IMMSHSKP']
  tbl[ 90,*] = ['IMAGE','IMAGE1','MENA','MENASCI','IMMSTATS']
  tbl[ 91,*] = ['IMAGE','IMAGE1','MENA','MENASCI','IMMSTSP']
  tbl[ 92,*] = ['IMAGE','IMAGE1','OA','ORBIT','IMOORBIT']
  tbl[ 93,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRCAL']
  tbl[ 94,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRCIDP']
  tbl[ 95,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRDBD']
  tbl[ 96,*] = ['IMAGE','IMAGE1','RPI','RPIHSKP','IMRECHO']
  tbl[ 97,*] = ['IMAGE','IMAGE1','RPI','RPIHSKP','IMRHSKP']
  tbl[ 98,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRLTD']
  tbl[ 99,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRLTDE']
  tbl[100,*] = ['IMAGE','IMAGE1','RPI','RPIHSKP','IMRMEMD']
  tbl[101,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRPRD']
  tbl[102,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRSBD']
  tbl[103,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRSMD']
  tbl[104,*] = ['IMAGE','IMAGE1','RPI','RPIHSKP','IMRSMSG']
  tbl[105,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRSSD']
  tbl[106,*] = ['IMAGE','IMAGE1','RPI','RPISCI','IMRTTD']
  tbl[107,*] = ['IMAGE','IMAGE1','SAT','SAT','IMS1BYTE']
  tbl[108,*] = ['IMAGE','IMAGE1','SAT','SAT','IMS2BYTE']

  IF size(vi,/TName) EQ 'STRING' THEN BEGIN
    uvi = StrUpCase(vi)
    FOR i=0L,108 DO IF tbl[i,4] EQ uvi THEN RETURN, reform(tbl[i,*])
    MESSAGE, 'Cannot locate virtual instrument "' + uvi + '"'
  ENDIF ELSE BEGIN
    IF vi LT 0 THEN RETURN, 108 ELSE RETURN, reform(tbl[vi,*])
  ENDELSE
END

;===================================================================
function fuv_read_udf,starttime=starttime,stoptime=stoptime, $
   variable=variable,record=record,inventory=inventory,file=file, $
   one_record=one_record,instrument=instrument,everything=everything, $
   vinst=vinst,_Extra=_e,time_list=time_list,silent=silent
;==================================================================
; NAME:			fuv_read_udf	
; PURPOSE:		read data from UDF IMAGE file
; CATEGORY:
; CALLING SEQUENCE:  	result=fuv_read_udf(file=filename,/inventory)
; INPUTS:		none
; OPTIONAL INPUTS:	starttime=[year,doy,hour,min,sec]
;			stoptime =[year,doy,hour,min,sec]
;			variable= variable name
;			record = record number
;			inventory if we want to get the records and times
;			file = filename
;			one_record if we want only one record
;			instrument = name of the desired instrument
;			everything if we want everything
;			vinst = UDF code for instrument
; KEYWORD PARAMETERS:   silent    no printouts or records read
; OUTPUTS:		result
; OPTIONAL OUTPUTS:
; COMMON BLOCKS:	none
; SIDE EFFECTS:		I don't know of any
; RESTRICTIONS:		at least one keyword has to be set
; PROCEDURE:
; EXAMPLE:
; SEE ALSO:
; MODIFICATION HISTORY:
;      Written by: Harald Frey
;      Date: January 14, 2000
;	    1.1 January 20, 2000 included reading everything
;				 corrected variable
;	    			 can be run with IDL 5.2
;				 introduced inst_dir
;	    1.2 January 28, 2000 call of vinst
;	    1.3 February 14, 2000 introduced keyword gonna_get_out
;	    1.4 February 17, 2000 introduced dynamic_create_my_structure
;				  prepared better error handler
;	    1.5 March 14, 2000    disabled keyword gonna_get_out
;	    2.0 July 20, 2000     major modification, support doubles,
;				  check for quicklooks etc.
;           3.0 March 18, 2001	upgrade for FSW 7.6
;           4.0 November 22, 2005 use of Chris Gurgiolo udf dlm
;           4.0.1 Nov. 23, 2005  removed dynamic_create_my_structure
;	    4.0.2 Feb. 01, 2006  introduced silent keyword
;-

forward_function vinst_to_full_path

	; here we know the filename
if keyword_set(file) then begin
  if (float(strmid(!version.release,0,3)) ge 5.3) then $
  	inst_pos=strpos(file,'IMF',/reverse_search)-1 $
      else begin
  	complete_length=strlen(file)
  	inst_pos=strpos(file,'IMF',complete_length-23)-1
  endelse
  first_year=strpos(file,'19',inst_pos)			; 1999
  	; I know that I here produce a Y21H bug, because the whole thing
  	; does not work after the year 2099
  	; hopefully nobody will use UDF at that time anymore
  second_year=strpos(file,'20',inst_pos)		; 2000 and later
  if (first_year eq -1) then first_year=100000l
  if (second_year eq -1) then second_year=100000l
  laenge=min([first_year,second_year])
  inst = strmid(file,inst_pos+1,laenge-inst_pos-1)	; 1 because /
endif

	; if we want a specific instrument
if keyword_set(instrument) then inst=instrument

	; get udf key
if keyword_set(vinst) then begin
	key=UDF_Key(vinst_to_full_path(vinst)) 
	inst_dir=(vinst_to_full_path(vinst))[3]
	inst=(vinst_to_full_path(vinst))[4]
	ENDIF ELSE BEGIN
 CASE inst of
  'IMFHWIC' : inst_dir='FUVSCI'
  'IMFLWIC' : inst_dir='FUVSCI'
  'IMF12LSI': inst_dir='FUVSCI'
  'IMF13LSI': inst_dir='FUVSCI'
  'IMFGEO'  : inst_dir='FUVSCI'
  'IMFCPMSG': inst_dir='FUVSCI'
  'IMFSIPHA': inst_dir='FUVSCI'
  ELSE:       inst_dir='FUVHSKP'
  ENDCASE
 key = UDF_Key('IMAGE', 'IMAGE1', 'FUV', inst_dir, inst)
 ENDELSE

	; we either produce the available times or specify with start, stop
CASE 1 OF
keyword_set(starttime): begin
  if (keyword_set(stoptime)) then begin     
	; open file and check for error
     catch_count=0
     Catch, error_status
     IF (error_status NE 0) THEN begin
     	key = UDF_Key('IMAGE', 'IMAGE1Q', 'FUV', inst_dir, inst) 
     	catch_count=catch_count+1
     	if (catch_count ge 2) then begin
;     	   result=DIALOG_MESSAGE(!Error_State.Msg)
     	   return,-1
     	   ENDIF
     	endif
     Catch, /Cancel
     catch, error_status
     if (error_status ne 0) then begin
;         print,'No data for this period'
         return,-1
         endif
;stop
;fh=0
;help,inst,key,starttime,stoptime
     fh  = UDF_Open(key, starttime, stoptime, DFORMAT=1)

;print,'done'
     catch, /cancel
  endif else begin		; keyword stoptime
     print,'You need to specify a stop time'
     return,0
     endelse
   endcase
ELSE: begin 	; starttime loop
	; obtain list of times and  select the right one
	; we do not expect more than one file per day
	; here we know that the file exists, but it may be quick-look
  times =udf_times(key)
  dummy = where(times.btime.year eq strmid(file,11,4,/reverse_offset) and $
	times.btime.doy eq strmid(file,7,3,/reverse_offset) and $
	times.btime.hour eq strmid(file,4,2,/reverse_offset))
  Catch, err_sts
  IF (err_sts NE 0) THEN begin
  	key = UDF_Key('IMAGE', 'IMAGE1Q', 'FUV', inst_dir, inst)
  	times =udf_times(key)
  	dummy = where(times.btime.year eq strmid(file,11,4,/reverse_offset) and $
	   times.btime.doy eq strmid(file,7,3,/reverse_offset) and $
	   times.btime.hour eq strmid(file,4,2,/reverse_offset))
  	ENDIF
  starttime=fix([times[dummy[0]].btime.year,times[dummy[0]].btime.doy, $
	times[dummy[0]].btime.hour,times[dummy[0]].btime.min,times[dummy[0]].btime.sec])
  stoptime=fix([times[dummy[0]].etime.year,times[dummy[0]].etime.doy, $
	times[dummy[0]].etime.hour,times[dummy[0]].etime.min,times[dummy[0]].etime.sec])
  catch,/cancel
	; open file and check for error
  if keyword_set(time_list) then return,[[starttime],[stoptime]]
  Catch, err_sts
  IF (err_sts ne 0) THEN BEGIN			
;        result=DIALOG_MESSAGE(!Error_State.Msg)
        return,-1
        ENDIF
  fh  = UDF_Open(key, starttime, stoptime, DFORMAT=1)
  Catch, /Cancel
  endcase
endcase

	; if we just want to know the number of records and their times, 
	; in this case we just throw away everything and return with nrecords
if keyword_set(inventory) then begin
   d = udf_read(fh)
   return_value=replicate({btime:d[0].btime,etime:d[0].etime},16)
   return_value[0].btime=d.btime
   return_value[0].etime=d.etime
   lrec = 1l  	
   WHILE NOT udf_eof(fh) DO BEGIN
       ; If we're out of space in return_value, allocate twice as much space.  
       ; This is a _lot_ more efficient than adding records one-at-a-time.
     IF lrec GE N_Elements(return_value) THEN BEGIN
     	return_value = [return_value,return_value]
     	if not keyword_set(silent) then print,lrec
     	ENDIF
     d = udf_read(fh)
     return_value[lrec].btime=d.btime
     return_value[lrec].etime=d.etime
     lrec = lrec + 1l
     ENDWHILE
   udf_close, fh
   return_value=return_value[0:lrec-1]
   if (not keyword_set(silent)) then print, lrec, format='("[",I0," records read]")'
   return,return_value			; we are done!
   endif 
   
   	; if we want a specific record, we have to read everything until
	; record number equals requested number
	; ugly, isn't it?
	; better way to first determine the time for the specific record
	; and then read the specific time with one_record
if keyword_set(record) then begin
    lrec = -1
    REPEAT BEGIN
     lrec = lrec + 1
     d = udf_read(fh)
     if (not keyword_set(silent)) then print, lrec, format='("[",I0," records read]")'
     ENDREP UNTIL lrec eq record
    udf_close, fh
    return,d
  endif

	; if we want a specific variable over the whole covered time period
	; we have to create the array and throw away everything else
	; this may be a little bit slower than reading everything and
	; just transmitting what we need at the end
	; however for long time series, the size increase for the whole thing
	; can take very long and then it's faster just to increase the
	; part we really need
if keyword_set(variable) then begin
   ppp=where(strupcase(variable) eq 'BTIME',count)
   if (count gt 0) then begin
       print,'BTIME is returned by default'
       return,-1
       endif
   lrec = 0
   d = udf_read(fh)
   for i=0,n_elements(variable)-1 do begin
     ppp=where(tag_names(d) eq variable[i],count)
     if (count ne 1) then begin
       print,'Variable name does not exist'
       udf_close,fh
       return,0
       endif
     endfor
   command='return_value={BTIME:d.btime'
   for i=0,n_elements(variable)-1 do begin
     command=command+','+variable[i]+':d.'+variable[i]
     endfor
   command=command+'}'
   result=execute(command)
	; we initialize with 16 records, we do not have more than 2D
   return_value=replicate(return_value,16)
   lrec=1l
   WHILE NOT udf_eof(fh) DO BEGIN
     d = udf_read(fh)
    	; If we're out of space in return_value, allocate twice as much. This
    	; is a _lot_ more efficient than adding records one-at-a-time.
     if (lrec ge number_of_elements) then begin
         return_value=[[return_value],[return_value]]
         print,lrec
         endif
     return_value[lrec].btime=d.btime
     for i=0,n_elements(variable)-1 do begin
        command='return_value[lrec].'+variable[i]+'=d.'+variable[i]
        result=execute(command)
        endfor
     lrec=lrec+1l
     ENDWHILE
   udf_close, fh
   if (not keyword_set(silent)) then print, lrec+1, format='("[",I0," records read]")'
   return,return_value[0:lrec-1l]
   endif          

	; if we know the specific time and just want one record
if (keyword_set(one_record) and keyword_set(starttime) and $
	keyword_set(stoptime)) then begin
  d = udf_read(fh)
  dd=d
  udf_close, fh
  return,dd
  endif

	; if we know the specific time and want everything
	; here we have to be a little more careful, because DLM returns everything
	; as a vector according to the size of our matrix data
	; we do not want to return all the huge arrays
if (keyword_set(everything)) then begin
  lrec = 0l
  d = udf_read(fh)
  dd=d
        ; First time through: define "l" as an array of "dd" structures
  l = replicate(dd, 16)
  lrec=1l
    WHILE NOT udf_eof(fh) DO BEGIN
     d = udf_read(fh)
        ; If we're out of space in "l", allocate twice as much space.  This
        ; is a _lot_ more efficient than adding records one-at-a-time.
     IF (lrec GE N_Elements(l)) THEN begin l = [l,l] & if ((inst_dir ne 'SAT') and (not keyword_set(silent))) then print,lrec & endif
     l[lrec]=d
     lrec = lrec + 1l
    ENDWHILE
  udf_close, fh
  if (inst_dir ne 'SAT' and not keyword_set(silent)) then print, lrec, format='("[",I0," records read]")'
  ; Return only the number of records read!  
  return,temporary(l[0:lrec-1l])
  endif

	; if we know the specific time and want everything in this time range
if (keyword_set(starttime) and keyword_set(stoptime)) then begin
  lrec = 0l
  d = udf_read(fh)
  dd=d
        ; First time through: define "l" as an array of "d" structures
  l = replicate(dd, 16)
  lrec=1l
  WHILE NOT udf_eof(fh) DO BEGIN
     d = udf_read(fh)
        ; If we're out of space in "l", allocate twice as much space.  This
        ; is a _lot_ more efficient than adding records one-at-a-time.
     IF (lrec GE N_Elements(l)) THEN begin l = [l,l] & if ((inst_dir ne 'SAT') and (not keyword_set(silent))) then print,lrec & endif
     l[lrec]=d
     lrec = lrec + 1l
    ENDWHILE
  udf_close, fh
  if (inst_dir ne 'SAT' and not keyword_set(silent)) then print, lrec, format='("[",I0," records read]")'

  ; Return only the number of records read!  
;  d=0
;  dd=0
;  l=l[0:lrec-1l]
;  return,l
  return,temporary(l[0:lrec-1l])
  endif

end

